import xdeen.helpers as jh
from xdeen.models.utils import store_daily_balance_into_db
from xdeen.services import logger
from xdeen.store import store


def save_daily_portfolio_balance() -> None:
    # # store daily_balance of assets into database
    # if jh.is_livetrading():
    #     for asset_key, asset_value in e.assets.items():
    #         store_daily_balance_into_db({
    #             'id': jh.generate_unique_id(),
    #             'timestamp': jh.now(),
    #             'identifier': jh.get_config('env.identifier', 'main'),
    #             'exchange': e.name,
    #             'asset': asset_key,
    #             'balance': asset_value,
    #         })
    balances = []
    for key, e in store.exchanges.storage.items():
        try:
            balances.append(
                e.assets[jh.app_currency()]
            )
        except KeyError:
            raise ValueError('Invalid quote trading pair. Check your trading route\'s symbol')

    # add open position values
    for key, pos in store.positions.storage.items():
        if pos.is_open:
            balances.append(pos.pnl)

    total = sum(balances)
    store.app.daily_balance.append(total)

    # TEMP: disable storing in database for now
    if not jh.is_livetrading():
        logger.info(f'Saved daily portfolio balance: {round(total, 2)}')
