from typing import Union

import numpy as np
import talib

from xdeen.helpers import get_candle_source
from xdeen.helpers import slice_candles
from xdeen.indicators.ma import ma

def stc(candles: np.ndarray, fast_period: int = 23, fast_matype: int = 1, slow_period: int = 50, slow_matype: int = 1,
        k_period: int = 10, d_period: int = 3,
        source_type: str = "close", sequential: bool = False) -> Union[
    float, np.ndarray]:
    """
    STC - Schaff Trend Cycle (Oscillator)

    :param candles: np.ndarray
    :param fast_period: int - default: 23
    :param fast_matype: int - default: 1
    :param slow_period: int - default: 50
    :param slow_matype: int - default: 1
    :param k_period: int - default: 10
    :param d_period: int - default: 3
    :param source_type: str - default: "close"
    :param sequential: bool - default: False

    :return: float | np.ndarray
    """
    candles = slice_candles(candles, sequential)

    source = get_candle_source(candles, source_type=source_type)

    macd = ma(source, period=fast_period, matype=fast_matype, sequential=True) - ma(source, period=slow_period, matype=slow_matype, sequential=True)

    stok = (macd - talib.MIN(macd, k_period)) / (talib.MAX(macd, k_period) - talib.MIN(macd, k_period)) * 100

    d = talib.EMA(stok, d_period)

    kd = (d - talib.MIN(d, k_period)) / (talib.MAX(d, k_period) - talib.MIN(d, k_period)) * 100

    res = talib.EMA(kd, d_period)

    return res if sequential else res[-1]
