from typing import Union

import numpy as np
import talib

from xdeen.helpers import slice_candles


def midprice(candles: np.ndarray, period: int = 14, sequential: bool = False) -> Union[float, np.ndarray]:
    """
    MIDPRICE - Midpoint Price over period

    :param candles: np.ndarray
    :param period: int - default: 14
    :param sequential: bool - default: False

    :return: float | np.ndarray
    """
    candles = slice_candles(candles, sequential)

    res = talib.MIDPRICE(candles[:, 3], candles[:, 4], timeperiod=period)

    return res if sequential else res[-1]
