/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.PrefixedRootFactory;
import org.javarosa.core.reference.Reference;
import org.javarosa.core.reference.ReferenceFactory;
import org.javarosa.core.reference.RootTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceManager {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceManager.class.getSimpleName());
    private static ReferenceManager instance;
    private List<RootTranslator> translators;
    private List<ReferenceFactory> factories;
    private List<RootTranslator> sessionTranslators;

    private ReferenceManager() {
        logger.debug("created");
        this.translators = new ArrayList<RootTranslator>();
        this.factories = new ArrayList<ReferenceFactory>();
        this.sessionTranslators = new ArrayList<RootTranslator>();
    }

    public void reset() {
        int st;
        int f;
        int t = this.translators.size();
        if (t + (f = this.factories.size()) + (st = this.sessionTranslators.size()) > 0) {
            this.translators.clear();
            this.factories.clear();
            this.sessionTranslators.clear();
            logger.debug("reset translators ({}), session translators ({}), and factories ({})", t, st, f);
        }
    }

    public static ReferenceManager instance() {
        if (instance == null) {
            instance = new ReferenceManager();
        }
        return instance;
    }

    @Deprecated
    public static ReferenceManager __() {
        return ReferenceManager.instance();
    }

    public ReferenceFactory[] getFactories() {
        return this.translators.toArray(new ReferenceFactory[this.translators.size()]);
    }

    public void addRootTranslator(RootTranslator translator) {
        if (!this.translators.contains(translator)) {
            this.translators.add(translator);
            logger.debug("added root translator {}", (Object)translator);
        } else {
            logger.debug("skipped adding already-present root translator {}", (Object)translator);
        }
    }

    public void addReferenceFactory(ReferenceFactory factory) {
        if (!this.factories.contains(factory)) {
            this.factories.add(factory);
            logger.debug("added reference factory {}", (Object)factory);
        } else {
            logger.debug("skipped adding already-present reference factory {}", (Object)factory);
        }
    }

    public boolean removeReferenceFactory(ReferenceFactory factory) {
        boolean removed = this.factories.remove(factory);
        logger.debug("factory {} was " + (removed ? "removed" : "not removed because it was not present"), (Object)factory);
        return removed;
    }

    public Reference deriveReference(String uri) throws InvalidReferenceException {
        return this.deriveReference(uri, (String)null);
    }

    public Reference deriveReference(String uri, Reference context) throws InvalidReferenceException {
        return this.deriveReference(uri, context.getURI());
    }

    public Reference deriveReference(String uri, String context) throws InvalidReferenceException {
        if (uri == null) {
            throw new InvalidReferenceException("Null references aren't valid", uri);
        }
        if (ReferenceManager.isRelative(uri)) {
            if (uri.startsWith("./")) {
                uri = uri.substring(2);
            }
            if (context == null) {
                throw new RuntimeException("Attempted to retrieve local reference with no context");
            }
            Reference reference = this.derivingRoot(context).derive(uri, context);
            logger.debug("{} was derived from {}", (Object)reference.getLocalURI(), (Object)uri);
            return reference;
        }
        Reference reference = this.derivingRoot(uri).derive(uri);
        logger.debug("{} was derived from {}", (Object)reference.getLocalURI(), (Object)uri);
        return reference;
    }

    public void addSessionRootTranslator(RootTranslator translator) {
        this.sessionTranslators.add(translator);
        logger.debug("added session root translator {}", (Object)translator);
    }

    public void clearSession() {
        this.sessionTranslators.clear();
        logger.debug("cleared all session translators");
    }

    private ReferenceFactory derivingRoot(String uri) throws InvalidReferenceException {
        for (List rfs : Arrays.asList(this.sessionTranslators, this.translators, this.factories)) {
            for (ReferenceFactory rf : rfs) {
                if (!rf.derives(uri)) continue;
                return rf;
            }
        }
        throw new InvalidReferenceException(this.getPrettyPrintException(uri), uri);
    }

    private String getPrettyPrintException(String uri) {
        if (uri == null || uri.length() == 0) {
            return "Attempt to derive a blank reference";
        }
        try {
            int endOfRoot;
            String uriRoot = uri;
            String jrRefMessagePortion = "reference type";
            if (uri.contains("jr://")) {
                uriRoot = uri.substring("jr://".length());
                jrRefMessagePortion = "javarosa jr:// reference root";
            }
            if ((endOfRoot = uriRoot.indexOf("://") + "://".length()) == "://".length() - 1) {
                endOfRoot = uriRoot.indexOf("/");
            }
            if (endOfRoot != -1) {
                uriRoot = uriRoot.substring(0, endOfRoot);
            }
            String message = "The reference \"" + uri + "\" was invalid and couldn't be understood. The " + jrRefMessagePortion + " \"" + uriRoot + "\" is not available on this system and may have been mis-typed. Some available roots: ";
            for (RootTranslator rootTranslator : this.sessionTranslators) {
                message = message + "\n" + rootTranslator.prefix;
            }
            for (RootTranslator rootTranslator : this.translators) {
                message = message + "\n" + rootTranslator.prefix;
            }
            for (ReferenceFactory referenceFactory : this.factories) {
                try {
                    if (referenceFactory instanceof PrefixedRootFactory) {
                        for (String rootName : ((PrefixedRootFactory)referenceFactory).roots) {
                            message = message + "\n" + rootName;
                        }
                        continue;
                    }
                    message = message + "\n" + referenceFactory.derive("").getURI();
                }
                catch (Exception exception) {}
            }
            return message;
        }
        catch (Exception e) {
            return "Couldn't process the reference " + uri + " . It may have been entered incorrectly. Note that this doesn't mean that this doesn't mean the file or location referenced couldn't be found, the reference itself was not understood.";
        }
    }

    public static boolean isRelative(String URI2) {
        return URI2.startsWith("./");
    }

    @Deprecated
    public Reference DeriveReference(String uri) throws InvalidReferenceException {
        return this.deriveReference(uri);
    }

    @Deprecated
    public Reference DeriveReference(String uri, Reference context) throws InvalidReferenceException {
        return this.deriveReference(uri, context);
    }

    @Deprecated
    public Reference DeriveReference(String uri, String context) throws InvalidReferenceException {
        return this.deriveReference(uri, context);
    }
}

