# ETHZ IAM Webservice

Manage users, groups and services of the ETH Identity and Access Management system (IAM)

## CLI

```
iam -u <admin_username> group <group-name> -i / --info
iam -u <admin_username> group <group-name> -m / --members
iam -u <admin_username> group <group-name> -d / --delete 

iam -u <admin_username> group <group-name> -a user1 --add user2
iam -u <admin_username> group <group-name> -r user3 --remove user4
```

## Synopsis

### Beginning
```
import ethz_iam_webservice
import getpass

e = ethz_iam_webservice.login('admin4iam', getpass.getpass())
```

### Person
```
person = e.get_person('name@example.com')
person = e.get_person('some_username')
person = e.get_person(123456)             # npid (internal Person identifier)

person.usernames                          # an array of dicts of usernames
person.data                               # raw webservice response
person.firstname
person.familyname
person.email
# etc.
```

### User

```
user = person.new_user('username', 'password', 'description')
user = e.get_user('username')
user.services                             # an array of dicts of services

user.grant_service("LDAPS")
user.grant_service("Active Directory")
user.grant_service("WLAN_VPN")

user.revoke_service("LDAP")

user.delete() 
user.add_to_group('groupname')
user.remove_from_group('groupname')
```

### Group and Group Members

**get single group** - returns a Group object or throws a ValueError if group is not found

```
group = e.get_group('groupname')
group = e.get_group(123456)        # gidNumber
group.data                         # all data received from webservice
group.members                      # returns array of usernames or group-names
group.gidNumber
group.<attribute>
```

**add/remove group members**

```
group.add_members('some', 'new', 'members')
group.set_members('just', 'these')
group.del_members('remove', 'these', 'members')
```

**search for groups** - Result is always a list of groups or an empty list

```
groups = e.get_groups(agroup='ID SIS')
groups = e.get_groups(name='starts_with*')
groups = e.get_groups(agroup='ID SIS', name='starts_with*')
```

### Mailinglists

```
ml = e.get_mailinglist('ID.SIS.SSDM')
ml = e.get_mailinglist('sis@id.ethz.ch')
ml.name
ml.mail
ml.gidNumber
ml.groupType
ml.displayName
...

ml.members        # returns all (direct) members of that list
ml.add_members('user1', 'user2')
ml.del_members('user3, 'user4')
```

See also [FAQ](https://gitlab.ethz.ch/vermeul/ethz-iam-webservice/-/wikis/FAQ)
