/*
Copyright 2019 Eita Nakamura

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef HANDSEPARATIONDATA_MERGEDOUTPUTHMM_HPP
#define HANDSEPARATIONDATA_MERGEDOUTPUTHMM_HPP

#include<iostream>
#include<fstream>
#include<string>
#include<sstream>
#include<vector>
#include<stdio.h>
#include<cmath>
#include<cassert>

using namespace std;

class HandSeparationData_MergedOutputHMM{
public:
	HandSeparationData_MergedOutputHMM(){
		init();
	}//end HandSeparationData_MergedOutputHMM
	~HandSeparationData_MergedOutputHMM(){}//end ~HandSeparationData_MergedOutputHMM

	vector<vector<double> > Lprob;
	vector<vector<double> > uniLprob;
	vector<double> LRLprob;

	void init(){
		Lprob.resize(2);
		uniLprob.resize(2);
		for(int i=0;i<2;i+=1){
			Lprob[i].resize(256);
			uniLprob[i].resize(128);
		}//endfor i
		LRLprob.resize(2);

		double dataLprob[][256]={
			{-10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -8.92457, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -8.23142, -10.0232, -9.33003, -9.33003, -10.0232, -8.92457, -8.92457, -9.33003, -8.63688, -8.92457, -8.41374, -10.0232, -7.94374, -8.92457, -7.82596, -8.23142, -7.02745, -7.94374, -7.45823, -7.13281, -7.07874, -6.30961, -5.94564, -6.58919, -3.60319, -4.72988, -4.39916, -3.87258, -4.27379, -3.70601, -4.02177, -3.3311, -3.16567, -2.76688, -2.14011, -2.42528, -3.31632, -2.38498, -2.40296, -2.76971, -3.12346, -3.13359, -4.12055, -3.74842, -3.9877, -3.80657, -4.41371, -4.77616, -3.57905, -7.07874, -6.72734, -6.35962, -6.72734, -7.38412, -9.33003, -7.94374, -7.45823, -7.94374, -8.63688, -9.33003, -7.62529, -10.0232, -8.63688, -9.33003, -10.0232, -8.63688, -10.0232, -8.92457, -8.92457, -8.92457, -7.94374, -10.0232, -8.92457, -10.0232, -9.33003, -10.0232, -8.92457, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, -10.0232, },
			{-9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.08217, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.08217, -8.6767, -9.77531, -8.6767, -9.08217, -8.38902, -9.77531, -8.6767, -9.77531, -8.16587, -8.6767, -9.77531, -7.57809, -8.6767, -7.69587, -8.38902, -9.08217, -7.69587, -9.77531, -6.88494, -7.98355, -6.88494, -7.29041, -6.68427, -6.30958, -7.06726, -5.96865, -6.06174, -5.73226, -5.28668, -6.01411, -3.34398, -5.00463, -4.36367, -4.20316, -4.1441, -3.18776, -4.01957, -3.41921, -3.22566, -2.77316, -2.33224, -2.7339, -3.55871, -2.66953, -2.38021, -2.5057, -2.95858, -2.96738, -4.26998, -3.47453, -4.26998, -4.24192, -4.67545, -6.13773, -3.22996, -6.68427, -5.69777, -5.57062, -6.08643, -6.24895, -7.13626, -6.03764, -7.13626, -7.69587, -6.9421, -9.08217, -6.51721, -9.77531, -7.57809, -8.38902, -7.98355, -8.6767, -8.38902, -8.38902, -8.6767, -9.77531, -8.6767, -9.77531, -9.08217, -9.77531, -9.77531, -9.77531, -9.08217, -9.77531, -9.08217, -9.08217, -9.77531, -9.77531, -8.6767, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.08217, -9.08217, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, -9.77531, },    
		};
		for(int i=0;i<2;i+=1)for(int j=0;j<256;j+=1){
			Lprob[i][j]=dataLprob[i][j];
		}//endfor i,j

		double datauniLprob[][128]={
			{-10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -8.91946, -8.91946, -8.91946, -8.07215, -8.07215, -8.22631, -7.37901, -7.82084, -6.49171, -6.3545, -6.55233, -6.52155, -6.75996, -5.55216, -5.39309, -5.57541, -4.70486, -4.52913, -4.28149, -4.82511, -3.51678, -3.83391, -3.97306, -3.77002, -3.86534, -3.18073, -3.73393, -3.51228, -3.32971, -3.01773, -2.90086, -3.20462, -2.96621, -2.92882, -3.19587, -2.99253, -3.34857, -3.01318, -3.41277, -3.67594, -3.58191, -3.51828, -3.69013, -4.0068, -4.28473, -4.02161, -4.09114, -4.67573, -4.62444, -4.66621, -5.4331, -5.4129, -6.06682, -5.37367, -6.32919, -5.79856, -6.88257, -6.49171, -6.30449, -7.45312, -6.79919, -7.12769, -8.40863, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, -10.0181, },
			{-9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -8.67009, -9.7687, -8.15926, -8.3824, -8.15926, -8.15926, -7.82279, -6.72418, -5.98451, -6.30296, -6.99611, -5.32605, -5.30279, -5.46463, -5.11474, -4.92451, -4.91667, -5.67435, -3.98795, -4.4754, -4.44083, -3.99726, -3.91362, -3.5581, -4.20418, -3.33255, -3.17292, -3.52259, -3.31193, -3.55409, -2.79142, -3.26891, -3.30723, -3.07166, -3.00712, -2.9049, -3.12361, -3.15263, -3.01409, -3.39538, -3.34059, -3.5501, -3.2979, -3.81805, -4.17399, -4.37507, -4.49058, -4.59255, -5.04131, -5.62556, -5.25784, -6.03103, -6.27219, -6.54982, -6.30296, -7.46611, -7.12964, -7.97694, -7.97694, -8.15926, -8.3824, -8.67009, -8.67009, -8.67009, -9.07555, -8.67009, -9.7687, -9.07555, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, -9.7687, },
		};
		for(int i=0;i<2;i+=1)for(int j=0;j<128;j+=1){
			uniLprob[i][j]=datauniLprob[i][j];
		}//endfor i,j

		LRLprob[0]=-0.5755099333;//log(0.562418)
		LRLprob[1]=-0.82649116217;//log(0.437582)
	}//end init

};//end class HandSeparationData_MergedOutputHMM

#endif // HANDSEPARATIONDATA_MERGEDOUTPUTHMM_HPP
