# Generated by Django 4.0.7 on 2022-11-20 11:34

import django.db.models.deletion
import django.utils.timezone
import easy_thumbnails.fields
import mptt.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=100, unique=True, verbose_name="name"),
                ),
                (
                    "slug",
                    models.SlugField(
                        allow_unicode=True,
                        max_length=100,
                        unique=True,
                        verbose_name="slug",
                    ),
                ),
                (
                    "image",
                    easy_thumbnails.fields.ThumbnailerImageField(
                        blank=True,
                        null=True,
                        upload_to="icon_images",
                        verbose_name="image",
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, null=True, verbose_name="Description"),
                ),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "last_modified_at",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
            ],
            options={
                "verbose_name": "Tag",
                "verbose_name_plural": "Tags",
            },
        ),
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("order", models.IntegerField(default=0, help_text="Ordering number")),
                ("icon", models.SlugField(blank=True, null=True, verbose_name="Icon")),
                (
                    "name",
                    models.CharField(
                        max_length=80, unique=True, verbose_name="Category Name"
                    ),
                ),
                (
                    "slug",
                    models.SlugField(
                        blank=True,
                        editable=False,
                        max_length=80,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "image",
                    easy_thumbnails.fields.ThumbnailerImageField(
                        blank=True,
                        null=True,
                        upload_to="icon_images",
                        verbose_name="image",
                    ),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        help_text="Categories, unlike tags, can have a hierarchy. You might have a Jazz category, and under that have children categories for Bebop and Big Band. Totally optional.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="children",
                        to="coreplus_tags.category",
                    ),
                ),
            ],
            options={
                "verbose_name": "Category",
                "verbose_name_plural": "Categories",
                "ordering": ["name"],
                "permissions": (
                    ("import_category", "Can import Category"),
                    ("export_category", "Can export Category"),
                ),
            },
        ),
    ]
