# Generated by Django 4.1 on 2022-11-16 18:12

import django.db.models.deletion
import easy_thumbnails.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="MediaSetting",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "max_file_size",
                    models.DecimalField(
                        decimal_places=2,
                        default=5.0,
                        help_text="Set maximum size for an uploaded file",
                        max_digits=5,
                        null=True,
                        verbose_name="Max Image Size in Megabyte",
                    ),
                ),
                (
                    "image_extensions",
                    models.TextField(
                        blank=True,
                        help_text="A comma-separated list of image extensions.",
                        null=True,
                        verbose_name="Accepted Image Extensions",
                    ),
                ),
                (
                    "video_extensions",
                    models.TextField(
                        blank=True,
                        help_text="A comma-separated list of video extensions.",
                        null=True,
                        verbose_name="Accepted Video Extensions",
                    ),
                ),
                (
                    "audio_extensions",
                    models.TextField(
                        blank=True,
                        help_text="A comma-separated list of audio extensions.",
                        null=True,
                        verbose_name="Accepted Audio Extensions",
                    ),
                ),
                (
                    "document_extensions",
                    models.TextField(
                        blank=True,
                        help_text="A comma-separated list of document extensions.",
                        null=True,
                        verbose_name="Accepted Document Extensions",
                    ),
                ),
                (
                    "site",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Media Setting",
                "verbose_name_plural": "Media Settings",
            },
        ),
        migrations.CreateModel(
            name="ImageGallery",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveIntegerField()),
                (
                    "image",
                    easy_thumbnails.fields.ThumbnailerImageField(
                        null=True,
                        upload_to="active_service_galleries",
                        verbose_name="image",
                    ),
                ),
                (
                    "caption",
                    models.CharField(
                        blank=True,
                        help_text="Image title.",
                        max_length=255,
                        null=True,
                        verbose_name="caption",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="Description.",
                        null=True,
                        verbose_name="description",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="galleries",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Image Gallery",
                "verbose_name_plural": "Image Galleries",
                "unique_together": {("content_type", "object_id")},
            },
        ),
    ]
