# Generated by Django 4.1 on 2022-11-16 18:12

import django.db.models.deletion
import django.utils.timezone
import mptt.fields
from django.conf import settings
from django.db import migrations, models

import coreplus.utils.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Discuss",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "reaction",
                    models.JSONField(
                        editable=False,
                        help_text='JSON fields contains {"like": 1, "love":2, "flap":3}',
                        verbose_name="reaction",
                    ),
                ),
                (
                    "flag",
                    models.JSONField(
                        editable=False,
                        help_text='JSON fields contains {"spam": 1, "hoax":2, "bullying":3}',
                        verbose_name="flag",
                    ),
                ),
                (
                    "created",
                    coreplus.utils.models.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    coreplus.utils.models.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "object_id",
                    models.PositiveIntegerField(
                        blank=True, help_text="Parent comented object id.", null=True
                    ),
                ),
                ("content", models.TextField(verbose_name="Content")),
                (
                    "content_html",
                    models.TextField(editable=False, verbose_name="Content HTML"),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        help_text="Parent comented content type.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        help_text="Discuss can have a hierarchy, totally optional.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="children",
                        to="coreplus_discuss.discuss",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="discuss",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Discuss",
                "verbose_name_plural": "Discuss",
            },
        ),
    ]
