# Copyright 2021 Agnostiq Inc.
#
# This file is part of Covalent.
#
# Licensed under the GNU Affero General Public License 3.0 (the "License").
# A copy of the License may be obtained with this software package or at
#
#      https://www.gnu.org/licenses/agpl-3.0.en.html
#
# Use of this file is prohibited except in compliance with the License. Any
# modifications or derivative works of this file must retain this copyright
# notice, and modified files must contain a notice indicating that they have
# been altered from the originals.
#
# Covalent is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the License for more details.
#
# Relief from the License may be granted by purchasing a commercial license.

"""init

Revision ID: b60c5ecdf927
Revises:
Create Date: 2022-07-19 16:31:18.833092

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
# pragma: allowlist nextline secret
revision = "b60c5ecdf927"
# pragma: allowlist nextline secret
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "electron_dependency",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("electron_id", sa.Integer(), nullable=False),
        sa.Column("parent_electron_id", sa.Integer(), nullable=False),
        sa.Column("edge_name", sa.Text(), nullable=False),
        sa.Column("parameter_type", sa.String(length=24), nullable=True),
        sa.Column("arg_index", sa.Integer(), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column(
            "updated_at",
            sa.DateTime(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=True,
        ),
        sa.Column(
            "created_at",
            sa.DateTime(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "lattices",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("dispatch_id", sa.String(length=64), nullable=False),
        sa.Column("electron_id", sa.Integer(), nullable=True),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("status", sa.String(length=24), nullable=False),
        sa.Column("electron_num", sa.Integer(), nullable=False),
        sa.Column("completed_electron_num", sa.Integer(), nullable=False),
        sa.Column("storage_type", sa.Text(), nullable=True),
        sa.Column("storage_path", sa.Text(), nullable=True),
        sa.Column("function_filename", sa.Text(), nullable=True),
        sa.Column("function_string_filename", sa.Text(), nullable=True),
        sa.Column("executor_filename", sa.Text(), nullable=True),
        sa.Column("error_filename", sa.Text(), nullable=True),
        sa.Column("inputs_filename", sa.Text(), nullable=True),
        sa.Column("results_filename", sa.Text(), nullable=True),
        sa.Column("transport_graph_filename", sa.Text(), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=False,
        ),
        sa.Column("started_at", sa.DateTime(), nullable=True),
        sa.Column("completed_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "electrons",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("parent_lattice_id", sa.Integer(), nullable=False),
        sa.Column("transport_graph_node_id", sa.Integer(), nullable=False),
        sa.Column("type", sa.String(length=24), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("status", sa.String(length=24), nullable=False),
        sa.Column("storage_type", sa.Text(), nullable=True),
        sa.Column("storage_path", sa.Text(), nullable=True),
        sa.Column("function_filename", sa.Text(), nullable=True),
        sa.Column("function_string_filename", sa.Text(), nullable=True),
        sa.Column("executor_filename", sa.Text(), nullable=True),
        sa.Column("results_filename", sa.Text(), nullable=True),
        sa.Column("value_filename", sa.Text(), nullable=True),
        sa.Column("attribute_name", sa.Text(), nullable=True),
        sa.Column("key_filename", sa.Text(), nullable=True),
        sa.Column("stdout_filename", sa.Text(), nullable=True),
        sa.Column("deps_filename", sa.Text(), nullable=True),
        sa.Column("call_before_filename", sa.Text(), nullable=True),
        sa.Column("call_after_filename", sa.Text(), nullable=True),
        sa.Column("stderr_filename", sa.Text(), nullable=True),
        sa.Column("info_filename", sa.Text(), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=False,
        ),
        sa.Column("started_at", sa.DateTime(), nullable=True),
        sa.Column("completed_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["parent_lattice_id"],
            ["lattices.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("electrons")
    op.drop_table("lattices")
    op.drop_table("electron_dependency")
    # ### end Alembic commands ###
