import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type AWSQS::Iridium::CloudConnectQS::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * Amazon Resource Number (ARN) of the role in the Iridium AWS account.
     *
     * @schema CfnModulePropsParameters#IridiumRoleARN
     */
    readonly iridiumRoleArn?: CfnModulePropsParametersIridiumRoleArn;
    /**
     * Name of the mobile-originated queue in Amazon SQS.
     *
     * @schema CfnModulePropsParameters#MobileOriginatedQueueName
     */
    readonly mobileOriginatedQueueName?: CfnModulePropsParametersMobileOriginatedQueueName;
    /**
     * Name of the mobile-terminated queue in Amazon SQS.
     *
     * @schema CfnModulePropsParameters#MobileTerminatedQueueName
     */
    readonly mobileTerminatedQueueName?: CfnModulePropsParametersMobileTerminatedQueueName;
    /**
     * Name of the mobile-terminated confirmation queue in Amazon SQS.
     *
     * @schema CfnModulePropsParameters#MobileTerminatedConfirmationQueueName
     */
    readonly mobileTerminatedConfirmationQueueName?: CfnModulePropsParametersMobileTerminatedConfirmationQueueName;
    /**
     * Name of the mobile-terminated error queue in Amazon SQS.
     *
     * @schema CfnModulePropsParameters#MobileTerminatedErrorQueueName
     */
    readonly mobileTerminatedErrorQueueName?: CfnModulePropsParametersMobileTerminatedErrorQueueName;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#MobileOriginatedSQSQueue
     */
    readonly mobileOriginatedSqsQueue?: CfnModulePropsResourcesMobileOriginatedSqsQueue;
    /**
     * @schema CfnModulePropsResources#MobileTerminatedSQSQueue
     */
    readonly mobileTerminatedSqsQueue?: CfnModulePropsResourcesMobileTerminatedSqsQueue;
    /**
     * @schema CfnModulePropsResources#MobileTerminatedConfirmationSQSQueue
     */
    readonly mobileTerminatedConfirmationSqsQueue?: CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue;
    /**
     * @schema CfnModulePropsResources#MobileTerminatedErrorSQSQueue
     */
    readonly mobileTerminatedErrorSqsQueue?: CfnModulePropsResourcesMobileTerminatedErrorSqsQueue;
    /**
     * @schema CfnModulePropsResources#SQSQueueCrossAccountPolicy
     */
    readonly sqsQueueCrossAccountPolicy?: CfnModulePropsResourcesSqsQueueCrossAccountPolicy;
    /**
     * @schema CfnModulePropsResources#SQSCrossAccountRole
     */
    readonly sqsCrossAccountRole?: CfnModulePropsResourcesSqsCrossAccountRole;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Amazon Resource Number (ARN) of the role in the Iridium AWS account.
 *
 * @schema CfnModulePropsParametersIridiumRoleArn
 */
export interface CfnModulePropsParametersIridiumRoleArn {
    /**
     * @schema CfnModulePropsParametersIridiumRoleArn#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersIridiumRoleArn#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersIridiumRoleArn' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersIridiumRoleArn(obj: CfnModulePropsParametersIridiumRoleArn | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-originated queue in Amazon SQS.
 *
 * @schema CfnModulePropsParametersMobileOriginatedQueueName
 */
export interface CfnModulePropsParametersMobileOriginatedQueueName {
    /**
     * @schema CfnModulePropsParametersMobileOriginatedQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersMobileOriginatedQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersMobileOriginatedQueueName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersMobileOriginatedQueueName(obj: CfnModulePropsParametersMobileOriginatedQueueName | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-terminated queue in Amazon SQS.
 *
 * @schema CfnModulePropsParametersMobileTerminatedQueueName
 */
export interface CfnModulePropsParametersMobileTerminatedQueueName {
    /**
     * @schema CfnModulePropsParametersMobileTerminatedQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersMobileTerminatedQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersMobileTerminatedQueueName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersMobileTerminatedQueueName(obj: CfnModulePropsParametersMobileTerminatedQueueName | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-terminated confirmation queue in Amazon SQS.
 *
 * @schema CfnModulePropsParametersMobileTerminatedConfirmationQueueName
 */
export interface CfnModulePropsParametersMobileTerminatedConfirmationQueueName {
    /**
     * @schema CfnModulePropsParametersMobileTerminatedConfirmationQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersMobileTerminatedConfirmationQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersMobileTerminatedConfirmationQueueName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersMobileTerminatedConfirmationQueueName(obj: CfnModulePropsParametersMobileTerminatedConfirmationQueueName | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-terminated error queue in Amazon SQS.
 *
 * @schema CfnModulePropsParametersMobileTerminatedErrorQueueName
 */
export interface CfnModulePropsParametersMobileTerminatedErrorQueueName {
    /**
     * @schema CfnModulePropsParametersMobileTerminatedErrorQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersMobileTerminatedErrorQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersMobileTerminatedErrorQueueName' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersMobileTerminatedErrorQueueName(obj: CfnModulePropsParametersMobileTerminatedErrorQueueName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesMobileOriginatedSqsQueue
 */
export interface CfnModulePropsResourcesMobileOriginatedSqsQueue {
    /**
     * @schema CfnModulePropsResourcesMobileOriginatedSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesMobileOriginatedSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesMobileOriginatedSqsQueue' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesMobileOriginatedSqsQueue(obj: CfnModulePropsResourcesMobileOriginatedSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesMobileTerminatedSqsQueue
 */
export interface CfnModulePropsResourcesMobileTerminatedSqsQueue {
    /**
     * @schema CfnModulePropsResourcesMobileTerminatedSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesMobileTerminatedSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesMobileTerminatedSqsQueue' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesMobileTerminatedSqsQueue(obj: CfnModulePropsResourcesMobileTerminatedSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue
 */
export interface CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue {
    /**
     * @schema CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue(obj: CfnModulePropsResourcesMobileTerminatedConfirmationSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesMobileTerminatedErrorSqsQueue
 */
export interface CfnModulePropsResourcesMobileTerminatedErrorSqsQueue {
    /**
     * @schema CfnModulePropsResourcesMobileTerminatedErrorSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesMobileTerminatedErrorSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesMobileTerminatedErrorSqsQueue' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesMobileTerminatedErrorSqsQueue(obj: CfnModulePropsResourcesMobileTerminatedErrorSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesSqsQueueCrossAccountPolicy
 */
export interface CfnModulePropsResourcesSqsQueueCrossAccountPolicy {
    /**
     * @schema CfnModulePropsResourcesSqsQueueCrossAccountPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesSqsQueueCrossAccountPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesSqsQueueCrossAccountPolicy' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesSqsQueueCrossAccountPolicy(obj: CfnModulePropsResourcesSqsQueueCrossAccountPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesSqsCrossAccountRole
 */
export interface CfnModulePropsResourcesSqsCrossAccountRole {
    /**
     * @schema CfnModulePropsResourcesSqsCrossAccountRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesSqsCrossAccountRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesSqsCrossAccountRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesSqsCrossAccountRole(obj: CfnModulePropsResourcesSqsCrossAccountRole | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::Iridium::CloudConnectQS::MODULE`.
 *
 * @external
 * @cloudformationResource AWSQS::Iridium::CloudConnectQS::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::Iridium::CloudConnectQS::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `AWSQS::Iridium::CloudConnectQS::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
