"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackApp = exports.SlackAppManifestDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
const manifest_1 = require("./manifest");
const provider_1 = require("./provider");
/**
 * A Slack app manifest definition.
 *
 * @stability stable
 */
class SlackAppManifestDefinition {
    /**
     * Create a Slack app manifest from a JSON app manifest encoded as a string.
     *
     * @stability stable
     */
    static fromString(manifest) {
        return new StringManifest(manifest);
    }
    /**
     * Creates a Slack app manifest from a file containg a JSON app manifest.
     *
     * @stability stable
     */
    static fromFile(file) {
        return new FileManifest(file);
    }
    /**
     * Creates a Slack app manifest by specifying properties.
     *
     * @stability stable
     */
    static fromManifest(props) {
        return new manifest_1.SlackAppManifest(props);
    }
}
exports.SlackAppManifestDefinition = SlackAppManifestDefinition;
_a = JSII_RTTI_SYMBOL_1;
SlackAppManifestDefinition[_a] = { fqn: "cloudstructs.SlackAppManifestDefinition", version: "0.4.19" };
class StringManifest extends SlackAppManifestDefinition {
    constructor(manifest) {
        super();
        this.manifest = manifest;
    }
    render(_construct) {
        return this.manifest;
    }
}
class FileManifest extends SlackAppManifestDefinition {
    constructor(file) {
        super();
        this.file = file;
    }
    render(_construct) {
        return fs.readFileSync(this.file, 'utf8');
    }
}
/**
 * A Slack application deployed with a manifest.
 *
 * @see https://api.slack.com/reference/manifests
 * @stability stable
 */
class SlackApp extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        const provider = provider_1.SlackAppProvider.getOrCreate(this);
        props.configurationTokenSecret.grantRead(provider.handler);
        props.configurationTokenSecret.grantWrite(provider.handler);
        this.credentials = (_c = props.credentialsSecret) !== null && _c !== void 0 ? _c : new secretsmanager.Secret(this, 'Credentials', {
            description: `Credentials for Slack App ${this.node.id}`,
        });
        this.credentials.grantWrite(provider.handler);
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::SlackApp',
            properties: {
                manifest: props.manifest.render(this),
                configurationTokenSecretArn: props.configurationTokenSecret.secretArn,
                credentialsSecretArn: this.credentials.secretArn,
            },
        });
        this.appId = resource.getAttString('appId');
        this.clientId = this.credentials.secretValueFromJson('clientId').toString();
        this.clientSecret = this.credentials.secretValueFromJson('clientSecret').toString();
        this.verificationToken = this.credentials.secretValueFromJson('verificationToken').toString();
        this.signingSecret = this.credentials.secretValueFromJson('signingSecret').toString();
    }
}
exports.SlackApp = SlackApp;
_b = JSII_RTTI_SYMBOL_1;
SlackApp[_b] = { fqn: "cloudstructs.SlackApp", version: "0.4.19" };
//# sourceMappingURL=data:application/json;base64,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