"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsServiceRoller = exports.RollTrigger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
/**
 * The rule or schedule that should trigger a roll.
 *
 * @stability stable
 */
class RollTrigger {
    /**
     * Schedule that should trigger a roll.
     *
     * @stability stable
     */
    static fromSchedule(schedule) {
        return { schedule };
    }
    /**
     * Rule that should trigger a roll.
     *
     * @stability stable
     */
    static fromRule(rule) {
        return { rule };
    }
}
exports.RollTrigger = RollTrigger;
_a = JSII_RTTI_SYMBOL_1;
RollTrigger[_a] = { fqn: "cloudstructs.RollTrigger", version: "0.4.19" };
/**
 * Roll your ECS service tasks on schedule or with a rule.
 *
 * @stability stable
 */
class EcsServiceRoller extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f;
        super(scope, id);
        const rule = (_d = (_c = props.trigger) === null || _c === void 0 ? void 0 : _c.rule) !== null && _d !== void 0 ? _d : new events.Rule(this, 'Rule', {
            schedule: (_f = (_e = props.trigger) === null || _e === void 0 ? void 0 : _e.schedule) !== null && _f !== void 0 ? _f : events.Schedule.cron({
                minute: '0',
                hour: '0',
            }),
        });
        rule.addTarget(new targets.AwsApi({
            service: 'ECS',
            action: 'updateService',
            parameters: {
                service: props.service.serviceName,
                cluster: props.cluster.clusterName,
                forceNewDeployment: true,
            },
            // https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-supported-iam-actions-resources.html
            // arn:aws:ecs:<region>:<account>:service/<cluster-name>/<service-name>
            policyStatement: new iam.PolicyStatement({
                actions: ['ecs:UpdateService'],
                resources: [aws_cdk_lib_1.Stack.of(this).formatArn({
                        service: 'ecs',
                        resource: 'service',
                        resourceName: `${props.cluster.clusterName}/${props.service.serviceName}`,
                    })],
            }),
        }));
    }
}
exports.EcsServiceRoller = EcsServiceRoller;
_b = JSII_RTTI_SYMBOL_1;
EcsServiceRoller[_b] = { fqn: "cloudstructs.EcsServiceRoller", version: "0.4.19" };
//# sourceMappingURL=data:application/json;base64,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