<p align="center">
  <a href="https://pub.dev/packages/flutter_gen">
    <img src="https://github.com/tien-px/pt_flutter_gen/raw/main/images/logo.png" width="480px"/>
  </a>
</p>

[![PyPI - Version](https://img.shields.io/pypi/v/flutter_gen)](https://pypi.org/project/flutter_gen/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/flutter_gen)](https://pypi.org/project/flutter_gen/)
[![Windows - Supported](https://img.shields.io/badge/windows-supported-success?logo=windows&logoColor=dddddd)](#)
[![MacOS - Supported](https://img.shields.io/badge/macos-supported-success?logo=apple&logoColor=dddddd)](#)

The Flutter code generator for your assets, fonts, colors,… to **`increase your productivity`**.

Inspired by [FlutterGen](https://github.com/FlutterGen/flutter_gen).

## Installation

### Python

Window

```sh
$ https://www.python.org/downloads/
```

Mac OS

```sh
$ brew install python3
```

### FlutterGen

Works with MacOS and Windows.

Window

```sh
$ pip install flutter_gen
```

Mac OS
```sh
$ pip3 install flutter_gen
```

Update via command line:

```sh
$ pip3 install -U flutter_gen
```

## Usage

Run `flutter_gen` after the configuration [`pubspec.yaml`](https://dart.dev/tools/pub/pubspec).

```sh
$ flutter_gen -h

$ flutter_gen watch
```

## Android Studio Plugin

* [Install Plugin](https://github.com/tien-px/pt_flutter_gen/tree/main/intellji)

## Configuration file

[FlutterGen]() generates dart files based on the key **`flutter`** of [`pubspec.yaml`](https://dart.dev/tools/pub/pubspec).  
Default configuration can be found [here](#default-configuration). 

```yaml
# pubspec.yaml
# ...
flutter:
  uses-material-design: true
  assets:
    - assets/images/

  fonts:
    - family: Raleway
      fonts:
        - asset: assets/fonts/Raleway-Regular.ttf
        - asset: assets/fonts/Raleway-Italic.ttf
          style: italic
```

## Available Parsers

### Assets

Just follow the doc [Adding assets and images#Specifying assets](https://flutter.dev/docs/development/ui/assets-and-images#specifying-assets) to specify assets, then [FlutterGen]() will generate related dart files.  
No other specific configuration is required.  
_Ignore duplicated._

```yaml
# pubspec.yaml
flutter:
  assets:
    - assets/images
```

These configurations will generate **`images.g.dart`** under the **`lib/generated/`** directory by default.

#### Usage Example

[FlutterGen]() generates [Image](https://api.flutter.dev/flutter/widgets/Image-class.html) class if the asset is Flutter supported image format.

Example results of `assets/images/chip.jpg`:

- **`Images.chip`** is an implementation of [`AssetImage class`](https://api.flutter.dev/flutter/painting/AssetImage-class.html).
- **`Images.chip.image(...)`** returns [`Image class`](https://api.flutter.dev/flutter/widgets/Image-class.html).
- **`Images.chip.path`** just returns the path string.

```dart
Widget build(BuildContext context) {
  return Image(image: Images.chip);
}

Widget build(BuildContext context) {
  return Images.chip.image(
    width: 120,
    height: 120,
    fit: BoxFit.scaleDown,
  );

Widget build(BuildContext context) {
  // Images.chip.path = 'assets/images/chip3/chip3.jpg'
  return Image.asset(Images.chip.path);
}

```

If you are using SVG images with [flutter_svg](https://pub.dev/packages/flutter_svg) you can use as:

```dart
Widget build(BuildContext context) {
  return Images.paint.svg(
    width: 120,
    height: 120
  );
}
```

<details><summary>Example of code generated by FlutterGen</summary>
<p>

```dart
/// DO NOT EDIT. This is code generated via flutter_gen

import 'package:flutter/widgets.dart';
import 'package:flutter_svg/flutter_svg.dart';

const _assetsImagePath = 'assets/images';

class Images {
  static AssetGenImage get chip => const AssetGenImage('$_assetsImagePath/chip.png');
  static SvgGenImage get paint => const SvgGenImage('$_assetsImagePath/paint.svg');
}

class AssetGenImage extends AssetImage {
  const AssetGenImage(String assetName) : super(assetName);

  Image image({
    Key? key,
    ImageFrameBuilder? frameBuilder,
    ImageLoadingBuilder? loadingBuilder,
    ImageErrorWidgetBuilder? errorBuilder,
    String? semanticLabel,
    bool excludeFromSemantics = false,
    double? width,
    double? height,
    Color? color,
    BlendMode? colorBlendMode,
    BoxFit? fit,
    AlignmentGeometry alignment = Alignment.center,
    ImageRepeat repeat = ImageRepeat.noRepeat,
    Rect? centerSlice,
    bool matchTextDirection = false,
    bool gaplessPlayback = false,
    bool isAntiAlias = false,
    FilterQuality filterQuality = FilterQuality.low,
  }) {
    return Image(
      key: key,
      image: this,
      frameBuilder: frameBuilder,
      loadingBuilder: loadingBuilder,
      errorBuilder: errorBuilder,
      semanticLabel: semanticLabel,
      excludeFromSemantics: excludeFromSemantics,
      width: width,
      height: height,
      color: color,
      colorBlendMode: colorBlendMode,
      fit: fit,
      alignment: alignment,
      repeat: repeat,
      centerSlice: centerSlice,
      matchTextDirection: matchTextDirection,
      gaplessPlayback: gaplessPlayback,
      isAntiAlias: isAntiAlias,
      filterQuality: filterQuality,
    );
  }

  String get path => assetName;
}

class SvgGenImage {
  const SvgGenImage(this._assetName);

  final String _assetName;

  SvgPicture svg({
    Key? key,
    bool matchTextDirection = false,
    AssetBundle? bundle,
    String? package,
    double? width,
    double? height,
    BoxFit fit = BoxFit.contain,
    AlignmentGeometry alignment = Alignment.center,
    bool allowDrawingOutsideViewBox = false,
    WidgetBuilder? placeholderBuilder,
    Color? color,
    BlendMode colorBlendMode = BlendMode.srcIn,
    String? semanticsLabel,
    bool excludeFromSemantics = false,
    Clip clipBehavior = Clip.hardEdge,
  }) {
    return SvgPicture.asset(
      _assetName,
      key: key,
      matchTextDirection: matchTextDirection,
      bundle: bundle,
      package: package,
      width: width,
      height: height,
      fit: fit,
      alignment: alignment,
      allowDrawingOutsideViewBox: allowDrawingOutsideViewBox,
      placeholderBuilder: placeholderBuilder,
      color: color,
      colorBlendMode: colorBlendMode,
      semanticsLabel: semanticsLabel,
      excludeFromSemantics: excludeFromSemantics,
      clipBehavior: clipBehavior,
    );
  }

  String get path => _assetName;
}
```

</p>
</details>

### Fonts

Just follow the doc [Use a custom font](https://flutter.dev/docs/cookbook/design/fonts) to specify fonts, then [FlutterGen]() will generate related dart files.  
No other specific configuration is required.  
_Ignore duplicated._

```yaml
# pubspec.yaml
flutter:
  fonts:
    - family: Raleway
      fonts:
        - asset: assets/fonts/Raleway-Regular.ttf
        - asset: assets/fonts/Raleway-Italic.ttf
          style: italic
    - family: RobotoMono
      fonts:
        - asset: assets/fonts/RobotoMono-Regular.ttf
        - asset: assets/fonts/RobotoMono-Bold.ttf
          weight: 700
```

These configurations will generate **`fonts.g.dart`** under the **`lib/generated/`** directory by default.

#### Usage Example

```dart
Text(
  'Hi there, I\'m FlutterGen',
  style: TextStyle(
    fontFamily: FontFamily.robotoMono,
    fontFamilyFallback: const [FontFamily.raleway],
  ),
```

<details><summary>Example of code generated by FlutterGen</summary>
<p>

```dart
/// DO NOT EDIT. This is code generated via flutter_gen

class FontFamily {
  FontFamily._();

  static const String raleway = 'Raleway';
  static const String robotoMono = 'RobotoMono';
}

```

</p>
</details>

### Colors

[FlutterGen]() supports generating colors from [TXT](assets/color/colors.txt) format files.  
_Ignore duplicated._

[FlutterGen]() can generate a [Color](https://api.flutter.dev/flutter/material/Colors-class.html) class based on the color `hex` value.

```txt
#F5CB84
#955E1C
```

These configurations will generate **`colors.g.dart`** under the **`lib/generated/`** directory by default.

#### Usage Example

```dart
Text(
  'Hi there, I\'m FlutterGen',
  style: TextStyle(
    color: ColorName.hexF5CB84,
  ),
```

<details><summary>Example of code generated by FlutterGen</summary>
<p>

```dart
import 'package:flutter/material.dart';

class ColorName {
  ColorName._();
  
  static const Color hexF5CB84 = Color(0xFFF5CB84);
  static const Color hex955E1C = Color(0xFF955E1C);
}
```

</p>
</details>

## Issues

Please file [FlutterGen]() specific issues, bugs, or feature requests in our [issue tracker](https://github.com/tien-px/flutter_gen/issues/new).

<!-- ## Generate
### 1. Generate image class:
```
$ flutter_gen gen image
```
<details>
<summary>📑 Example</summary>

```dart
const _assetsImagePath = 'assets/images';

class Images {
  static const test = '$_assetsImagePath/test.png';
}
```
</details>

### 2. Generate localization class:
```
$ flutter_gen gen localization
```
<details>
<summary>📑 Example</summary>

```dart
class i18n {
  static String get test => 'test'.tr();
}
```
</details>

### 3. Generate router class:
```
$ flutter_gen gen router
```
<details>
<summary>📑 Example</summary>

```dart
Future? toHome({int? id}) {}

Future? offAllHome({int? id}) {}

Future? offAndToHome({int? id}) {}

Future? offHome({int? id}) {}

Future? offUntilHome({int? id}) {}
```
</details>

### 4. Sync:
#### Run all generate command
```
$ flutter_gen sync
``` -->