import { Test } from 'nodeunit';
declare const _default: {
    'When creating a Mesh': {
        'with no spec applied': {
            'should defaults to DROP_ALL egress filter'(test: Test): void;
        };
        'with spec applied': {
            'should take egress filter from props'(test: Test): void;
        };
    };
    'When adding a Virtual Router to existing mesh': {
        'with at least one complete port mappings': {
            'shoulld create proper router'(test: Test): void;
        };
    };
    'VirtualService can use CloudMap service'(test: Test): void;
    'When adding a VirtualService to a mesh': {
        'with VirtualRouter and VirtualNode as providers': {
            'should throw error'(test: Test): void;
        };
        'with single virtual router provider resource': {
            'should create service'(test: Test): void;
        };
        'with single virtual node provider resource': {
            'should create service'(test: Test): void;
        };
    };
    'When adding a VirtualNode to a mesh': {
        'with empty default listeners and backends': {
            'should create default resource'(test: Test): void;
        };
        'with added listeners': {
            'should create listener resource'(test: Test): void;
        };
        'with added listeners with healthchecks': {
            'should create healthcheck resource'(test: Test): void;
        };
        'with backends': {
            'should create resource with service backends'(test: Test): void;
        };
    };
    'Can construct a mesh from a name'(test: Test): void;
};
export = _default;
