"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchResult = exports.Matcher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Represents a matcher that can perform special data matching capabilities between a given pattern and a target.
 *
 * @experimental
 */
class Matcher {
    /**
     * (experimental) Check whether the provided object is a subtype of the `IMatcher`.
     *
     * @experimental
     */
    static isMatcher(x) {
        return x && x instanceof Matcher;
    }
}
exports.Matcher = Matcher;
_a = JSII_RTTI_SYMBOL_1;
Matcher[_a] = { fqn: "@aws-cdk/assertions.Matcher", version: "1.128.0" };
/**
 * (experimental) The result of `Match.test()`.
 *
 * @experimental
 */
class MatchResult {
    /**
     * @experimental
     */
    constructor(target) {
        this.failures = [];
        this.target = target;
    }
    /**
     * (experimental) Push a new failure into this result at a specific path.
     *
     * If the failure occurred at root of the match tree, set the path to an empty list.
     * If it occurs in the 5th index of an array nested within the 'foo' key of an object,
     * set the path as `['/foo', '[5]']`.
     *
     * @param path the path at which the failure occurred.
     * @param message the failure.
     * @experimental
     */
    push(matcher, path, message) {
        this.failures.push({ matcher, path, message });
        return this;
    }
    /**
     * (experimental) Does the result contain any failures.
     *
     * If not, the result is a success
     *
     * @experimental
     */
    hasFailed() {
        return this.failures.length !== 0;
    }
    /**
     * (experimental) The number of failures.
     *
     * @experimental
     */
    get failCount() {
        return this.failures.length;
    }
    /**
     * (experimental) Compose the results of a previous match as a subtree.
     *
     * @param id the id of the parent tree.
     * @experimental
     */
    compose(id, inner) {
        const innerF = inner.failures;
        this.failures.push(...innerF.map(f => {
            return { path: [id, ...f.path], message: f.message, matcher: f.matcher };
        }));
        return this;
    }
    /**
     * (experimental) Get the list of failures as human readable strings.
     *
     * @experimental
     */
    toHumanStrings() {
        return this.failures.map(r => {
            const loc = r.path.length === 0 ? '' : ` at ${r.path.join('')}`;
            return '' + r.message + loc + ` (using ${r.matcher.name} matcher)`;
        });
    }
}
exports.MatchResult = MatchResult;
_b = JSII_RTTI_SYMBOL_1;
MatchResult[_b] = { fqn: "@aws-cdk/assertions.MatchResult", version: "1.128.0" };
//# sourceMappingURL=data:application/json;base64,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