"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Capture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const matcher_1 = require("./matcher");
const type_1 = require("./private/type");
/**
 * (experimental) Capture values while matching templates.
 *
 * Using an instance of this class within a Matcher will capture the matching value.
 * The `as*()` APIs on the instance can be used to get the captured value.
 *
 * @experimental
 */
class Capture extends matcher_1.Matcher {
    /**
     * @experimental
     */
    constructor() {
        super();
        this.value = null;
        this.name = 'Capture';
    }
    /**
     * (experimental) Test whether a target matches the provided pattern.
     *
     * Every Matcher must implement this method.
     * This method will be invoked by the assertions framework. Do not call this method directly.
     *
     * @experimental
     */
    test(actual) {
        this.value = actual;
        const result = new matcher_1.MatchResult(actual);
        if (actual == null) {
            result.push(this, [], `Can only capture non-nullish values. Found ${actual}`);
        }
        return result;
    }
    /**
     * (experimental) Retrieve the captured value as a string.
     *
     * An error is generated if no value is captured or if the value is not a string.
     *
     * @experimental
     */
    asString() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'string') {
            return this.value;
        }
        this.reportIncorrectType('string');
    }
    /**
     * (experimental) Retrieve the captured value as a number.
     *
     * An error is generated if no value is captured or if the value is not a number.
     *
     * @experimental
     */
    asNumber() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'number') {
            return this.value;
        }
        this.reportIncorrectType('number');
    }
    /**
     * (experimental) Retrieve the captured value as a boolean.
     *
     * An error is generated if no value is captured or if the value is not a boolean.
     *
     * @experimental
     */
    asBoolean() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'boolean') {
            return this.value;
        }
        this.reportIncorrectType('boolean');
    }
    /**
     * (experimental) Retrieve the captured value as an array.
     *
     * An error is generated if no value is captured or if the value is not an array.
     *
     * @experimental
     */
    asArray() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'array') {
            return this.value;
        }
        this.reportIncorrectType('array');
    }
    /**
     * (experimental) Retrieve the captured value as a JSON object.
     *
     * An error is generated if no value is captured or if the value is not an object.
     *
     * @experimental
     */
    asObject() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'object') {
            return this.value;
        }
        this.reportIncorrectType('object');
    }
    checkNotNull() {
        if (this.value == null) {
            throw new Error('No value captured');
        }
    }
    reportIncorrectType(expected) {
        throw new Error(`Captured value is expected to be ${expected} but found ${type_1.getType(this.value)}. ` +
            `Value is ${JSON.stringify(this.value, undefined, 2)}`);
    }
}
exports.Capture = Capture;
_a = JSII_RTTI_SYMBOL_1;
Capture[_a] = { fqn: "@aws-cdk/assertions.Capture", version: "1.128.0" };
//# sourceMappingURL=data:application/json;base64,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