from typing import Any, Optional

HISTORY_RECORDER: Optional[HistoryRecorder]

class BaseHistoryHandler:
    def emit(self, event_type: str, payload: Any, source: str) -> None: ...

class HistoryRecorder:
    def __init__(self) -> None: ...
    def enable(self) -> None: ...
    def disable(self) -> None: ...
    def add_handler(self, handler: BaseHistoryHandler) -> None: ...
    def record(self, event_type: str, payload: Any, source: str = ...) -> None: ...

def get_global_history_recorder() -> HistoryRecorder: ...
