"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesObjectValue = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Represents a value of a specific object deployed in the cluster.
 * Use this to fetch any information available by the `kubectl get` command.
 */
class KubernetesObjectValue extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_eks_KubernetesObjectValueProps(props);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        this._resource = new core_1.CustomResource(this, 'Resource', {
            resourceType: KubernetesObjectValue.RESOURCE_TYPE,
            serviceToken: provider.serviceToken,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                ObjectType: props.objectType,
                ObjectName: props.objectName,
                ObjectNamespace: (_b = props.objectNamespace) !== null && _b !== void 0 ? _b : 'default',
                JsonPath: props.jsonPath,
                TimeoutSeconds: ((_c = props === null || props === void 0 ? void 0 : props.timeout) !== null && _c !== void 0 ? _c : core_1.Duration.minutes(5)).toSeconds(),
            },
        });
    }
    /**
     * The value as a string token.
     */
    get value() {
        return core_1.Token.asString(this._resource.getAtt('Value'));
    }
}
exports.KubernetesObjectValue = KubernetesObjectValue;
_a = JSII_RTTI_SYMBOL_1;
KubernetesObjectValue[_a] = { fqn: "@aws-cdk/aws-eks.KubernetesObjectValue", version: "1.145.0" };
/**
 * The CloudFormation reosurce type.
 */
KubernetesObjectValue.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesObjectValue';
//# sourceMappingURL=data:application/json;base64,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