"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const alb_controller_1 = require("./alb-controller");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
const PRUNE_LABEL_PREFIX = 'aws.cdk.eks/prune-';
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 */
class KubernetesManifest extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_eks_KubernetesManifestProps(props);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const prune = (_b = props.prune) !== null && _b !== void 0 ? _b : props.cluster.prune;
        const pruneLabel = prune
            ? this.injectPruneLabel(props.manifest)
            : undefined;
        if ((_c = props.ingressAlb) !== null && _c !== void 0 ? _c : false) {
            this.injectIngressAlbAnnotations(props.manifest, (_d = props.ingressAlbScheme) !== null && _d !== void 0 ? _d : alb_controller_1.AlbScheme.INTERNAL);
        }
        const customResource = new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PruneLabel: pruneLabel,
                Overwrite: props.overwrite,
                SkipValidation: props.skipValidation,
            },
        });
        this.node.defaultChild = customResource.node.defaultChild;
    }
    /**
     * Injects a generated prune label to all resources in this manifest. The
     * label name will be `awscdk.eks/manifest-ADDR` where `ADDR` is the address
     * of the construct in the construct tree.
     *
     * @returns the label name
     */
    injectPruneLabel(manifest) {
        // max label name is 64 chars and addrs is always 42.
        const pruneLabel = PRUNE_LABEL_PREFIX + constructs_1.Node.of(this).addr;
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (!resource.metadata) {
                resource.metadata = {};
            }
            if (!resource.metadata.labels) {
                resource.metadata.labels = {};
            }
            resource.metadata.labels = {
                [pruneLabel]: '',
                ...resource.metadata.labels,
            };
        }
        return pruneLabel;
    }
    /**
     * Inject the necessary ingress annontations if possible (and requested).
     *
     * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/guide/ingress/annotations/
     */
    injectIngressAlbAnnotations(manifest, scheme) {
        for (const resource of manifest) {
            // skip resource if it's not an object or if it does not have a "kind"
            if (typeof (resource) !== 'object' || !resource.kind) {
                continue;
            }
            if (resource.kind === 'Ingress') {
                resource.metadata.annotations = {
                    'kubernetes.io/ingress.class': 'alb',
                    'alb.ingress.kubernetes.io/scheme': scheme,
                    ...resource.metadata.annotations,
                };
            }
        }
    }
}
exports.KubernetesManifest = KubernetesManifest;
_a = JSII_RTTI_SYMBOL_1;
KubernetesManifest[_a] = { fqn: "@aws-cdk/aws-eks.KubernetesManifest", version: "1.145.0" };
/**
 * The CloudFormation reosurce type.
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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