'''
:mod:`pyiced.css_color` exports :class:`pyiced.Color` constants for all 148 named
`CSS Color Module Level 4 <https://www.w3.org/TR/2021/WD-css-color-4-20210601/#named-colors>`_
colors.
'''

from pyiced._pyiced import Color


__all__ = [
    'ALICEBLUE', 'ANTIQUEWHITE', 'AQUA', 'AQUAMARINE', 'AZURE', 'BEIGE',
    'BISQUE', 'BLACK', 'BLANCHEDALMOND', 'BLUE', 'BLUEVIOLET', 'BROWN',
    'BURLYWOOD', 'CADETBLUE', 'CHARTREUSE', 'CHOCOLATE', 'CORAL',
    'CORNFLOWERBLUE', 'CORNSILK', 'CRIMSON', 'CYAN', 'DARKBLUE', 'DARKCYAN',
    'DARKGOLDENROD', 'DARKGRAY', 'DARKGREEN', 'DARKGREY', 'DARKKHAKI',
    'DARKMAGENTA', 'DARKOLIVEGREEN', 'DARKORANGE', 'DARKORCHID', 'DARKRED',
    'DARKSALMON', 'DARKSEAGREEN', 'DARKSLATEBLUE', 'DARKSLATEGRAY',
    'DARKSLATEGREY', 'DARKTURQUOISE', 'DARKVIOLET', 'DEEPPINK', 'DEEPSKYBLUE',
    'DIMGRAY', 'DIMGREY', 'DODGERBLUE', 'FIREBRICK', 'FLORALWHITE',
    'FORESTGREEN', 'FUCHSIA', 'GAINSBORO', 'GHOSTWHITE', 'GOLD', 'GOLDENROD',
    'GRAY', 'GREEN', 'GREENYELLOW', 'GREY', 'HONEYDEW', 'HOTPINK',
    'INDIANRED', 'INDIGO', 'IVORY', 'KHAKI', 'LAVENDER', 'LAVENDERBLUSH',
    'LAWNGREEN', 'LEMONCHIFFON', 'LIGHTBLUE', 'LIGHTCORAL', 'LIGHTCYAN',
    'LIGHTGOLDENRODYELLOW', 'LIGHTGRAY', 'LIGHTGREEN', 'LIGHTGREY',
    'LIGHTPINK', 'LIGHTSALMON', 'LIGHTSEAGREEN', 'LIGHTSKYBLUE',
    'LIGHTSLATEGRAY', 'LIGHTSLATEGREY', 'LIGHTSTEELBLUE', 'LIGHTYELLOW',
    'LIME', 'LIMEGREEN', 'LINEN', 'MAGENTA', 'MAROON', 'MEDIUMAQUAMARINE',
    'MEDIUMBLUE', 'MEDIUMORCHID', 'MEDIUMPURPLE', 'MEDIUMSEAGREEN',
    'MEDIUMSLATEBLUE', 'MEDIUMSPRINGGREEN', 'MEDIUMTURQUOISE',
    'MEDIUMVIOLETRED', 'MIDNIGHTBLUE', 'MINTCREAM', 'MISTYROSE', 'MOCCASIN',
    'NAVAJOWHITE', 'NAVY', 'OLDLACE', 'OLIVE', 'OLIVEDRAB', 'ORANGE',
    'ORANGERED', 'ORCHID', 'PALEGOLDENROD', 'PALEGREEN', 'PALETURQUOISE',
    'PALEVIOLETRED', 'PAPAYAWHIP', 'PEACHPUFF', 'PERU', 'PINK', 'PLUM',
    'POWDERBLUE', 'PURPLE', 'REBECCAPURPLE', 'RED', 'ROSYBROWN', 'ROYALBLUE',
    'SADDLEBROWN', 'SALMON', 'SANDYBROWN', 'SEAGREEN', 'SEASHELL', 'SIENNA',
    'SILVER', 'SKYBLUE', 'SLATEBLUE', 'SLATEGRAY', 'SLATEGREY', 'SNOW',
    'SPRINGGREEN', 'STEELBLUE', 'TAN', 'TEAL', 'THISTLE', 'TOMATO',
    'TURQUOISE', 'VIOLET', 'WHEAT', 'WHITE', 'WHITESMOKE', 'YELLOW',
    'YELLOWGREEN',
]

ALICEBLUE = Color(9.4117647e-01, 9.7254902e-01, 1.0000000e+00)
ANTIQUEWHITE = Color(9.8039216e-01, 9.2156863e-01, 8.4313725e-01)
AQUA = Color(0.0000000e+00, 1.0000000e+00, 1.0000000e+00)
AQUAMARINE = Color(4.9803922e-01, 1.0000000e+00, 8.3137255e-01)
AZURE = Color(9.4117647e-01, 1.0000000e+00, 1.0000000e+00)
BEIGE = Color(9.6078431e-01, 9.6078431e-01, 8.6274510e-01)
BISQUE = Color(1.0000000e+00, 8.9411765e-01, 7.6862745e-01)
BLACK = Color(0.0000000e+00, 0.0000000e+00, 0.0000000e+00)
BLANCHEDALMOND = Color(1.0000000e+00, 9.2156863e-01, 8.0392157e-01)
BLUE = Color(0.0000000e+00, 0.0000000e+00, 1.0000000e+00)
BLUEVIOLET = Color(5.4117647e-01, 1.6862745e-01, 8.8627451e-01)
BROWN = Color(6.4705882e-01, 1.6470588e-01, 1.6470588e-01)
BURLYWOOD = Color(8.7058824e-01, 7.2156863e-01, 5.2941176e-01)
CADETBLUE = Color(3.7254902e-01, 6.1960784e-01, 6.2745098e-01)
CHARTREUSE = Color(4.9803922e-01, 1.0000000e+00, 0.0000000e+00)
CHOCOLATE = Color(8.2352941e-01, 4.1176471e-01, 1.1764706e-01)
CORAL = Color(1.0000000e+00, 4.9803922e-01, 3.1372549e-01)
CORNFLOWERBLUE = Color(3.9215686e-01, 5.8431373e-01, 9.2941176e-01)
CORNSILK = Color(1.0000000e+00, 9.7254902e-01, 8.6274510e-01)
CRIMSON = Color(8.6274510e-01, 7.8431373e-02, 2.3529412e-01)
CYAN = Color(0.0000000e+00, 1.0000000e+00, 1.0000000e+00)
DARKBLUE = Color(0.0000000e+00, 0.0000000e+00, 5.4509804e-01)
DARKCYAN = Color(0.0000000e+00, 5.4509804e-01, 5.4509804e-01)
DARKGOLDENROD = Color(7.2156863e-01, 5.2549020e-01, 4.3137255e-02)
DARKGRAY = Color(6.6274510e-01, 6.6274510e-01, 6.6274510e-01)
DARKGREEN = Color(0.0000000e+00, 3.9215686e-01, 0.0000000e+00)
DARKGREY = Color(6.6274510e-01, 6.6274510e-01, 6.6274510e-01)
DARKKHAKI = Color(7.4117647e-01, 7.1764706e-01, 4.1960784e-01)
DARKMAGENTA = Color(5.4509804e-01, 0.0000000e+00, 5.4509804e-01)
DARKOLIVEGREEN = Color(3.3333333e-01, 4.1960784e-01, 1.8431373e-01)
DARKORANGE = Color(1.0000000e+00, 5.4901961e-01, 0.0000000e+00)
DARKORCHID = Color(6.0000000e-01, 1.9607843e-01, 8.0000000e-01)
DARKRED = Color(5.4509804e-01, 0.0000000e+00, 0.0000000e+00)
DARKSALMON = Color(9.1372549e-01, 5.8823529e-01, 4.7843137e-01)
DARKSEAGREEN = Color(5.6078431e-01, 7.3725490e-01, 5.6078431e-01)
DARKSLATEBLUE = Color(2.8235294e-01, 2.3921569e-01, 5.4509804e-01)
DARKSLATEGRAY = Color(1.8431373e-01, 3.0980392e-01, 3.0980392e-01)
DARKSLATEGREY = Color(1.8431373e-01, 3.0980392e-01, 3.0980392e-01)
DARKTURQUOISE = Color(0.0000000e+00, 8.0784314e-01, 8.1960784e-01)
DARKVIOLET = Color(5.8039216e-01, 0.0000000e+00, 8.2745098e-01)
DEEPPINK = Color(1.0000000e+00, 7.8431373e-02, 5.7647059e-01)
DEEPSKYBLUE = Color(0.0000000e+00, 7.4901961e-01, 1.0000000e+00)
DIMGRAY = Color(4.1176471e-01, 4.1176471e-01, 4.1176471e-01)
DIMGREY = Color(4.1176471e-01, 4.1176471e-01, 4.1176471e-01)
DODGERBLUE = Color(1.1764706e-01, 5.6470588e-01, 1.0000000e+00)
FIREBRICK = Color(6.9803922e-01, 1.3333333e-01, 1.3333333e-01)
FLORALWHITE = Color(1.0000000e+00, 9.8039216e-01, 9.4117647e-01)
FORESTGREEN = Color(1.3333333e-01, 5.4509804e-01, 1.3333333e-01)
FUCHSIA = Color(1.0000000e+00, 0.0000000e+00, 1.0000000e+00)
GAINSBORO = Color(8.6274510e-01, 8.6274510e-01, 8.6274510e-01)
GHOSTWHITE = Color(9.7254902e-01, 9.7254902e-01, 1.0000000e+00)
GOLD = Color(1.0000000e+00, 8.4313725e-01, 0.0000000e+00)
GOLDENROD = Color(8.5490196e-01, 6.4705882e-01, 1.2549020e-01)
GRAY = Color(5.0196078e-01, 5.0196078e-01, 5.0196078e-01)
GREEN = Color(0.0000000e+00, 5.0196078e-01, 0.0000000e+00)
GREENYELLOW = Color(6.7843137e-01, 1.0000000e+00, 1.8431373e-01)
GREY = Color(5.0196078e-01, 5.0196078e-01, 5.0196078e-01)
HONEYDEW = Color(9.4117647e-01, 1.0000000e+00, 9.4117647e-01)
HOTPINK = Color(1.0000000e+00, 4.1176471e-01, 7.0588235e-01)
INDIANRED = Color(8.0392157e-01, 3.6078431e-01, 3.6078431e-01)
INDIGO = Color(2.9411765e-01, 0.0000000e+00, 5.0980392e-01)
IVORY = Color(1.0000000e+00, 1.0000000e+00, 9.4117647e-01)
KHAKI = Color(9.4117647e-01, 9.0196078e-01, 5.4901961e-01)
LAVENDER = Color(9.0196078e-01, 9.0196078e-01, 9.8039216e-01)
LAVENDERBLUSH = Color(1.0000000e+00, 9.4117647e-01, 9.6078431e-01)
LAWNGREEN = Color(4.8627451e-01, 9.8823529e-01, 0.0000000e+00)
LEMONCHIFFON = Color(1.0000000e+00, 9.8039216e-01, 8.0392157e-01)
LIGHTBLUE = Color(6.7843137e-01, 8.4705882e-01, 9.0196078e-01)
LIGHTCORAL = Color(9.4117647e-01, 5.0196078e-01, 5.0196078e-01)
LIGHTCYAN = Color(8.7843137e-01, 1.0000000e+00, 1.0000000e+00)
LIGHTGOLDENRODYELLOW = Color(9.8039216e-01, 9.8039216e-01, 8.2352941e-01)
LIGHTGRAY = Color(8.2745098e-01, 8.2745098e-01, 8.2745098e-01)
LIGHTGREEN = Color(5.6470588e-01, 9.3333333e-01, 5.6470588e-01)
LIGHTGREY = Color(8.2745098e-01, 8.2745098e-01, 8.2745098e-01)
LIGHTPINK = Color(1.0000000e+00, 7.1372549e-01, 7.5686275e-01)
LIGHTSALMON = Color(1.0000000e+00, 6.2745098e-01, 4.7843137e-01)
LIGHTSEAGREEN = Color(1.2549020e-01, 6.9803922e-01, 6.6666667e-01)
LIGHTSKYBLUE = Color(5.2941176e-01, 8.0784314e-01, 9.8039216e-01)
LIGHTSLATEGRAY = Color(4.6666667e-01, 5.3333333e-01, 6.0000000e-01)
LIGHTSLATEGREY = Color(4.6666667e-01, 5.3333333e-01, 6.0000000e-01)
LIGHTSTEELBLUE = Color(6.9019608e-01, 7.6862745e-01, 8.7058824e-01)
LIGHTYELLOW = Color(1.0000000e+00, 1.0000000e+00, 8.7843137e-01)
LIME = Color(0.0000000e+00, 1.0000000e+00, 0.0000000e+00)
LIMEGREEN = Color(1.9607843e-01, 8.0392157e-01, 1.9607843e-01)
LINEN = Color(9.8039216e-01, 9.4117647e-01, 9.0196078e-01)
MAGENTA = Color(1.0000000e+00, 0.0000000e+00, 1.0000000e+00)
MAROON = Color(5.0196078e-01, 0.0000000e+00, 0.0000000e+00)
MEDIUMAQUAMARINE = Color(4.0000000e-01, 8.0392157e-01, 6.6666667e-01)
MEDIUMBLUE = Color(0.0000000e+00, 0.0000000e+00, 8.0392157e-01)
MEDIUMORCHID = Color(7.2941176e-01, 3.3333333e-01, 8.2745098e-01)
MEDIUMPURPLE = Color(5.7647059e-01, 4.3921569e-01, 8.5882353e-01)
MEDIUMSEAGREEN = Color(2.3529412e-01, 7.0196078e-01, 4.4313725e-01)
MEDIUMSLATEBLUE = Color(4.8235294e-01, 4.0784314e-01, 9.3333333e-01)
MEDIUMSPRINGGREEN = Color(0.0000000e+00, 9.8039216e-01, 6.0392157e-01)
MEDIUMTURQUOISE = Color(2.8235294e-01, 8.1960784e-01, 8.0000000e-01)
MEDIUMVIOLETRED = Color(7.8039216e-01, 8.2352941e-02, 5.2156863e-01)
MIDNIGHTBLUE = Color(9.8039216e-02, 9.8039216e-02, 4.3921569e-01)
MINTCREAM = Color(9.6078431e-01, 1.0000000e+00, 9.8039216e-01)
MISTYROSE = Color(1.0000000e+00, 8.9411765e-01, 8.8235294e-01)
MOCCASIN = Color(1.0000000e+00, 8.9411765e-01, 7.0980392e-01)
NAVAJOWHITE = Color(1.0000000e+00, 8.7058824e-01, 6.7843137e-01)
NAVY = Color(0.0000000e+00, 0.0000000e+00, 5.0196078e-01)
OLDLACE = Color(9.9215686e-01, 9.6078431e-01, 9.0196078e-01)
OLIVE = Color(5.0196078e-01, 5.0196078e-01, 0.0000000e+00)
OLIVEDRAB = Color(4.1960784e-01, 5.5686275e-01, 1.3725490e-01)
ORANGE = Color(1.0000000e+00, 6.4705882e-01, 0.0000000e+00)
ORANGERED = Color(1.0000000e+00, 2.7058824e-01, 0.0000000e+00)
ORCHID = Color(8.5490196e-01, 4.3921569e-01, 8.3921569e-01)
PALEGOLDENROD = Color(9.3333333e-01, 9.0980392e-01, 6.6666667e-01)
PALEGREEN = Color(5.9607843e-01, 9.8431373e-01, 5.9607843e-01)
PALETURQUOISE = Color(6.8627451e-01, 9.3333333e-01, 9.3333333e-01)
PALEVIOLETRED = Color(8.5882353e-01, 4.3921569e-01, 5.7647059e-01)
PAPAYAWHIP = Color(1.0000000e+00, 9.3725490e-01, 8.3529412e-01)
PEACHPUFF = Color(1.0000000e+00, 8.5490196e-01, 7.2549020e-01)
PERU = Color(8.0392157e-01, 5.2156863e-01, 2.4705882e-01)
PINK = Color(1.0000000e+00, 7.5294118e-01, 7.9607843e-01)
PLUM = Color(8.6666667e-01, 6.2745098e-01, 8.6666667e-01)
POWDERBLUE = Color(6.9019608e-01, 8.7843137e-01, 9.0196078e-01)
PURPLE = Color(5.0196078e-01, 0.0000000e+00, 5.0196078e-01)
REBECCAPURPLE = Color(4.0000000e-01, 2.0000000e-01, 6.0000000e-01)
RED = Color(1.0000000e+00, 0.0000000e+00, 0.0000000e+00)
ROSYBROWN = Color(7.3725490e-01, 5.6078431e-01, 5.6078431e-01)
ROYALBLUE = Color(2.5490196e-01, 4.1176471e-01, 8.8235294e-01)
SADDLEBROWN = Color(5.4509804e-01, 2.7058824e-01, 7.4509804e-02)
SALMON = Color(9.8039216e-01, 5.0196078e-01, 4.4705882e-01)
SANDYBROWN = Color(9.5686275e-01, 6.4313725e-01, 3.7647059e-01)
SEAGREEN = Color(1.8039216e-01, 5.4509804e-01, 3.4117647e-01)
SEASHELL = Color(1.0000000e+00, 9.6078431e-01, 9.3333333e-01)
SIENNA = Color(6.2745098e-01, 3.2156863e-01, 1.7647059e-01)
SILVER = Color(7.5294118e-01, 7.5294118e-01, 7.5294118e-01)
SKYBLUE = Color(5.2941176e-01, 8.0784314e-01, 9.2156863e-01)
SLATEBLUE = Color(4.1568627e-01, 3.5294118e-01, 8.0392157e-01)
SLATEGRAY = Color(4.3921569e-01, 5.0196078e-01, 5.6470588e-01)
SLATEGREY = Color(4.3921569e-01, 5.0196078e-01, 5.6470588e-01)
SNOW = Color(1.0000000e+00, 9.8039216e-01, 9.8039216e-01)
SPRINGGREEN = Color(0.0000000e+00, 1.0000000e+00, 4.9803922e-01)
STEELBLUE = Color(2.7450980e-01, 5.0980392e-01, 7.0588235e-01)
TAN = Color(8.2352941e-01, 7.0588235e-01, 5.4901961e-01)
TEAL = Color(0.0000000e+00, 5.0196078e-01, 5.0196078e-01)
THISTLE = Color(8.4705882e-01, 7.4901961e-01, 8.4705882e-01)
TOMATO = Color(1.0000000e+00, 3.8823529e-01, 2.7843137e-01)
TURQUOISE = Color(2.5098039e-01, 8.7843137e-01, 8.1568627e-01)
VIOLET = Color(9.3333333e-01, 5.0980392e-01, 9.3333333e-01)
WHEAT = Color(9.6078431e-01, 8.7058824e-01, 7.0196078e-01)
WHITE = Color(1.0000000e+00, 1.0000000e+00, 1.0000000e+00)
WHITESMOKE = Color(9.6078431e-01, 9.6078431e-01, 9.6078431e-01)
YELLOW = Color(1.0000000e+00, 1.0000000e+00, 0.0000000e+00)
YELLOWGREEN = Color(6.0392157e-01, 8.0392157e-01, 1.9607843e-01)
