"use strict";
const ec2 = require("@aws-cdk/aws-ec2");
const cloudmap = require("@aws-cdk/aws-servicediscovery");
const cdk = require("@aws-cdk/core");
const appmesh = require("../lib");
module.exports = {
    'Can export existing virtual-service and re-import'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const mesh = new appmesh.Mesh(stack, 'mesh', {
            meshName: 'test-mesh',
        });
        const router = new appmesh.VirtualRouter(stack, 'router', { mesh });
        const vpc = new ec2.Vpc(stack, 'vpc');
        const namespace = new cloudmap.PrivateDnsNamespace(stack, 'test-namespace', {
            vpc,
            name: 'domain.local',
        });
        const service = new appmesh.VirtualService(stack, 'service-1', {
            mesh,
            virtualServiceName: `service.${namespace.namespaceName}`,
            virtualRouter: router,
        });
        const stack2 = new cdk.Stack();
        appmesh.VirtualService.fromVirtualServiceName(stack2, 'imported-virtual-service', mesh.meshName, service.virtualServiceName);
        // Nothing to do with imported virtual service yet
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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