import os

__all__ = [
    "SCML_RUNALL_TESTS",
    "SCML_FASTRUN",
    "SCML_RUN2019",
    "SCML_RUN2020",
    "SCML_RUN2021_TOURNAMENT",
    "SCML_RUN2021_ONESHOT",
    "SCML_RUN2021_ONESHOT_SYNC",
    "SCML_RUN2021_STD",
    "SCML_RUN_TUTORIAL2",
    "SCML_RUN_GENIUS",
    "SCML_RUN_TOURNAMENTS",
    "SCML_RUN_STD_TOURNAMENTS",
    "SCML_RUN_COLLUSION_TOURNAMENTS",
    "SCML_RUN_SABOTAGE_TOURNAMENTS",
    "SCML_RUN_TEMP_FAILING",
]


def is_enabled(val: str) -> bool:
    return os.environ.get(val, "").lower() in ("true", "yes")


def isnot_disabled(val: str) -> bool:
    return os.environ.get(val, "").lower() not in ("false", "no")


SCML_RUNALL_TESTS = is_enabled("SCML_RUNALL_TESTS")
SCML_ON_GITHUB = is_enabled("GITHUB_ACTIONS")
SCML_FASTRUN = (is_enabled("SCML_FASTRUN") or SCML_ON_GITHUB) and not SCML_RUNALL_TESTS
SCML_RUN_TEMP_FAILING = is_enabled("SCML_RUN_TEMP_FAILING")
SCML_RUN2021_ONESHOT = isnot_disabled("SCML_RUN2021_ONESHOT")
SCML_RUN2021_STD = isnot_disabled("SCML_RUN2021_STD")
SCML_RUN_GENIUS = is_enabled("SCML_RUN_GENIUS")
SCML_RUN_TOURNAMENTS = is_enabled("SCML_RUN_TOURNAMENTS")
SCML_RUN_STD_TOURNAMENTS = is_enabled("SCML_RUN_STD_TOURNAMENTS")
SCML_RUN_COLLUSION_TOURNAMENTS = is_enabled("SCML_RUN_COLLUSION_TOURNAMENTS")
SCML_RUN_SABOTAGE_TOURNAMENTS = is_enabled("SCML_RUN_SABOTAGE_TOURNAMENTS")
SCML_RUN2021_TOURNAMENT = isnot_disabled("SCML_RUN2021_TOURNAMENT")
SCML_RUN2021_ONESHOT_SYNC = isnot_disabled("SCML_RUN2021_ONESHOT_SYNC")
SCML_RUN2019 = is_enabled("SCML_RUN2019")
SCML_RUN2020 = is_enabled("SCML_RUN2020")
SCML_RUN_TUTORIAL2 = isnot_disabled("SCML_RUN_TUTORIAL2")
SCML_RUN_NOTEBOOKS = isnot_disabled("SCML_RUN_NOTEBOOKS")
SCML_RUN_SCHEDULER = is_enabled("SCML_RUN_SCHEDULER")
