# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jupyter_compare_view']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.1.2', 'Pillow>=9.1.0', 'ipykernel>=5.0.0', 'ipython>=6.0.0']

setup_kwargs = {
    'name': 'jupyter-compare-view',
    'version': '0.1.4',
    'description': 'Blend Between Multiple Images in JupyterLab.',
    'long_description': '# Jupyter compare_view\n\n![bannerFINAL](https://user-images.githubusercontent.com/44469195/179508322-ea10e22a-6dfb-47f4-8fbb-d5ce724f0127.png)\n\n[![JupyterLight](https://jupyterlite.rtfd.io/en/latest/_static/badge.svg)](https://octoframes.github.io/jupyter_compare_view)\n[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/Octoframes/jupyter_compare_view/HEAD?labpath=example_notebook.ipynb)\n[![PyPI version](https://badge.fury.io/py/jupyter_compare_view.svg)](https://badge.fury.io/py/jupyter_compare_view)\n[![MIT](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/Octoframes/jupyter_compare_view/blob/main/LICENSE)\n\n\nBlend between multiple images using a cell magic in JupyterLab using [compare_view](https://github.com/Octoframes/compare_view).   \n*This project was called jupyter-splitview before.*  \n\n\n## Installation\n```py\npip install jupyter_compare_view\n```\n## Example\n```py\nimport jupyter_compare_view\n```\n\n```py\n%%compare  \nfrom skimage import data\nfrom skimage.color import rgb2gray\nimport matplotlib.pyplot as plt\n\nimg = data.chelsea()\ngrayscale_img = rgb2gray(img)\n\nplt.imshow(img)\nplt.axis("off")\nplt.show()\n\nplt.imshow(grayscale_img, cmap="gray")\nplt.axis("off")\nplt.show()\n```\n\n<img src="https://user-images.githubusercontent.com/44469195/179499138-65160434-11e1-4358-8e25-5b26ba9ebf4a.png" style="width: 400px;"/>\n\nAnother example:\n```py\n%%compare  --config \'{"start_mode": "horizontal","start_slider_pos": 0.73}\'\n\nplt.imshow(img)\nplt.axis("off")\nplt.show()\n\nplt.imshow(grayscale_img, cmap="gray")\nplt.axis("off")\nplt.show()\n```\n<img src="https://user-images.githubusercontent.com/44469195/179499350-94244408-cabf-4945-affc-fd0444d53555.png" style="width: 400px;"/>\n\n\nThe split view widget is still responsive after closing and reopening the notebook without running the cell again.\n\n## Notebook arguments\n(Might still change in future)\n* `--config \'{"start_mode": "horizontal"}\'` will init the compare-view in horizontal slider mode.\n* `--config \'{"circle_size": 30}\'`  the circle size is now 30 pixel in circle mode.\n* `--config \'{"show_slider": false}\'` will hide the slider bar.\n* `--config \'{"start_slider_pos": 0.73}\'` will set the slider start position to 73%. \n\n    * *Removed in 0.1.1: `--position 73%` will no longer the slider start position to 73%.*\n* `--config \'{"start_mode": "horizontal","start_slider_pos": 0.73}\'` will both set the start mode to horizontal and set the slider position\n* `--height 220` will set the height to 220 pixel. \n* When `--height`is not provided, the default height of the widget is 300 pixel.\n* `--height auto` will set the height by the value of the first image\'s resolution in vertical direction.\n* The widget\'s width will always be adjusted automatically. \n\n## Notebook formatting\nFormatting with black can be done this way: \n1. `pip install \'black[jupyter]\'`\n2. `black --python-cell-magics compare compare_view_magic.ipynb`\n\n\n## Developer Installation\n\n1. `git clone --recurse https://github.com/Octoframes/jupyter_compare_view`\n(Note: In case that the repo was already cloned e.g. with the GitHub Desktop client, the  GitHub submodule has to be loaded via `git submodule update --init --recursive`)\n2. `poetry install`\n\n*Note*: The IPython extension `autoreload` reloads modules before every cell execution. Very useful when debugging the `%%capture` cell magic!\nJust add these lines into the first jupyter cell.\n```py\n%load_ext autoreload\n%autoreload 2\nimport jupyter_compare_view\n```\n\n## Changelog\n\n## 0.1.4\n\n* `%%compare`  is now `%%splity`. `%%splity` is deprecated.\n* Update examples\n\n## 0.1.3\n\n* octoframes github actions setup\n\n## 0.1.2\n\n* Move the repo from kolibril13/jupyter-spitview to octoframes/jupyter_compare_view \n* Rename all references\n## 0.1.1\n\n* Drop the [github.com/NUKnightLab/juxtapose](https://github.com/NUKnightLab/juxtapose) backend and replace it with [github.com/Octoframes/compare_view](https://github.com/Octoframes/compare_view).  \n* Implement horizontal slider\n* Implement Round Mask\n## 0.1.0\n\n* Update dependencies\n* Update JupyterLite version\n* Fix: in JupyterLite, a figure has to be explicitly called by plt.show()\n* Better installation workflow\n\n## 0.0.8\n\n* Fixing problem with cell id and notebook reloading\n* Experimentally lowering the dependencies to\n`ipython = ">=6.0.0"` and `ipykernel = ">=5.0.0"` so that  jupyterlite will work hopefully.\n\n## 0.0.7\n\n* Rewrite of the import of JavaScript and CSS to make it more robust when closing and opening the notebook\n* First attempt to add a JupyterLite example.\n## 0.0.6 \n\nFix poetry workflow\n\n## 0.0.5 \n\n* Ship the javascript directly with the package, so no internet connection is required\n* use jinja2 to save HTML in separate file\n* load stylesheet and javascript only once in the beginning, and not in every cell that contains the splitview widget.\n\n## 0.0.4 \n\n* New `--height` parameter\n\n## 0.0.3\n\n* default slider position\n* updated minimal example\n* internal code restructuring and formatting\n* Handle import in non jupyter context\n\n## 0.0.2 \n* save images in base64 strings and don\'t load images to disk (increases package security).\n## 0.0.1\n\n* First release\n',
    'author': 'Octoframes',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
