from __future__ import annotations

from tcsoa.gen.Query._2010_09.SavedQuery import BusinessObjectQueryClause
from enum import Enum
from typing import List
from tcsoa.utils import TcBaseObj
from dataclasses import dataclass


@dataclass
class AttributeSortOption(TcBaseObj):
    """
    Structure for attribute sort option.
    
    :var sortAttribute: Attribute of the type being searched based on which the results will be sorted.
    :var sortOrder: Order in which results are sorted AscendingOrder or DescendingOrder.
    """
    sortAttribute: str = ''
    sortOrder: SortOrder = None


@dataclass
class BusinessObjectQueryInput3(TcBaseObj):
    """
    Input structure for executeBOQueriesWithSort operation.
    
    :var boTypeName: Name of business object type. Supports BusinessObject and all subtypes.
    :var clauses: Query clauses in search criteria. Each clause consists of property name, property value, logic and
    math operators.
    :var sortOptions: A list of attribute sort options based on which the results will be sorted. The first element of
    the list is the primary sort field, second is the secondary sort field and so on.
    :var maxNumToReturn: Specified maximum number of objects to return.
    :var requestId: Unique ID used to register the query execution task. This can be used by the caller to cancel the
    time consuming query, the value can be generated by any unique string generator. The query can be cancelled by
    calling: TcSoaFrameworkCore.Session.cancelOperations (requestId).
    :var clientId: This unique ID is used to identify return data elements and partial errors associated with this
    input structure. This is currently not yet used by the return data elements, the caller can leave it empty.
    """
    boTypeName: str = ''
    clauses: List[BusinessObjectQueryClause] = ()
    sortOptions: List[AttributeSortOption] = ()
    maxNumToReturn: int = 0
    requestId: str = ''
    clientId: str = ''


class SortOrder(Enum):
    """
    Defines the order in which the business object query results are sorted (Ascending or Descending)
    """
    AscendingOrder = 'AscendingOrder'
    DescendingOrder = 'DescendingOrder'
