"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketStage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class WebSocketStage extends base_1.StageBase {
    /**
     * Import an existing stage into this CDK app.
     */
    static fromWebSocketStageAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketStageAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketStageAttributes);
            }
            throw error;
        }
        class Import extends base_1.StageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get callbackUrl() {
                throw new Error('callback url is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketStageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketStage);
            }
            throw error;
        }
        this.baseApi = props.webSocketApi;
        this.api = props.webSocketApi;
        this.stageName = this.physicalName;
        new aws_apigatewayv2_1.CfnStage(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
            defaultRouteSettings: !props.throttle ? undefined : {
                throttlingBurstLimit: props.throttle?.burstLimit,
                throttlingRateLimit: props.throttle?.rateLimit,
            },
        });
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * The websocket URL to this stage.
     */
    get url() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName;
        return `wss://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * The callback URL to this stage.
     */
    get callbackUrl() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API Stage to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManagementApiAccess(identity) {
        const arn = aws_cdk_lib_1.Stack.of(this.api).formatArn({
            service: 'execute-api',
            resource: this.api.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/${this.stageName}/*/@connections/*`],
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
WebSocketStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketStage", version: "2.72.1-alpha.0" };
exports.WebSocketStage = WebSocketStage;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhZ2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFnZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxpREFBd0Q7QUFDeEQsNkNBQW9DO0FBR3BDLG1FQUF3RDtBQUV4RCx5Q0FBMkM7QUE2QzNDOzs7R0FHRztBQUNILE1BQWEsY0FBZSxTQUFRLGdCQUFTO0lBQzNDOztPQUVHO0lBQ0ksTUFBTSxDQUFDLDRCQUE0QixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQStCOzs7Ozs7Ozs7O1FBQ3RHLE1BQU0sTUFBTyxTQUFRLGdCQUFTO1lBQTlCOztnQkFDa0IsWUFBTyxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUM7Z0JBQ3BCLGNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO2dCQUM1QixRQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztZQVNsQyxDQUFDO1lBUEMsSUFBSSxHQUFHO2dCQUNMLE1BQU0sSUFBSSxLQUFLLENBQUMsMkNBQTJDLENBQUMsQ0FBQztZQUMvRCxDQUFDO1lBRUQsSUFBSSxXQUFXO2dCQUNiLE1BQU0sSUFBSSxLQUFLLENBQUMsb0RBQW9ELENBQUMsQ0FBQztZQUN4RSxDQUFDO1NBQ0Y7UUFDRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5QjtJQU1ELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixZQUFZLEVBQUUsS0FBSyxDQUFDLFNBQVM7U0FDOUIsQ0FBQyxDQUFDOzs7Ozs7K0NBNUJNLGNBQWM7Ozs7UUE4QnZCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUNsQyxJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDOUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1FBRW5DLElBQUksMkJBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzdCLEtBQUssRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUs7WUFDL0IsU0FBUyxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQzVCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixvQkFBb0IsRUFBRSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7Z0JBQ2xELG9CQUFvQixFQUFFLEtBQUssQ0FBQyxRQUFRLEVBQUUsVUFBVTtnQkFDaEQsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLFFBQVEsRUFBRSxTQUFTO2FBQy9DO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxLQUFLLENBQUMsYUFBYSxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7U0FDN0M7S0FDRjtJQUVEOztPQUVHO0lBQ0gsSUFBVyxHQUFHO1FBQ1osTUFBTSxDQUFDLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDekIsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztRQUMvQixPQUFPLFNBQVMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLGdCQUFnQixDQUFDLENBQUMsTUFBTSxJQUFJLENBQUMsQ0FBQyxTQUFTLElBQUksT0FBTyxFQUFFLENBQUM7S0FDcEY7SUFFRDs7T0FFRztJQUNILElBQVcsV0FBVztRQUNwQixNQUFNLENBQUMsR0FBRyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN6QixNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQy9CLE9BQU8sV0FBVyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssZ0JBQWdCLENBQUMsQ0FBQyxNQUFNLElBQUksQ0FBQyxDQUFDLFNBQVMsSUFBSSxPQUFPLEVBQUUsQ0FBQztLQUN0RjtJQUVEOzs7OztPQUtHO0lBQ0ksd0JBQXdCLENBQUMsUUFBb0I7UUFDbEQsTUFBTSxHQUFHLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFNBQVMsQ0FBQztZQUN2QyxPQUFPLEVBQUUsYUFBYTtZQUN0QixRQUFRLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLO1NBQ3pCLENBQUMsQ0FBQztRQUVILE9BQU8sZUFBSyxDQUFDLGNBQWMsQ0FBQztZQUMxQixPQUFPLEVBQUUsUUFBUTtZQUNqQixPQUFPLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQztZQUMxQyxZQUFZLEVBQUUsQ0FBQyxHQUFHLEdBQUcsSUFBSSxJQUFJLENBQUMsU0FBUyxtQkFBbUIsQ0FBQztTQUM1RCxDQUFDLENBQUM7S0FDSjs7OztBQXBGVSx3Q0FBYyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdyYW50LCBJR3JhbnRhYmxlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSVdlYlNvY2tldEFwaSB9IGZyb20gJy4vYXBpJztcbmltcG9ydCB7IENmblN0YWdlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWFwaWdhdGV3YXl2Mic7XG5pbXBvcnQgeyBTdGFnZU9wdGlvbnMsIElBcGksIElTdGFnZSwgU3RhZ2VBdHRyaWJ1dGVzIH0gZnJvbSAnLi4vY29tbW9uJztcbmltcG9ydCB7IFN0YWdlQmFzZSB9IGZyb20gJy4uL2NvbW1vbi9iYXNlJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBXZWJTb2NrZXRTdGFnZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIElXZWJTb2NrZXRTdGFnZSBleHRlbmRzIElTdGFnZSB7XG4gIC8qKlxuICAgKiBUaGUgQVBJIHRoaXMgc3RhZ2UgaXMgYXNzb2NpYXRlZCB0by5cbiAgICovXG4gIHJlYWRvbmx5IGFwaTogSVdlYlNvY2tldEFwaTtcblxuICAvKipcbiAgICogVGhlIGNhbGxiYWNrIFVSTCB0byB0aGlzIHN0YWdlLlxuICAgKiBZb3UgY2FuIHVzZSB0aGUgY2FsbGJhY2sgVVJMIHRvIHNlbmQgbWVzc2FnZXMgdG8gdGhlIGNsaWVudCBmcm9tIHRoZSBiYWNrZW5kIHN5c3RlbS5cbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwaWdhdGV3YXkvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2FwaS1nYXRld2F5LWJhc2ljLWNvbmNlcHQuaHRtbFxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBpZ2F0ZXdheS9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvYXBpZ2F0ZXdheS1ob3ctdG8tY2FsbC13ZWJzb2NrZXQtYXBpLWNvbm5lY3Rpb25zLmh0bWxcbiAgICovXG4gIHJlYWRvbmx5IGNhbGxiYWNrVXJsOiBzdHJpbmc7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBpbml0aWFsaXplIGFuIGluc3RhbmNlIG9mIGBXZWJTb2NrZXRTdGFnZWAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgV2ViU29ja2V0U3RhZ2VQcm9wcyBleHRlbmRzIFN0YWdlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgV2ViU29ja2V0IEFQSSB0byB3aGljaCB0aGlzIHN0YWdlIGlzIGFzc29jaWF0ZWQuXG4gICAqL1xuICByZWFkb25seSB3ZWJTb2NrZXRBcGk6IElXZWJTb2NrZXRBcGk7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBzdGFnZS5cbiAgICovXG4gIHJlYWRvbmx5IHN0YWdlTmFtZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIFRoZSBhdHRyaWJ1dGVzIHVzZWQgdG8gaW1wb3J0IGV4aXN0aW5nIFdlYlNvY2tldFN0YWdlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgV2ViU29ja2V0U3RhZ2VBdHRyaWJ1dGVzIGV4dGVuZHMgU3RhZ2VBdHRyaWJ1dGVzIHtcbiAgLyoqXG4gICAqIFRoZSBBUEkgdG8gd2hpY2ggdGhpcyBzdGFnZSBpcyBhc3NvY2lhdGVkXG4gICAqL1xuICByZWFkb25seSBhcGk6IElXZWJTb2NrZXRBcGk7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIHN0YWdlIHdoZXJlIGFuIGluc3RhbmNlIG9mIHRoZSBBUEkgaXMgZGVwbG95ZWQuXG4gKiBAcmVzb3VyY2UgQVdTOjpBcGlHYXRld2F5VjI6OlN0YWdlXG4gKi9cbmV4cG9ydCBjbGFzcyBXZWJTb2NrZXRTdGFnZSBleHRlbmRzIFN0YWdlQmFzZSBpbXBsZW1lbnRzIElXZWJTb2NrZXRTdGFnZSB7XG4gIC8qKlxuICAgKiBJbXBvcnQgYW4gZXhpc3Rpbmcgc3RhZ2UgaW50byB0aGlzIENESyBhcHAuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21XZWJTb2NrZXRTdGFnZUF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IFdlYlNvY2tldFN0YWdlQXR0cmlidXRlcyk6IElXZWJTb2NrZXRTdGFnZSB7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgU3RhZ2VCYXNlIGltcGxlbWVudHMgSVdlYlNvY2tldFN0YWdlIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSBiYXNlQXBpID0gYXR0cnMuYXBpO1xuICAgICAgcHVibGljIHJlYWRvbmx5IHN0YWdlTmFtZSA9IGF0dHJzLnN0YWdlTmFtZTtcbiAgICAgIHB1YmxpYyByZWFkb25seSBhcGkgPSBhdHRycy5hcGk7XG5cbiAgICAgIGdldCB1cmwoKTogc3RyaW5nIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCd1cmwgaXMgbm90IGF2YWlsYWJsZSBmb3IgaW1wb3J0ZWQgc3RhZ2VzLicpO1xuICAgICAgfVxuXG4gICAgICBnZXQgY2FsbGJhY2tVcmwoKTogc3RyaW5nIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdjYWxsYmFjayB1cmwgaXMgbm90IGF2YWlsYWJsZSBmb3IgaW1wb3J0ZWQgc3RhZ2VzLicpO1xuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGJhc2VBcGk6IElBcGk7XG4gIHB1YmxpYyByZWFkb25seSBzdGFnZU5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGFwaTogSVdlYlNvY2tldEFwaTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogV2ViU29ja2V0U3RhZ2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgcGh5c2ljYWxOYW1lOiBwcm9wcy5zdGFnZU5hbWUsXG4gICAgfSk7XG5cbiAgICB0aGlzLmJhc2VBcGkgPSBwcm9wcy53ZWJTb2NrZXRBcGk7XG4gICAgdGhpcy5hcGkgPSBwcm9wcy53ZWJTb2NrZXRBcGk7XG4gICAgdGhpcy5zdGFnZU5hbWUgPSB0aGlzLnBoeXNpY2FsTmFtZTtcblxuICAgIG5ldyBDZm5TdGFnZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBhcGlJZDogcHJvcHMud2ViU29ja2V0QXBpLmFwaUlkLFxuICAgICAgc3RhZ2VOYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICAgIGF1dG9EZXBsb3k6IHByb3BzLmF1dG9EZXBsb3ksXG4gICAgICBkZWZhdWx0Um91dGVTZXR0aW5nczogIXByb3BzLnRocm90dGxlID8gdW5kZWZpbmVkIDoge1xuICAgICAgICB0aHJvdHRsaW5nQnVyc3RMaW1pdDogcHJvcHMudGhyb3R0bGU/LmJ1cnN0TGltaXQsXG4gICAgICAgIHRocm90dGxpbmdSYXRlTGltaXQ6IHByb3BzLnRocm90dGxlPy5yYXRlTGltaXQsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgaWYgKHByb3BzLmRvbWFpbk1hcHBpbmcpIHtcbiAgICAgIHRoaXMuX2FkZERvbWFpbk1hcHBpbmcocHJvcHMuZG9tYWluTWFwcGluZyk7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIFRoZSB3ZWJzb2NrZXQgVVJMIHRvIHRoaXMgc3RhZ2UuXG4gICAqL1xuICBwdWJsaWMgZ2V0IHVybCgpOiBzdHJpbmcge1xuICAgIGNvbnN0IHMgPSBTdGFjay5vZih0aGlzKTtcbiAgICBjb25zdCB1cmxQYXRoID0gdGhpcy5zdGFnZU5hbWU7XG4gICAgcmV0dXJuIGB3c3M6Ly8ke3RoaXMuYXBpLmFwaUlkfS5leGVjdXRlLWFwaS4ke3MucmVnaW9ufS4ke3MudXJsU3VmZml4fS8ke3VybFBhdGh9YDtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgY2FsbGJhY2sgVVJMIHRvIHRoaXMgc3RhZ2UuXG4gICAqL1xuICBwdWJsaWMgZ2V0IGNhbGxiYWNrVXJsKCk6IHN0cmluZyB7XG4gICAgY29uc3QgcyA9IFN0YWNrLm9mKHRoaXMpO1xuICAgIGNvbnN0IHVybFBhdGggPSB0aGlzLnN0YWdlTmFtZTtcbiAgICByZXR1cm4gYGh0dHBzOi8vJHt0aGlzLmFwaS5hcGlJZH0uZXhlY3V0ZS1hcGkuJHtzLnJlZ2lvbn0uJHtzLnVybFN1ZmZpeH0vJHt1cmxQYXRofWA7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnQgYWNjZXNzIHRvIHRoZSBBUEkgR2F0ZXdheSBtYW5hZ2VtZW50IEFQSSBmb3IgdGhpcyBXZWJTb2NrZXQgQVBJIFN0YWdlIHRvIGFuIElBTVxuICAgKiBwcmluY2lwYWwgKFJvbGUvR3JvdXAvVXNlcikuXG4gICAqXG4gICAqIEBwYXJhbSBpZGVudGl0eSBUaGUgcHJpbmNpcGFsXG4gICAqL1xuICBwdWJsaWMgZ3JhbnRNYW5hZ2VtZW50QXBpQWNjZXNzKGlkZW50aXR5OiBJR3JhbnRhYmxlKTogR3JhbnQge1xuICAgIGNvbnN0IGFybiA9IFN0YWNrLm9mKHRoaXMuYXBpKS5mb3JtYXRBcm4oe1xuICAgICAgc2VydmljZTogJ2V4ZWN1dGUtYXBpJyxcbiAgICAgIHJlc291cmNlOiB0aGlzLmFwaS5hcGlJZCxcbiAgICB9KTtcblxuICAgIHJldHVybiBHcmFudC5hZGRUb1ByaW5jaXBhbCh7XG4gICAgICBncmFudGVlOiBpZGVudGl0eSxcbiAgICAgIGFjdGlvbnM6IFsnZXhlY3V0ZS1hcGk6TWFuYWdlQ29ubmVjdGlvbnMnXSxcbiAgICAgIHJlc291cmNlQXJuczogW2Ake2Fybn0vJHt0aGlzLnN0YWdlTmFtZX0vKi9AY29ubmVjdGlvbnMvKmBdLFxuICAgIH0pO1xuICB9XG59XG4iXX0=