"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRouteIntegration = exports.WebSocketIntegration = exports.WebSocketIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * WebSocket Integration Types
 */
var WebSocketIntegrationType;
(function (WebSocketIntegrationType) {
    /**
     * AWS Proxy Integration Type
     */
    WebSocketIntegrationType["AWS_PROXY"] = "AWS_PROXY";
    /**
     * Mock Integration Type
     */
    WebSocketIntegrationType["MOCK"] = "MOCK";
})(WebSocketIntegrationType = exports.WebSocketIntegrationType || (exports.WebSocketIntegrationType = {}));
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class WebSocketIntegration extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketIntegration);
            }
            throw error;
        }
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
        });
        this.integrationId = integ.ref;
        this.webSocketApi = props.webSocketApi;
    }
}
_a = JSII_RTTI_SYMBOL_1;
WebSocketIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketIntegration", version: "2.72.1-alpha.0" };
exports.WebSocketIntegration = WebSocketIntegration;
/**
 * The interface that various route integration classes will inherit.
 */
class WebSocketRouteIntegration {
    /**
     * Initialize an integration for a route on websocket api.
     * @param id id of the underlying `WebSocketIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.webSocketApi.node.addr !== options.route.webSocketApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new WebSocketIntegration(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                integrationType: config.type,
                integrationUri: config.uri,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
_b = JSII_RTTI_SYMBOL_1;
WebSocketRouteIntegration[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRouteIntegration", version: "2.72.1-alpha.0" };
exports.WebSocketRouteIntegration = WebSocketRouteIntegration;
//# sourceMappingURL=data:application/json;base64,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