"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpStage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const DEFAULT_STAGE_NAME = '$default';
class HttpStageBase extends base_1.StageBase {
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    metricLatency(props) {
        return this.metric('Latency', props);
    }
}
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class HttpStage extends HttpStageBase {
    /**
     * Import an existing stage into this CDK app.
     */
    static fromHttpStageAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromHttpStageAttributes);
            }
            throw error;
        }
        class Import extends HttpStageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get domainUrl() {
                throw new Error('domainUrl is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName ? props.stageName : DEFAULT_STAGE_NAME,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpStage);
            }
            throw error;
        }
        new aws_apigatewayv2_1.CfnStage(this, 'Resource', {
            apiId: props.httpApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
            defaultRouteSettings: !props.throttle ? undefined : {
                throttlingBurstLimit: props.throttle?.burstLimit,
                throttlingRateLimit: props.throttle?.rateLimit,
            },
        });
        this.stageName = this.physicalName;
        this.baseApi = props.httpApi;
        this.api = props.httpApi;
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * The URL to this stage.
     */
    get url() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName === DEFAULT_STAGE_NAME ? '' : this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    get domainUrl() {
        if (!this._apiMapping) {
            throw new Error('domainUrl is not available when no API mapping is associated with the Stage');
        }
        return `https://${this._apiMapping.domainName.name}/${this._apiMapping.mappingKey ?? ''}`;
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpStage", version: "2.72.1-alpha.0" };
exports.HttpStage = HttpStage;
//# sourceMappingURL=data:application/json;base64,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