# Generated by Django 2.1.2 on 2019-01-28 07:07

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("accounts", "0001_initial"),
        ("common", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Contact",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(max_length=255, verbose_name="First name"),
                ),
                (
                    "last_name",
                    models.CharField(max_length=255, verbose_name="Last name"),
                ),
                ("email", models.EmailField(max_length=254, unique=True)),
                (
                    "phone",
                    phonenumber_field.modelfields.PhoneNumberField(
                        max_length=128, null=True, unique=True
                    ),
                ),
                ("description", models.TextField(blank=True, null=True)),
                (
                    "created_on",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created on"),
                ),
                ("is_active", models.BooleanField(default=False)),
                (
                    "account",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="lead_account_contacts",
                        to="accounts.Account",
                    ),
                ),
                (
                    "address",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="adress_contacts",
                        to="common.Address",
                    ),
                ),
                (
                    "assigned_to",
                    models.ManyToManyField(
                        related_name="contact_assigned_users",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contact_created_by",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("teams", models.ManyToManyField(to="common.Team")),
            ],
        ),
        # migrations.AlterUniqueTogether(
        #     name='contact',
        #     unique_together={('email',)},
        # ),
    ]
