import { Duration } from 'aws-cdk-lib';
/**
 * (experimental) Schedule for canary runs.
 *
 * @experimental
 */
export declare class Schedule {
    /**
     * The Schedule expression
     */
    readonly expressionString: string;
    /**
     * (experimental) The canary will be executed once.
     *
     * @experimental
     */
    static once(): Schedule;
    /**
     * (experimental) Construct a schedule from a literal schedule expression.
     *
     * The expression must be in a `rate(number units)` format.
     * For example, `Schedule.expression('rate(10 minutes)')`
     *
     * @param expression The expression to use.
     * @experimental
     */
    static expression(expression: string): Schedule;
    /**
     * (experimental) Construct a schedule from an interval.
     *
     * Allowed values: 0 (for a single run) or between 1 and 60 minutes.
     * To specify a single run, you can use `Schedule.once()`.
     *
     * @param interval The interval at which to run the canary.
     * @experimental
     */
    static rate(interval: Duration): Schedule;
    private constructor();
}
