"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MutualTlsCertificate = exports.TlsCertificate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a TLS certificate.
 *
 * @stability stable
 */
class TlsCertificate {
    /**
     * Returns an File TLS Certificate.
     *
     * @stability stable
     */
    static file(certificateChainPath, privateKeyPath) {
        return new FileTlsCertificate(certificateChainPath, privateKeyPath);
    }
    /**
     * Returns an ACM TLS Certificate.
     *
     * @stability stable
     */
    static acm(certificate) {
        return new AcmTlsCertificate(certificate);
    }
    /**
     * Returns an SDS TLS Certificate.
     *
     * @stability stable
     */
    static sds(secretName) {
        return new SdsTlsCertificate(secretName);
    }
}
exports.TlsCertificate = TlsCertificate;
_a = JSII_RTTI_SYMBOL_1;
TlsCertificate[_a] = { fqn: "@aws-cdk/aws-appmesh.TlsCertificate", version: "1.134.0" };
/**
 * Represents a TLS certificate that is supported for mutual TLS authentication.
 *
 * @stability stable
 */
class MutualTlsCertificate extends TlsCertificate {
    constructor() {
        super(...arguments);
        // TypeScript uses structural typing, so we need a property different from TlsCertificate
        /**
         * @stability stable
         */
        this.differentiator = false;
    }
}
exports.MutualTlsCertificate = MutualTlsCertificate;
_b = JSII_RTTI_SYMBOL_1;
MutualTlsCertificate[_b] = { fqn: "@aws-cdk/aws-appmesh.MutualTlsCertificate", version: "1.134.0" };
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(certificate) {
        super();
        this.acmCertificate = certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends MutualTlsCertificate {
    constructor(certificateChainPath, privateKeyPath) {
        super();
        this.certificateChain = certificateChainPath;
        this.privateKey = privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
        };
    }
}
/**
 * Represents a SDS provided TLS certificate
 */
class SdsTlsCertificate extends MutualTlsCertificate {
    constructor(secretName) {
        super();
        this.secretName = secretName;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                sds: {
                    secretName: this.secretName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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