# Generated by Django 3.1.2 on 2020-10-08 15:42

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Descriptors',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(default='', max_length=128)),
                ('value', models.CharField(default='', max_length=768)),
                ('source', models.CharField(default='', max_length=64)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'descriptors',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Identifiers',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('casrn', 'CAS Registry Number'), ('inchi', 'IUPAC InChI String'), ('inchikey', 'IUPAC InChI Key'), ('csmiles', 'Canonical SMILES'), ('ismiles', 'Isomeric SMILES'), ('chemspider', 'Chemspider ID'), ('pubchem', 'PubChem Compound ID'), ('iupacname', 'IUPAC Name'), ('springer', 'Springer ID'), ('othername', 'Other Name'), ('atc', 'ATC Code'), ('reaxys', 'Reaxys ID'), ('gmelin', 'Gmelin ID'), ('chebi', 'ChEBI ID'), ('chembl', 'ChEMBL ID'), ('rtecs', 'RTECS ID'), ('dsstox', 'DSSTOX ID')], default='casrn', max_length=10)),
                ('value', models.CharField(default='', max_length=768)),
                ('iso', models.CharField(max_length=5, null=True)),
                ('source', models.CharField(default='', max_length=64)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'identifiers',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Sources',
            fields=[
                ('id', models.AutoField(db_column='Id', primary_key=True, serialize=False)),
                ('source', models.CharField(max_length=32)),
                ('result', models.CharField(max_length=1)),
                ('notes', models.CharField(blank=True, max_length=2000, null=True)),
                ('updated', models.DateTimeField()),
            ],
            options={
                'db_table': 'sources',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Substances',
            fields=[
                ('id', models.SmallAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(default='', max_length=256)),
                ('formula', models.CharField(default='', max_length=256)),
                ('monomass', models.FloatField(default=0.0)),
                ('molweight', models.FloatField(default=0.0)),
                ('casrn', models.CharField(default='', max_length=16)),
                ('graphdb', models.CharField(max_length=256, null=True)),
                ('comments', models.CharField(max_length=256, null=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'substances',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='SubstancesSystems',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('substance_id', models.SmallIntegerField()),
                ('system_id', models.SmallIntegerField()),
                ('role', models.CharField(blank=True, max_length=13, null=True)),
                ('constituent', models.PositiveIntegerField(blank=True, null=True)),
                ('mixture_id', models.IntegerField(blank=True, null=True)),
                ('updated', models.DateTimeField()),
            ],
            options={
                'db_table': 'substances_systems',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Templates',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=16)),
                ('json', models.TextField()),
                ('updated', models.DateTimeField()),
            ],
            options={
                'db_table': 'templates',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Systems',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=1024)),
                ('composition', models.CharField(choices=[('PS', 'pure compound'), ('BM', 'binary mixture'), ('TM', 'ternary mixture'), ('QM', 'quaternary mixture'), ('NM', 'quinternary mixture')], default='PS', max_length=2)),
                ('identifier', models.CharField(default='', max_length=128)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('substance1', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='substance1', to='substances.substances')),
                ('substance2', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='substance2', to='substances.substances')),
                ('substance3', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='substance3', to='substances.substances')),
                ('substance4', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='substance4', to='substances.substances')),
                ('substance5', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='substance5', to='substances.substances')),
            ],
            options={
                'db_table': 'systems',
                'managed': False,
            },
        ),
    ]
