"""
Django settings for sciflow project.

Generated by 'django-admin startproject' using Django 3.0.5.

For more information on this file, see
https://docs.djangoproject.com/en/3.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.0/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'xzdi*3p9062t$u9yz5jehu2xsjc=9!+75hlic=-3k^=k^!ssch7rf'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['sds.coas.unf.edu', '127.0.0.1']


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'crispy_forms',
    'social_django',
    'crosswalks',
    'datasets',
    'substances',
    'users',
    'workflow',
    'datafiles',
    'debug_toolbar',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'debug_toolbar.middleware.DebugToolbarMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'sciflow.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'sciflow.wsgi.application'


# Database
# https://docs.djangoproject.com/en/3.0/ref/settings/#databases

LOCALDB = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

UNFDB = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'sciflow',
        'USER': 'sciflow',
        'PASSWORD': 'letthedatafl0w',
        'HOST': '127.0.0.1',
        'PORT': '3307'
    }
}

DATABASES = UNFDB


# Password validation
# https://docs.djangoproject.com/en/3.0/ref/settings/#auth-password-validators
ua = 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator'
ml = 'django.contrib.auth.password_validation.MinimumLengthValidator'
cp = 'django.contrib.auth.password_validation.CommonPasswordValidator'
np = 'django.contrib.auth.password_validation.NumericPasswordValidator'
AUTH_PASSWORD_VALIDATORS = [
    {'NAME': ua}, {'NAME': ml}, {'NAME': cp}, {'NAME': np}
]

# database autofield selection (Django 3.2)
DEFAULT_AUTO_FIELD = 'django.db.models.AutoField'

# Internationalization
# https://docs.djangoproject.com/en/3.0/topics/i18n/

LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'UTC'
USE_I18N = True
USE_L10N = True
USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.0/howto/static-files/

STATIC_URL = '/static/'


# Crispy settings

CRISPY_TEMPLATE_PACK = "bootstrap4"


# graphdb ingest directory on sds
gdrivesds = "/Users/n00002621/GoogleDrive/Research/sciflow"


# User settings

LOGIN_URL = '/login/auth0'
LOGIN_REDIRECT_URL = "/"
LOGOUT_REDIRECT_URL = "/"

# Slack settings

SLACK_CLIENT_ID = '4596507645.1171018047123'
SLACK_CLIENT_SECRET = '497b35bbd6b1ae0b721bff4ca1e0660b'
SLACK_VERIFICATION_TOKEN = '83qbRMdzma6QJBlF5LnV4XnN'
SLACK_BOT_USER_TOKEN = 'xoxb-4596507645-1171034330099-eP4swGipytYQHLnomPvBoOPO'


# Auth0 Settings

SOCIAL_AUTH_TRAILING_SLASH = False  # Remove trailing slash from routes
SOCIAL_AUTH_AUTH0_DOMAIN = 'sciflow.us.auth0.com'
SOCIAL_AUTH_AUTH0_KEY = 'yqDlGgfUFMr9GUNW7nEFLrc92IoccnNU'
secret = 'QWZvHaULslFysaVMaXqYPqinzKfMLo8MrgLEEMBmRKy99vb-q2LpuTCurSDWhSJR'
SOCIAL_AUTH_AUTH0_SECRET = secret

SOCIAL_AUTH_AUTH0_SCOPE = [
    'openid',
    'profile',
    'email'
]

AUTHENTICATION_BACKENDS = {
    'users.auth0backend.Auth0',
    'django.contrib.auth.backends.ModelBackend'
}

# Debug toolbar settings

INTERNAL_IPS = [
    '127.0.0.1',
]
