# This file was autogenerated from vk-api json schema

from typing import List, Union, Optional, overload
from easy_vk.types import objects
from easy_vk.types import responses
from easy_vk.api_category import BaseCategory
try:
    from typing import Literal
except Exception:
    from typing_extensions import Literal


class Photos(BaseCategory):
    def __init__(self, session, access_token: str, v: str, last_call_timer, delay: float, auto_retry: bool, max_retries: int, timeout: float):
        super().__init__(session, access_token, v, last_call_timer, delay, auto_retry, max_retries, timeout)

    def get_messages_upload_server(self, peer_id: Optional[int] = None) -> responses.PhotosGetMessagesUploadServer:
        """
        Returns the server address for photo upload in a private message for a user.
        
        :param peer_id: Destination ID. "For user: 'User ID', e.g. '12345'. For chat: '2000000000' + 'Chat ID', e.g. '2000000001'. For community: '- Community ID', e.g. '-12345'. "
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'photos.getMessagesUploadServer'
        response_type = responses.PhotosGetMessagesUploadServer
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_owner_cover_photo_upload_server(self, group_id: int, crop_x: Optional[int] = None, crop_y: Optional[int] = None, crop_x2: Optional[int] = None, crop_y2: Optional[int] = None) -> responses.BaseGetUploadServer:
        """
        Returns the server address for owner cover upload.
        
        :param group_id: ID of community that owns the album (if the photo will be uploaded to a community album).
        :param crop_x: X coordinate of the left-upper corner
        :param crop_y: Y coordinate of the left-upper corner
        :param crop_x2: X coordinate of the right-bottom corner
        :param crop_y2: Y coordinate of the right-bottom corner
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'photos.getOwnerCoverPhotoUploadServer'
        response_type = responses.BaseGetUploadServer
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def save_messages_photo(self, photo: str, server: Optional[int] = None, hash_: Optional[str] = None) -> responses.PhotosSaveMessagesPhoto:
        """
        Saves a photo after being successfully uploaded. URL obtained with [vk.com/dev/photos.getMessagesUploadServer|photos.getMessagesUploadServer] method.
        
        :param photo: Parameter returned when the photo is [vk.com/dev/upload_files|uploaded to the server].
        :param server:
        :param hash_:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('hash_', 'hash')]
        method_name = 'photos.saveMessagesPhoto'
        response_type = responses.PhotosSaveMessagesPhoto
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def save_owner_cover_photo(self, hash_: str, photo: str) -> responses.PhotosSaveOwnerCoverPhoto:
        """
        Saves cover photo after successful uploading.
        
        :param hash_: Parameter returned when photos are [vk.com/dev/upload_files|uploaded to server].
        :param photo: Parameter returned when photos are [vk.com/dev/upload_files|uploaded to server].
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = [('hash_', 'hash')]
        method_name = 'photos.saveOwnerCoverPhoto'
        response_type = responses.PhotosSaveOwnerCoverPhoto
        return self._call(method_name, method_parameters, param_aliases, response_type)
