# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1


@dataclass
class RuntimeClass(DataclassDictMixIn):
    """RuntimeClass defines a class of container runtime supported in the cluster.
      The RuntimeClass is used to determine which container runtime is used to run
      all containers in a pod. RuntimeClasses are (currently) manually defined by a
      user or cluster provisioner, and referenced in the PodSpec. The Kubelet is
      responsible for resolving the RuntimeClassName reference before running the
      pod.  For more details, see
      https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md

      **parameters**

      * **handler** ``str`` - Handler specifies the underlying runtime and configuration that the CRI
        implementation will use to handle pods of this class. The possible values are
        specific to the node & CRI configuration.  It is assumed that all handlers are
        available on every node, and handlers of the same name are equivalent on every
        node. For example, a handler called "runc" might specify that the runc OCI
        runtime (using native Linux containers) will be used to run the containers in
        a pod. The Handler must conform to the DNS Label (RFC 1123) requirements, and
        is immutable.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
    """
    handler: 'str'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None


@dataclass
class RuntimeClassList(DataclassDictMixIn):
    """RuntimeClassList is a list of RuntimeClass objects.

      **parameters**

      * **items** ``List[RuntimeClass]`` - Items is a list of schema objects.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
    """
    items: 'List[RuntimeClass]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


