# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1
from . import util_intstr
from . import core_v1


@dataclass
class HTTPIngressPath(DataclassDictMixIn):
    """HTTPIngressPath associates a path regex with a backend. Incoming urls matching
      the path are forwarded to the backend.

      **parameters**

      * **backend** ``IngressBackend`` - Backend defines the referenced service endpoint to which the traffic will be
        forwarded to.
      * **path** ``str`` - *(optional)* Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this
        follows the egrep/unix syntax, not the perl syntax) matched against the path
        of an incoming request. Currently it can contain characters disallowed from
        the conventional "path" part of a URL as defined by RFC 3986. Paths must begin
        with a '/'. If unspecified, the path defaults to a catch all sending traffic
        to the backend.
    """
    backend: 'IngressBackend'
    path: 'str' = None


@dataclass
class HTTPIngressRuleValue(DataclassDictMixIn):
    """HTTPIngressRuleValue is a list of http selectors pointing to backends. In the
      example: http://<host>/<path>?<searchpart> -> backend where where parts of the
      url correspond to RFC 3986, this resource will be used to match against
      everything after the last '/' and before the first '?' or '#'.

      **parameters**

      * **paths** ``List[HTTPIngressPath]`` - A collection of paths that map requests to backends.
    """
    paths: 'List[HTTPIngressPath]'


@dataclass
class Ingress(DataclassDictMixIn):
    """Ingress is a collection of rules that allow inbound connections to reach the
      endpoints defined by a backend. An Ingress can be configured to give services
      externally-reachable urls, load balance traffic, terminate SSL, offer name
      based virtual hosting etc.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
      * **spec** ``IngressSpec`` - *(optional)* Spec is the desired state of the Ingress. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
      * **status** ``IngressStatus`` - *(optional)* Status is the current state of the Ingress. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'IngressSpec' = None
    status: 'IngressStatus' = None


@dataclass
class IngressBackend(DataclassDictMixIn):
    """IngressBackend describes all endpoints for a given service and port.

      **parameters**

      * **serviceName** ``str`` - Specifies the name of the referenced service.
      * **servicePort** ``util_intstr.IntOrString`` - Specifies the port of the referenced service.
    """
    serviceName: 'str'
    servicePort: 'util_intstr.IntOrString'


@dataclass
class IngressList(DataclassDictMixIn):
    """IngressList is a collection of Ingress.

      **parameters**

      * **items** ``List[Ingress]`` - Items is the list of Ingress.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
    """
    items: 'List[Ingress]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class IngressRule(DataclassDictMixIn):
    """IngressRule represents the rules mapping the paths under a specified host to
      the related backend services. Incoming requests are first evaluated for a host
      match, then routed to the backend associated with the matching
      IngressRuleValue.

      **parameters**

      * **host** ``str`` - *(optional)* Host is the fully qualified domain name of a network host, as defined by RFC
        3986. Note the following deviations from the "host" part of the URI as defined
        in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only
        apply to the
        	  IP in the Spec of the parent Ingress.
        2. The `:` delimiter is not respected because ports are not allowed.
        	  Currently the port of an Ingress is implicitly :80 for http and
        	  :443 for https.
        Both these may change in the future. Incoming requests are matched against the
        host before the IngressRuleValue. If the host is unspecified, the Ingress
        routes all traffic based on the specified IngressRuleValue.
      * **http** ``HTTPIngressRuleValue`` - *(optional)* 
    """
    host: 'str' = None
    http: 'HTTPIngressRuleValue' = None


@dataclass
class IngressSpec(DataclassDictMixIn):
    """IngressSpec describes the Ingress the user wishes to exist.

      **parameters**

      * **backend** ``IngressBackend`` - *(optional)* A default backend capable of servicing requests that don't match any rule. At
        least one of 'backend' or 'rules' must be specified. This field is optional to
        allow the loadbalancer controller or defaulting logic to specify a global
        default.
      * **rules** ``List[IngressRule]`` - *(optional)* A list of host rules used to configure the Ingress. If unspecified, or no rule
        matches, all traffic is sent to the default backend.
      * **tls** ``List[IngressTLS]`` - *(optional)* TLS configuration. Currently the Ingress only supports a single TLS port, 443.
        If multiple members of this list specify different hosts, they will be
        multiplexed on the same port according to the hostname specified through the
        SNI TLS extension, if the ingress controller fulfilling the ingress supports
        SNI.
    """
    backend: 'IngressBackend' = None
    rules: 'List[IngressRule]' = None
    tls: 'List[IngressTLS]' = None


@dataclass
class IngressStatus(DataclassDictMixIn):
    """IngressStatus describe the current state of the Ingress.

      **parameters**

      * **loadBalancer** ``core_v1.LoadBalancerStatus`` - *(optional)* LoadBalancer contains the current status of the load-balancer.
    """
    loadBalancer: 'core_v1.LoadBalancerStatus' = None


@dataclass
class IngressTLS(DataclassDictMixIn):
    """IngressTLS describes the transport layer security associated with an Ingress.

      **parameters**

      * **hosts** ``List[str]`` - *(optional)* Hosts are a list of hosts included in the TLS certificate. The values in this
        list must match the name/s used in the tlsSecret. Defaults to the wildcard
        host setting for the loadbalancer controller fulfilling this Ingress, if left
        unspecified.
      * **secretName** ``str`` - *(optional)* SecretName is the name of the secret used to terminate SSL traffic on 443.
        Field is left optional to allow SSL routing based on SNI hostname alone. If
        the SNI host in a listener conflicts with the "Host" header field used by an
        IngressRule, the SNI host is used for termination and value of the Host header
        is used for routing.
    """
    hosts: 'List[str]' = None
    secretName: 'str' = None


