# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1
from . import core_v1


@dataclass
class Job(DataclassDictMixIn):
    """Job represents the configuration of a single job.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
      * **spec** ``JobSpec`` - *(optional)* Specification of the desired behavior of a job. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
      * **status** ``JobStatus`` - *(optional)* Current status of a job. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'JobSpec' = None
    status: 'JobStatus' = None


@dataclass
class JobCondition(DataclassDictMixIn):
    """JobCondition describes current state of a job.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of job condition, Complete or Failed.
      * **lastProbeTime** ``meta_v1.Time`` - *(optional)* Last time the condition was checked.
      * **lastTransitionTime** ``meta_v1.Time`` - *(optional)* Last time the condition transit from one status to another.
      * **message** ``str`` - *(optional)* Human readable message indicating details about last transition.
      * **reason** ``str`` - *(optional)* (brief) reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastProbeTime: 'meta_v1.Time' = None
    lastTransitionTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class JobList(DataclassDictMixIn):
    """JobList is a collection of jobs.

      **parameters**

      * **items** ``List[Job]`` - items is the list of Jobs.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
    """
    items: 'List[Job]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class JobSpec(DataclassDictMixIn):
    """JobSpec describes how the job execution will look like.

      **parameters**

      * **template** ``core_v1.PodTemplateSpec`` - Describes the pod that will be created when executing a job. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **activeDeadlineSeconds** ``int`` - *(optional)* Specifies the duration in seconds relative to the startTime that the job may
        be active before the system tries to terminate it; value must be positive
        integer
      * **backoffLimit** ``int`` - *(optional)* Specifies the number of retries before marking this job failed. Defaults to 6
      * **completions** ``int`` - *(optional)* Specifies the desired number of successfully finished pods the job should be
        run with.  Setting to nil means that the success of any pod signals the
        success of all pods, and allows parallelism to have any positive value.
        Setting to 1 means that parallelism is limited to 1 and the success of that
        pod signals the success of the job. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **manualSelector** ``bool`` - *(optional)* manualSelector controls generation of pod labels and pod selectors. Leave
        `manualSelector` unset unless you are certain what you are doing. When false
        or unset, the system pick labels unique to this job and appends those labels
        to the pod template.  When true, the user is responsible for picking unique
        labels and specifying the selector.  Failure to pick a unique label may cause
        this and other jobs to not function correctly.  However, You may see
        `manualSelector=true` in jobs that were created with the old
        `extensions/v1beta1` API. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
      * **parallelism** ``int`` - *(optional)* Specifies the maximum desired number of pods the job should run at any given
        time. The actual number of pods running in steady state will be less than this
        number when ((.spec.completions - .status.successful) < .spec.parallelism),
        i.e. when the work left to do is less than max parallelism. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **selector** ``meta_v1.LabelSelector`` - *(optional)* A label query over pods that should match the pod count. Normally, the system
        sets this field for you. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
      * **ttlSecondsAfterFinished** ``int`` - *(optional)* ttlSecondsAfterFinished limits the lifetime of a Job that has finished
        execution (either Complete or Failed). If this field is set,
        ttlSecondsAfterFinished after the Job finishes, it is eligible to be
        automatically deleted. When the Job is being deleted, its lifecycle guarantees
        (e.g. finalizers) will be honored. If this field is unset, the Job won't be
        automatically deleted. If this field is set to zero, the Job becomes eligible
        to be deleted immediately after it finishes. This field is alpha-level and is
        only honored by servers that enable the TTLAfterFinished feature.
    """
    template: 'core_v1.PodTemplateSpec'
    activeDeadlineSeconds: 'int' = None
    backoffLimit: 'int' = None
    completions: 'int' = None
    manualSelector: 'bool' = None
    parallelism: 'int' = None
    selector: 'meta_v1.LabelSelector' = None
    ttlSecondsAfterFinished: 'int' = None


@dataclass
class JobStatus(DataclassDictMixIn):
    """JobStatus represents the current state of a Job.

      **parameters**

      * **active** ``int`` - *(optional)* The number of actively running pods.
      * **completionTime** ``meta_v1.Time`` - *(optional)* Represents time when the job was completed. It is not guaranteed to be set in
        happens-before order across separate operations. It is represented in RFC3339
        form and is in UTC.
      * **conditions** ``List[JobCondition]`` - *(optional)* The latest available observations of an object's current state. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **failed** ``int`` - *(optional)* The number of pods which reached phase Failed.
      * **startTime** ``meta_v1.Time`` - *(optional)* Represents time when the job was acknowledged by the job controller. It is not
        guaranteed to be set in happens-before order across separate operations. It is
        represented in RFC3339 form and is in UTC.
      * **succeeded** ``int`` - *(optional)* The number of pods which reached phase Succeeded.
    """
    active: 'int' = None
    completionTime: 'meta_v1.Time' = None
    conditions: 'List[JobCondition]' = None
    failed: 'int' = None
    startTime: 'meta_v1.Time' = None
    succeeded: 'int' = None


