# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1


@dataclass
class TokenReview(DataclassDictMixIn):
    """TokenReview attempts to authenticate a token to a known user. Note:
      TokenReview requests may be cached by the webhook token authenticator plugin
      in the kube-apiserver.

      **parameters**

      * **spec** ``TokenReviewSpec`` - Spec holds information about the request being evaluated
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* 
      * **status** ``TokenReviewStatus`` - *(optional)* Status is filled in by the server and indicates whether the request can be
        authenticated.
    """
    spec: 'TokenReviewSpec'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    status: 'TokenReviewStatus' = None


@dataclass
class TokenReviewSpec(DataclassDictMixIn):
    """TokenReviewSpec is a description of the token authentication request.

      **parameters**

      * **audiences** ``List[str]`` - *(optional)* Audiences is a list of the identifiers that the resource server presented with
        the token identifies as. Audience-aware token authenticators will verify that
        the token was intended for at least one of the audiences in this list. If no
        audiences are provided, the audience will default to the audience of the
        Kubernetes apiserver.
      * **token** ``str`` - *(optional)* Token is the opaque bearer token.
    """
    audiences: 'List[str]' = None
    token: 'str' = None


@dataclass
class TokenReviewStatus(DataclassDictMixIn):
    """TokenReviewStatus is the result of the token authentication request.

      **parameters**

      * **audiences** ``List[str]`` - *(optional)* Audiences are audience identifiers chosen by the authenticator that are
        compatible with both the TokenReview and token. An identifier is any
        identifier in the intersection of the TokenReviewSpec audiences and the
        token's audiences. A client of the TokenReview API that sets the
        spec.audiences field should validate that a compatible audience identifier is
        returned in the status.audiences field to ensure that the TokenReview server
        is audience aware. If a TokenReview returns an empty status.audience field
        where status.authenticated is "true", the token is valid against the audience
        of the Kubernetes API server.
      * **authenticated** ``bool`` - *(optional)* Authenticated indicates that the token was associated with a known user.
      * **error** ``str`` - *(optional)* Error indicates that the token couldn't be checked
      * **user** ``UserInfo`` - *(optional)* User is the UserInfo associated with the provided token.
    """
    audiences: 'List[str]' = None
    authenticated: 'bool' = None
    error: 'str' = None
    user: 'UserInfo' = None


@dataclass
class UserInfo(DataclassDictMixIn):
    """UserInfo holds the information about the user needed to implement the
      user.Info interface.

      **parameters**

      * **extra** ``dict`` - *(optional)* Any additional information provided by the authenticator.
      * **groups** ``List[str]`` - *(optional)* The names of groups this user is a part of.
      * **uid** ``str`` - *(optional)* A unique value that identifies this user across time. If this user is deleted
        and another user by the same name is added, they will have different UIDs.
      * **username** ``str`` - *(optional)* The name that uniquely identifies this user among all active users.
    """
    extra: 'dict' = None
    groups: 'List[str]' = None
    uid: 'str' = None
    username: 'str' = None


