"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackNotifier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const channel_types_1 = require("./channel-types");
class SlackNotifier extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { slackBotToken, slackSigningSecret, slackChannel, slackChannelId, slackChannelTypes, slackBotName, slackBotIcon, pipeline, stageNames, } = props;
        this.environment = {
            SLACK_BOT_TOKEN: slackBotToken,
            SLACK_SIGNING_SECRET: slackSigningSecret,
            SLACK_CHANNEL: slackChannel || '',
            SLACK_CHANNEL_ID: slackChannelId || '',
            SLACK_CHANNEL_TYPES: (slackChannelTypes || [channel_types_1.ChannelTypes.PUBLIC]).join(','),
        };
        if (slackBotName) {
            this.environment.SLACK_BOT_NAME = slackBotName;
        }
        if (slackBotIcon) {
            this.environment.SLACK_BOT_ICON = slackBotIcon;
        }
        const notifier = new aws_lambda_1.Function(scope, 'SlackNotifierFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.asset(path.join(__dirname, 'lambdas', 'notifier')),
            environment: this.environment,
        });
        notifier.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [pipeline.pipelineArn],
            actions: ['codepipeline:GetPipelineState', 'codepipeline:GetPipelineExecution'],
        }));
        pipeline.onStateChange('SlackPipelineNotifierRule', {
            target: new aws_events_targets_1.LambdaFunction(notifier),
        });
        const stageRule = new aws_events_1.Rule(this, 'SlackStageNotifierRule');
        stageRule.addTarget(new aws_events_targets_1.LambdaFunction(notifier));
        stageRule.addEventPattern({
            source: ['aws.codepipeline'],
            resources: [pipeline.pipelineArn],
            detailType: ['CodePipeline Stage Execution State Change'],
        });
        if (stageNames) {
            stageRule.addEventPattern({
                detail: {
                    stage: stageNames,
                },
            });
        }
    }
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    validate() {
        if (this.environment.SLACK_CHANNEL && this.environment.SLACK_CHANNEL_ID) {
            return ['Redundant Configuration: Please configure slackChannel by id (prop slackChannelId) OR name (prop slackChannel)'];
        }
        if (!this.environment.SLACK_CHANNEL && !this.environment.SLACK_CHANNEL_ID) {
            return ['Missing Configuration: Please configure slackChannel by id (prop slackChannelId) or name (prop slackChannel)'];
        }
        return [];
    }
}
exports.SlackNotifier = SlackNotifier;
_a = JSII_RTTI_SYMBOL_1;
SlackNotifier[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-slack.SlackNotifier", version: "1.29.0" };
//# sourceMappingURL=data:application/json;base64,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