import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Lambda::Alias`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
export interface CfnAliasProps {
    /**
     * `AWS::Lambda::Alias.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Alias.FunctionVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     */
    readonly functionVersion: string;
    /**
     * `AWS::Lambda::Alias.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     */
    readonly name: string;
    /**
     * `AWS::Lambda::Alias.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Alias.ProvisionedConcurrencyConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-provisionedconcurrencyconfig
     */
    readonly provisionedConcurrencyConfig?: CfnAlias.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Alias.RoutingConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     */
    readonly routingConfig?: CfnAlias.AliasRoutingConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
export declare class CfnAlias extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Alias";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAlias;
    /**
     * `AWS::Lambda::Alias.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::Alias.FunctionVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     */
    functionVersion: string;
    /**
     * `AWS::Lambda::Alias.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     */
    name: string;
    /**
     * `AWS::Lambda::Alias.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Alias.ProvisionedConcurrencyConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-provisionedconcurrencyconfig
     */
    provisionedConcurrencyConfig: CfnAlias.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Alias.RoutingConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     */
    routingConfig: CfnAlias.AliasRoutingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Alias`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAliasProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
export declare namespace CfnAlias {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html
     */
    interface AliasRoutingConfigurationProperty {
        /**
         * `CfnAlias.AliasRoutingConfigurationProperty.AdditionalVersionWeights`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html#cfn-lambda-alias-aliasroutingconfiguration-additionalversionweights
         */
        readonly additionalVersionWeights: Array<CfnAlias.VersionWeightProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
export declare namespace CfnAlias {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-provisionedconcurrencyconfiguration.html
     */
    interface ProvisionedConcurrencyConfigurationProperty {
        /**
         * `CfnAlias.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-provisionedconcurrencyconfiguration.html#cfn-lambda-alias-provisionedconcurrencyconfiguration-provisionedconcurrentexecutions
         */
        readonly provisionedConcurrentExecutions: number;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
export declare namespace CfnAlias {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html
     */
    interface VersionWeightProperty {
        /**
         * `CfnAlias.VersionWeightProperty.FunctionVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionversion
         */
        readonly functionVersion: string;
        /**
         * `CfnAlias.VersionWeightProperty.FunctionWeight`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionweight
         */
        readonly functionWeight: number;
    }
}
/**
 * Properties for defining a `AWS::Lambda::CodeSigningConfig`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html
 */
export interface CfnCodeSigningConfigProps {
    /**
     * `AWS::Lambda::CodeSigningConfig.AllowedPublishers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-allowedpublishers
     */
    readonly allowedPublishers: CfnCodeSigningConfig.AllowedPublishersProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::CodeSigningConfig.CodeSigningPolicies`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-codesigningpolicies
     */
    readonly codeSigningPolicies?: CfnCodeSigningConfig.CodeSigningPoliciesProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::CodeSigningConfig.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::Lambda::CodeSigningConfig`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::CodeSigningConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html
 */
export declare class CfnCodeSigningConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::CodeSigningConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCodeSigningConfig;
    /**
     * @external
     * @cloudformationAttribute CodeSigningConfigArn
     */
    readonly attrCodeSigningConfigArn: string;
    /**
     * @external
     * @cloudformationAttribute CodeSigningConfigId
     */
    readonly attrCodeSigningConfigId: string;
    /**
     * `AWS::Lambda::CodeSigningConfig.AllowedPublishers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-allowedpublishers
     */
    allowedPublishers: CfnCodeSigningConfig.AllowedPublishersProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::CodeSigningConfig.CodeSigningPolicies`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-codesigningpolicies
     */
    codeSigningPolicies: CfnCodeSigningConfig.CodeSigningPoliciesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::CodeSigningConfig.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::Lambda::CodeSigningConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCodeSigningConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::CodeSigningConfig`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::CodeSigningConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html
 */
export declare namespace CfnCodeSigningConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-codesigningconfig-allowedpublishers.html
     */
    interface AllowedPublishersProperty {
        /**
         * `CfnCodeSigningConfig.AllowedPublishersProperty.SigningProfileVersionArns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-codesigningconfig-allowedpublishers.html#cfn-lambda-codesigningconfig-allowedpublishers-signingprofileversionarns
         */
        readonly signingProfileVersionArns: string[];
    }
}
/**
 * A CloudFormation `AWS::Lambda::CodeSigningConfig`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::CodeSigningConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html
 */
export declare namespace CfnCodeSigningConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-codesigningconfig-codesigningpolicies.html
     */
    interface CodeSigningPoliciesProperty {
        /**
         * `CfnCodeSigningConfig.CodeSigningPoliciesProperty.UntrustedArtifactOnDeployment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-codesigningconfig-codesigningpolicies.html#cfn-lambda-codesigningconfig-codesigningpolicies-untrustedartifactondeployment
         */
        readonly untrustedArtifactOnDeployment: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::EventInvokeConfig`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 */
export interface CfnEventInvokeConfigProps {
    /**
     * `AWS::Lambda::EventInvokeConfig.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.Qualifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier
     */
    readonly qualifier: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.DestinationConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig
     */
    readonly destinationConfig?: CfnEventInvokeConfig.DestinationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumEventAgeInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds
     */
    readonly maximumEventAgeInSeconds?: number;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumRetryAttempts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts
     */
    readonly maximumRetryAttempts?: number;
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 */
export declare class CfnEventInvokeConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::EventInvokeConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventInvokeConfig;
    /**
     * `AWS::Lambda::EventInvokeConfig.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.Qualifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier
     */
    qualifier: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.DestinationConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig
     */
    destinationConfig: CfnEventInvokeConfig.DestinationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumEventAgeInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds
     */
    maximumEventAgeInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumRetryAttempts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts
     */
    maximumRetryAttempts: number | undefined;
    /**
     * Create a new `AWS::Lambda::EventInvokeConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventInvokeConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 */
export declare namespace CfnEventInvokeConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html
     */
    interface DestinationConfigProperty {
        /**
         * `CfnEventInvokeConfig.DestinationConfigProperty.OnFailure`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig-onfailure
         */
        readonly onFailure?: CfnEventInvokeConfig.OnFailureProperty | cdk.IResolvable;
        /**
         * `CfnEventInvokeConfig.DestinationConfigProperty.OnSuccess`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig-onsuccess
         */
        readonly onSuccess?: CfnEventInvokeConfig.OnSuccessProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 */
export declare namespace CfnEventInvokeConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onfailure.html
     */
    interface OnFailureProperty {
        /**
         * `CfnEventInvokeConfig.OnFailureProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onfailure.html#cfn-lambda-eventinvokeconfig-destinationconfig-onfailure-destination
         */
        readonly destination: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 */
export declare namespace CfnEventInvokeConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onsuccess.html
     */
    interface OnSuccessProperty {
        /**
         * `CfnEventInvokeConfig.OnSuccessProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onsuccess.html#cfn-lambda-eventinvokeconfig-destinationconfig-onsuccess-destination
         */
        readonly destination: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::EventSourceMapping`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export interface CfnEventSourceMappingProps {
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::EventSourceMapping.BatchSize`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize
     */
    readonly batchSize?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.BisectBatchOnFunctionError`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror
     */
    readonly bisectBatchOnFunctionError?: boolean | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.DestinationConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig
     */
    readonly destinationConfig?: CfnEventSourceMapping.DestinationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.EventSourceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn
     */
    readonly eventSourceArn?: string;
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionResponseTypes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionresponsetypes
     */
    readonly functionResponseTypes?: string[];
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumBatchingWindowInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds
     */
    readonly maximumBatchingWindowInSeconds?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRecordAgeInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds
     */
    readonly maximumRecordAgeInSeconds?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRetryAttempts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts
     */
    readonly maximumRetryAttempts?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.ParallelizationFactor`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor
     */
    readonly parallelizationFactor?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.Queues`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues
     */
    readonly queues?: string[];
    /**
     * `AWS::Lambda::EventSourceMapping.SelfManagedEventSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedeventsource
     */
    readonly selfManagedEventSource?: CfnEventSourceMapping.SelfManagedEventSourceProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.SourceAccessConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations
     */
    readonly sourceAccessConfigurations?: Array<CfnEventSourceMapping.SourceAccessConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPosition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition
     */
    readonly startingPosition?: string;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPositionTimestamp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingpositiontimestamp
     */
    readonly startingPositionTimestamp?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.Topics`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics
     */
    readonly topics?: string[];
    /**
     * `AWS::Lambda::EventSourceMapping.TumblingWindowInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds
     */
    readonly tumblingWindowInSeconds?: number;
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export declare class CfnEventSourceMapping extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::EventSourceMapping";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventSourceMapping;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::EventSourceMapping.BatchSize`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize
     */
    batchSize: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.BisectBatchOnFunctionError`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror
     */
    bisectBatchOnFunctionError: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.DestinationConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig
     */
    destinationConfig: CfnEventSourceMapping.DestinationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.EventSourceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn
     */
    eventSourceArn: string | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionResponseTypes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionresponsetypes
     */
    functionResponseTypes: string[] | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumBatchingWindowInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds
     */
    maximumBatchingWindowInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRecordAgeInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds
     */
    maximumRecordAgeInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRetryAttempts`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts
     */
    maximumRetryAttempts: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.ParallelizationFactor`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor
     */
    parallelizationFactor: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.Queues`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues
     */
    queues: string[] | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.SelfManagedEventSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedeventsource
     */
    selfManagedEventSource: CfnEventSourceMapping.SelfManagedEventSourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.SourceAccessConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations
     */
    sourceAccessConfigurations: Array<CfnEventSourceMapping.SourceAccessConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPosition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition
     */
    startingPosition: string | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPositionTimestamp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingpositiontimestamp
     */
    startingPositionTimestamp: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.Topics`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics
     */
    topics: string[] | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.TumblingWindowInSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds
     */
    tumblingWindowInSeconds: number | undefined;
    /**
     * Create a new `AWS::Lambda::EventSourceMapping`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSourceMappingProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-destinationconfig.html
     */
    interface DestinationConfigProperty {
        /**
         * `CfnEventSourceMapping.DestinationConfigProperty.OnFailure`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-destinationconfig.html#cfn-lambda-eventsourcemapping-destinationconfig-onfailure
         */
        readonly onFailure?: CfnEventSourceMapping.OnFailureProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-endpoints.html
     */
    interface EndpointsProperty {
        /**
         * `CfnEventSourceMapping.EndpointsProperty.KafkaBootstrapServers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-endpoints.html#cfn-lambda-eventsourcemapping-endpoints-kafkabootstrapservers
         */
        readonly kafkaBootstrapServers?: string[];
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-onfailure.html
     */
    interface OnFailureProperty {
        /**
         * `CfnEventSourceMapping.OnFailureProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-onfailure.html#cfn-lambda-eventsourcemapping-onfailure-destination
         */
        readonly destination?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-selfmanagedeventsource.html
     */
    interface SelfManagedEventSourceProperty {
        /**
         * `CfnEventSourceMapping.SelfManagedEventSourceProperty.Endpoints`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-selfmanagedeventsource.html#cfn-lambda-eventsourcemapping-selfmanagedeventsource-endpoints
         */
        readonly endpoints?: CfnEventSourceMapping.EndpointsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html
     */
    interface SourceAccessConfigurationProperty {
        /**
         * `CfnEventSourceMapping.SourceAccessConfigurationProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html#cfn-lambda-eventsourcemapping-sourceaccessconfiguration-type
         */
        readonly type?: string;
        /**
         * `CfnEventSourceMapping.SourceAccessConfigurationProperty.URI`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html#cfn-lambda-eventsourcemapping-sourceaccessconfiguration-uri
         */
        readonly uri?: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::Function`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export interface CfnFunctionProps {
    /**
     * `AWS::Lambda::Function.Code`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-code
     */
    readonly code: CfnFunction.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-role
     */
    readonly role: string;
    /**
     * `AWS::Lambda::Function.Architectures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-architectures
     */
    readonly architectures?: string[];
    /**
     * `AWS::Lambda::Function.CodeSigningConfigArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-codesigningconfigarn
     */
    readonly codeSigningConfigArn?: string;
    /**
     * `AWS::Lambda::Function.DeadLetterConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-deadletterconfig
     */
    readonly deadLetterConfig?: CfnFunction.DeadLetterConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Function.Environment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-environment
     */
    readonly environment?: CfnFunction.EnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.FileSystemConfigs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-filesystemconfigs
     */
    readonly fileSystemConfigs?: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-functionname
     */
    readonly functionName?: string;
    /**
     * `AWS::Lambda::Function.Handler`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-handler
     */
    readonly handler?: string;
    /**
     * `AWS::Lambda::Function.ImageConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-imageconfig
     */
    readonly imageConfig?: CfnFunction.ImageConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.KmsKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-kmskeyarn
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::Lambda::Function.Layers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-layers
     */
    readonly layers?: string[];
    /**
     * `AWS::Lambda::Function.MemorySize`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-memorysize
     */
    readonly memorySize?: number;
    /**
     * `AWS::Lambda::Function.PackageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-packagetype
     */
    readonly packageType?: string;
    /**
     * `AWS::Lambda::Function.ReservedConcurrentExecutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-reservedconcurrentexecutions
     */
    readonly reservedConcurrentExecutions?: number;
    /**
     * `AWS::Lambda::Function.Runtime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-runtime
     */
    readonly runtime?: string;
    /**
     * `AWS::Lambda::Function.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Lambda::Function.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-timeout
     */
    readonly timeout?: number;
    /**
     * `AWS::Lambda::Function.TracingConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tracingconfig
     */
    readonly tracingConfig?: CfnFunction.TracingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.VpcConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-vpcconfig
     */
    readonly vpcConfig?: CfnFunction.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare class CfnFunction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Function";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFunction;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Lambda::Function.Code`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-code
     */
    code: CfnFunction.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-role
     */
    role: string;
    /**
     * `AWS::Lambda::Function.Architectures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-architectures
     */
    architectures: string[] | undefined;
    /**
     * `AWS::Lambda::Function.CodeSigningConfigArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-codesigningconfigarn
     */
    codeSigningConfigArn: string | undefined;
    /**
     * `AWS::Lambda::Function.DeadLetterConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-deadletterconfig
     */
    deadLetterConfig: CfnFunction.DeadLetterConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Function.Environment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-environment
     */
    environment: CfnFunction.EnvironmentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.FileSystemConfigs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-filesystemconfigs
     */
    fileSystemConfigs: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-functionname
     */
    functionName: string | undefined;
    /**
     * `AWS::Lambda::Function.Handler`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-handler
     */
    handler: string | undefined;
    /**
     * `AWS::Lambda::Function.ImageConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-imageconfig
     */
    imageConfig: CfnFunction.ImageConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.KmsKeyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-kmskeyarn
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::Lambda::Function.Layers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-layers
     */
    layers: string[] | undefined;
    /**
     * `AWS::Lambda::Function.MemorySize`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-memorysize
     */
    memorySize: number | undefined;
    /**
     * `AWS::Lambda::Function.PackageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-packagetype
     */
    packageType: string | undefined;
    /**
     * `AWS::Lambda::Function.ReservedConcurrentExecutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-reservedconcurrentexecutions
     */
    reservedConcurrentExecutions: number | undefined;
    /**
     * `AWS::Lambda::Function.Runtime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-runtime
     */
    runtime: string | undefined;
    /**
     * `AWS::Lambda::Function.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Lambda::Function.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-timeout
     */
    timeout: number | undefined;
    /**
     * `AWS::Lambda::Function.TracingConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tracingconfig
     */
    tracingConfig: CfnFunction.TracingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.VpcConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-vpcconfig
     */
    vpcConfig: CfnFunction.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Function`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html
     */
    interface CodeProperty {
        /**
         * `CfnFunction.CodeProperty.ImageUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-imageuri
         */
        readonly imageUri?: string;
        /**
         * `CfnFunction.CodeProperty.S3Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3bucket
         */
        readonly s3Bucket?: string;
        /**
         * `CfnFunction.CodeProperty.S3Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3key
         */
        readonly s3Key?: string;
        /**
         * `CfnFunction.CodeProperty.S3ObjectVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3objectversion
         */
        readonly s3ObjectVersion?: string;
        /**
         * `CfnFunction.CodeProperty.ZipFile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-zipfile
         */
        readonly zipFile?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html
     */
    interface DeadLetterConfigProperty {
        /**
         * `CfnFunction.DeadLetterConfigProperty.TargetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html#cfn-lambda-function-deadletterconfig-targetarn
         */
        readonly targetArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html
     */
    interface EnvironmentProperty {
        /**
         * `CfnFunction.EnvironmentProperty.Variables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html#cfn-lambda-function-environment-variables
         */
        readonly variables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html
     */
    interface FileSystemConfigProperty {
        /**
         * `CfnFunction.FileSystemConfigProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-arn
         */
        readonly arn: string;
        /**
         * `CfnFunction.FileSystemConfigProperty.LocalMountPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
         */
        readonly localMountPath: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html
     */
    interface ImageConfigProperty {
        /**
         * `CfnFunction.ImageConfigProperty.Command`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-command
         */
        readonly command?: string[];
        /**
         * `CfnFunction.ImageConfigProperty.EntryPoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-entrypoint
         */
        readonly entryPoint?: string[];
        /**
         * `CfnFunction.ImageConfigProperty.WorkingDirectory`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-workingdirectory
         */
        readonly workingDirectory?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html
     */
    interface TracingConfigProperty {
        /**
         * `CfnFunction.TracingConfigProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html#cfn-lambda-function-tracingconfig-mode
         */
        readonly mode?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Function
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-subnetids
         */
        readonly subnetIds?: string[];
    }
}
/**
 * Properties for defining a `AWS::Lambda::LayerVersion`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 */
export interface CfnLayerVersionProps {
    /**
     * `AWS::Lambda::LayerVersion.Content`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-content
     */
    readonly content: CfnLayerVersion.ContentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::LayerVersion.CompatibleArchitectures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatiblearchitectures
     */
    readonly compatibleArchitectures?: string[];
    /**
     * `AWS::Lambda::LayerVersion.CompatibleRuntimes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatibleruntimes
     */
    readonly compatibleRuntimes?: string[];
    /**
     * `AWS::Lambda::LayerVersion.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::LayerVersion.LayerName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-layername
     */
    readonly layerName?: string;
    /**
     * `AWS::Lambda::LayerVersion.LicenseInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-licenseinfo
     */
    readonly licenseInfo?: string;
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersion`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::LayerVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 */
export declare class CfnLayerVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::LayerVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLayerVersion;
    /**
     * `AWS::Lambda::LayerVersion.Content`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-content
     */
    content: CfnLayerVersion.ContentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::LayerVersion.CompatibleArchitectures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatiblearchitectures
     */
    compatibleArchitectures: string[] | undefined;
    /**
     * `AWS::Lambda::LayerVersion.CompatibleRuntimes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatibleruntimes
     */
    compatibleRuntimes: string[] | undefined;
    /**
     * `AWS::Lambda::LayerVersion.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::LayerVersion.LayerName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-layername
     */
    layerName: string | undefined;
    /**
     * `AWS::Lambda::LayerVersion.LicenseInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-licenseinfo
     */
    licenseInfo: string | undefined;
    /**
     * Create a new `AWS::Lambda::LayerVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersion`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::LayerVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 */
export declare namespace CfnLayerVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html
     */
    interface ContentProperty {
        /**
         * `CfnLayerVersion.ContentProperty.S3Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3bucket
         */
        readonly s3Bucket: string;
        /**
         * `CfnLayerVersion.ContentProperty.S3Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3key
         */
        readonly s3Key: string;
        /**
         * `CfnLayerVersion.ContentProperty.S3ObjectVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3objectversion
         */
        readonly s3ObjectVersion?: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::LayerVersionPermission`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html
 */
export interface CfnLayerVersionPermissionProps {
    /**
     * `AWS::Lambda::LayerVersionPermission.Action`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-action
     */
    readonly action: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.LayerVersionArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-layerversionarn
     */
    readonly layerVersionArn: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.Principal`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-principal
     */
    readonly principal: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.OrganizationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-organizationid
     */
    readonly organizationId?: string;
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersionPermission`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::LayerVersionPermission
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html
 */
export declare class CfnLayerVersionPermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::LayerVersionPermission";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLayerVersionPermission;
    /**
     * `AWS::Lambda::LayerVersionPermission.Action`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-action
     */
    action: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.LayerVersionArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-layerversionarn
     */
    layerVersionArn: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.Principal`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-principal
     */
    principal: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.OrganizationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-organizationid
     */
    organizationId: string | undefined;
    /**
     * Create a new `AWS::Lambda::LayerVersionPermission`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerVersionPermissionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Lambda::Permission`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html
 */
export interface CfnPermissionProps {
    /**
     * `AWS::Lambda::Permission.Action`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action
     */
    readonly action: string;
    /**
     * `AWS::Lambda::Permission.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Permission.Principal`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal
     */
    readonly principal: string;
    /**
     * `AWS::Lambda::Permission.EventSourceToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken
     */
    readonly eventSourceToken?: string;
    /**
     * `AWS::Lambda::Permission.SourceAccount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount
     */
    readonly sourceAccount?: string;
    /**
     * `AWS::Lambda::Permission.SourceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn
     */
    readonly sourceArn?: string;
}
/**
 * A CloudFormation `AWS::Lambda::Permission`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Permission
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html
 */
export declare class CfnPermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Permission";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPermission;
    /**
     * `AWS::Lambda::Permission.Action`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action
     */
    action: string;
    /**
     * `AWS::Lambda::Permission.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::Permission.Principal`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal
     */
    principal: string;
    /**
     * `AWS::Lambda::Permission.EventSourceToken`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken
     */
    eventSourceToken: string | undefined;
    /**
     * `AWS::Lambda::Permission.SourceAccount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount
     */
    sourceAccount: string | undefined;
    /**
     * `AWS::Lambda::Permission.SourceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn
     */
    sourceArn: string | undefined;
    /**
     * Create a new `AWS::Lambda::Permission`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPermissionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Lambda::Version`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 */
export interface CfnVersionProps {
    /**
     * `AWS::Lambda::Version.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Version.CodeSha256`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     */
    readonly codeSha256?: string;
    /**
     * `AWS::Lambda::Version.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     */
    readonly provisionedConcurrencyConfig?: CfnVersion.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Version`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Version
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 */
export declare class CfnVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Version";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVersion;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: string;
    /**
     * `AWS::Lambda::Version.FunctionName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     */
    functionName: string;
    /**
     * `AWS::Lambda::Version.CodeSha256`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     */
    codeSha256: string | undefined;
    /**
     * `AWS::Lambda::Version.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     */
    provisionedConcurrencyConfig: CfnVersion.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Version`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::Version`.
 *
 * @external
 * @cloudformationResource AWS::Lambda::Version
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 */
export declare namespace CfnVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html
     */
    interface ProvisionedConcurrencyConfigurationProperty {
        /**
         * `CfnVersion.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html#cfn-lambda-version-provisionedconcurrencyconfiguration-provisionedconcurrentexecutions
         */
        readonly provisionedConcurrentExecutions: number;
    }
}
