import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()


setuptools.setup(
    name="dolib",
    version="0.1.3",
    author="Yury Balandin",
    author_email="yuri@balandin.ru",
    description="Digital Ocean API client library",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/geraxe/dolib",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Intended Audience :: Developers",
        "Intended Audience :: Information Technology",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Internet",
    ],
    python_requires=">=3.6",
    install_requires=["requests", "pydantic[email]"],
    zip_safe=False,
)
