% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentimsr.R
\name{rt_query}
\alias{rt_query}
\title{Get the retention time for each frame.}
\usage{
rt_query(
  opentims,
  min_rt,
  max_rt,
  columns = c("frame", "scan", "tof", "intensity", "mz", "dt", "rt")
)
}
\arguments{
\item{opentims}{Instance of OpenTIMS.}

\item{min_rt}{Lower boundry on retention time.}

\item{max_rt}{Upper boundry on retention time.}

\item{columns}{Vector of columns to extract. Defaults to all columns.}
}
\value{
data.frame with selected columns.
}
\description{
Extract all frames corresponding to retention times inside [min_rt, max_rt] closed borders interval.
}
