"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUserPoolAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
class HttpUserPoolAuthorizer {
    /**
     * (experimental) Initialize a Cognito user pool authorizer to be bound with HTTP route.
     *
     * @param id The id of the underlying construct.
     * @param pool The user pool to use for authorization.
     * @param props Properties to configure the authorizer.
     * @experimental
     */
    constructor(id, pool, props = {}) {
        this.id = id;
        this.pool = pool;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpUserPoolAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c, _d, _e;
        if (!this.authorizer) {
            const region = (_b = this.props.userPoolRegion) !== null && _b !== void 0 ? _b : core_1.Stack.of(options.scope).region;
            const clients = (_c = this.props.userPoolClients) !== null && _c !== void 0 ? _c : [this.pool.addClient('UserPoolAuthorizerClient')];
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_d = this.props.identitySource) !== null && _d !== void 0 ? _d : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: (_e = this.props.authorizerName) !== null && _e !== void 0 ? _e : this.id,
                jwtAudience: clients.map((c) => c.userPoolClientId),
                jwtIssuer: `https://cognito-idp.${region}.amazonaws.com/${this.pool.userPoolId}`,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpUserPoolAuthorizer = HttpUserPoolAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpUserPoolAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpUserPoolAuthorizer", version: "1.144.0" };
//# sourceMappingURL=data:application/json;base64,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