from typing import ClassVar, List

from typing import overload

class Attribute:
    def __init__(self) -> None: ...
    def push_line2D(self, arg0: List[float]) -> None: ...
    def push_line3D(self, arg0: List[float]) -> None: ...
    def push_point2D(self, arg0: List[float]) -> None: ...
    def push_point3D(self, arg0: List[float]) -> None: ...
    def push_polygon2D(self, arg0: List[List[float]]) -> None: ...
    def push_polygon3D(self, arg0: List[List[float]]) -> None: ...
    @property
    def geom_type(self) -> AttributeType: ...

class Grid:
    def __init__(self, arg0: float, arg1: float) -> None: ...
    def add_layer(self, arg0: Layer) -> None: ...
    def add_model(self, arg0: Model) -> None: ...
    def tile_merge(self) -> None: ...
    def to_gltf(self, arg0: str) -> None: ...

class Layer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: List[Model]) -> None: ...
    def add_model(self, arg0: Model) -> None: ...
    def add_models(self, arg0: List[Model]) -> None: ...
    def from_gltf(self, arg0: str) -> None: ...
    def get_models(self) -> List[Model]: ...
    def map_to_layer(self, arg0: Layer) -> None: ...
    def move_to_plane_z(self, arg0: float) -> None: ...
    def simplify_envelope(self) -> None: ...
    def simplify_remesh_height(self, arg0: float, arg1: int) -> None: ...
    def to_gltf(self, arg0: str) -> None: ...
    @property
    def size(self) -> int: ...

class MetadataMode:
    __members__: ClassVar[dict] = ...  # read-only
    AVERAGE: ClassVar[MetadataMode] = ...
    MAX_AREA: ClassVar[MetadataMode] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Model:
    def __init__(self) -> None: ...
    def add_attribute(self, arg0: str, arg1: Attribute) -> None: ...
    def attribute_exists(self, arg0: str) -> bool: ...
    def get_attribute(self, arg0: str) -> Attribute: ...
    def set_metadata(self, arg0: json) -> None: ...
    @property
    def geom_type(self) -> int: ...
    @property
    def metadata(self) -> json: ...

class Progress:
    def __init__(self, arg0: str) -> None: ...
    def update(self) -> None: ...

class QuadTree:
    @overload
    def __init__(self, models: List[Model], num_values_mode: MetadataMode = ..., max_depth: int = ...) -> None: ...
    @overload
    def __init__(self, layer: Layer, num_values_mode: MetadataMode = ..., max_depth: int = ...) -> None: ...
    def filter_metadata(self, arg0: List[str]) -> None: ...
    def merge_at_level(self, arg0: int) -> None: ...
    def to_json(self, dirname: str, yield_models_at_level: int, store_metadata: bool = ...) -> None: ...
