# Generated by Django 3.2.6 on 2022-03-22 10:47

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0003_auto_20220318_0918'),
    ]

    operations = [
        migrations.CreateModel(
            name='LegalEntity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pharm_zakaz_id', models.PositiveBigIntegerField(unique=True, verbose_name='Идентификатор на стороне ФармЗаказа')),
                ('created', models.DateTimeField(blank=True, null=True, verbose_name='Время, когда заказ был создан в системе ФармЗаказ')),
                ('inn', models.CharField(max_length=255, unique=True, verbose_name='ИНН')),
                ('opf', models.CharField(max_length=255, verbose_name='Организационно правовая форма')),
                ('legal_entity', models.CharField(max_length=255, verbose_name='Название ЮЛ')),
                ('address', models.CharField(max_length=300, verbose_name='Юридический Адрес')),
                ('full_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='ФИО руководителя')),
                ('position', models.CharField(blank=True, max_length=255, null=True, verbose_name='Должность руководителя')),
                ('basis_authority', models.CharField(max_length=300, verbose_name='Основание полномочий')),
                ('bic', models.CharField(max_length=27, verbose_name='БИК')),
                ('bank_account', models.CharField(max_length=30, verbose_name='Расчётный счёт')),
                ('bank', models.CharField(max_length=300, verbose_name='Название банка')),
                ('kpp_juridical_person', models.CharField(blank=True, max_length=30, null=True, verbose_name='КПП организации')),
                ('kpp_bank', models.CharField(blank=True, max_length=30, null=True, verbose_name='КПП банка')),
                ('correspondent_account', models.CharField(default=None, max_length=30, verbose_name='Корсчёт')),
                ('status', models.CharField(blank=True, choices=[('ACTUAL', 'Актуальный'), ('NOT_ACTUAL', 'Не Актуальный')], max_length=15, null=True, verbose_name='Статус запроса')),
                ('updated', models.DateTimeField(blank=True, null=True, verbose_name='Дата обновления запроса')),
                ('sended_to_1c', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='LegalEntityOnboarded',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pharm_zakaz_id', models.IntegerField(null=True, unique=True, verbose_name='Идентификатор на стороне ФАРМЗАКАЗА')),
                ('inn', models.CharField(max_length=255, unique=True, verbose_name='ИНН')),
                ('contact_sign_date', models.DateTimeField(verbose_name='Дата заключения контракта')),
                ('status', models.CharField(choices=[('FORMED', 'Сформированный'), ('IN_PROCESS', 'В процессе'), ('SIGNED', 'Подписанный'), ('ERROR', 'Ошибка'), ('CANCELED', 'Отменён')], max_length=15, verbose_name='Статус запроса')),
                ('status_updated', models.DateTimeField(verbose_name='Дата обновления статуса')),
                ('ext_id', models.IntegerField(unique=True, verbose_name='Идентификатор на стороне 1С')),
                ('comment', models.CharField(max_length=255, verbose_name='Комментарий')),
                ('sended_to_pz', models.BooleanField(default=False, verbose_name='Необходимо отправить в ФАРМЗАКАЗ?')),
                ('sended_to_pz_at', models.DateTimeField(null=True, verbose_name='Последняя дата отправки в ФАРМЗАКАЗ')),
            ],
        ),
    ]
