from pathlib import Path

PROJECT_DIR = Path(__file__).parent.parent

TESTS_DIR = Path(__file__).parent
INPUT_FILES_DIR = TESTS_DIR / "input_files"
GENERATED_FILES_DIR = TESTS_DIR / "generated"
GENERATED_REPO_DIR = GENERATED_FILES_DIR / "project"

TEMPLATES_DIR = INPUT_FILES_DIR / "templates"

COOKIECUTTERS_DIR = TEMPLATES_DIR / "cookiecutters"
COOKIECUTTER_ONE_DIR = COOKIECUTTERS_DIR / "one"
COOKIECUTTER_TWO_DIR = COOKIECUTTERS_DIR / "two"
COOKIECUTTER_ONE_VERSION = "d512c7e14e83cb4bc8d4e5ae06bb357e"
COOKIECUTTER_REMOTE_URL = "https://github.com/nickderobertis/cookiecutter-simple-example"
COOKIECUTTER_REMOTE_NAME = "cookiecutter-simple-example"
COOKIECUTTER_REMOTE_VERSION_1 = "c390901c4fd599473bdb95fa4dd3d2a6eb2b34f0"
COOKIECUTTER_REMOTE_VERSION_2 = "ee8da996b5d74dfcbba5727d7c950c88173dc9ca"

CONFIGS_DIR = INPUT_FILES_DIR / "configs"
CONFIG_1_PATH = CONFIGS_DIR / "flexlate.json"
CONFIG_SUBDIR_1 = CONFIG_1_PATH / "subdir1"
CONFIG_SUBDIR_2 = CONFIGS_DIR / "subdir2"

PROJECT_CONFIGS_DIR = INPUT_FILES_DIR / "project_configs"
PROJECT_CONFIGS_ROOT_DIR = PROJECT_CONFIGS_DIR / "root"
PROJECT_CONFIGS_ROOT_CONFIG_PATH = PROJECT_CONFIGS_ROOT_DIR / "flexlate-project.json"
PROJECT_CONFIGS_PROJECT_1_PATH = PROJECT_CONFIGS_ROOT_DIR / "1"
PROJECT_CONFIGS_PROJECT_2_PATH = PROJECT_CONFIGS_ROOT_DIR / "2"
PROJECT_CONFIGS_PROJECT_1_SUBDIR = PROJECT_CONFIGS_PROJECT_1_PATH / "subdir"
PROJECT_CONFIGS_PROJECT_2_SUBDIR = PROJECT_CONFIGS_PROJECT_2_PATH / "subdir"
PROJECT_CONFIGS_1_CONFIG_PATH = PROJECT_CONFIGS_PROJECT_1_PATH / "flexlate-project.json"



if not GENERATED_FILES_DIR.exists():
    GENERATED_FILES_DIR.mkdir()