# Cursed Delta

ncurses Delta Chat client developed in Python with the urwid library.

<p align="center">
  <img src="https://github.com/adbenitez/deltachat-cursed/blob/master/screenshots/e1.png" alt="screenshot of Cursed Delta"/>
</p>

[![Latest Release](https://img.shields.io/pypi/v/deltachat-cursed.svg)](https://pypi.org/project/deltachat-cursed)
[![Supported Versions](https://img.shields.io/pypi/pyversions/deltachat-cursed.svg)](https://pypi.org/project/deltachat-cursed)
[![Downloads](https://pepy.tech/badge/deltachat-cursed)](https://pepy.tech/project/deltachat-cursed)
[![License](https://img.shields.io/pypi/l/deltachat-cursed.svg)](https://pypi.org/project/deltachat-cursed)
[![CI](https://github.com/adbenitez/deltachat-cursed/actions/workflows/python-ci.yml/badge.svg)](https://github.com/adbenitez/deltachat-cursed/actions/workflows/python-ci.yml)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

#### Features

- [X] Ability to send text messages :)
- [X] Ability to send files
- [X] Notifications
- [X] Read receipts ✓✓
- [X] Create and open encrypted accounts
- [X] Import/export keys and backups (including password-protected backups)
- [X] Emoji support and auto-completion
- [X] @Mentions support and auto-completion
- [X] Display message replies
- [X] themes/skins and keyboard shortcuts customization
- [X] Chat operations: delete, pin/unpin, mute/unmute, add/remove members, change chat name, clear chat messages
- [ ] Proxy support
- [ ] Support for contact verification and group invitations links
- [ ] Block/unblock contacts and see the list of blocked contacts
- [ ] Ability to send stickers
- [ ] Jump to quoted messages
- [ ] Record and send voice messages
- [ ] Message operations: reply, delete, open attachment/links, see info
- [ ] List contacts
- [ ] Search
- [ ] Set disappearing messages timer
- [ ] Open HTML messages
- [ ] Open webxdc documents
- [ ] View archived chats and allow to archive/Unarchive
- [ ] Multi-language support

## Installation

Install Cursed Delta with pip:

```
$ pip install -U deltachat-cursed
```

After installation the command `delta` should be available.
For more tips and info check [the user guide](https://github.com/adbenitez/deltachat-cursed/blob/master/docs/user-guide.md)


## Credits

The user interface was initially based on [ncTelegram](https://github.com/Nanoseb/ncTelegram)

Some code and ideas were taken from [scli](https://github.com/isamert/scli/)

## License

Licensed GPLv3+, see the LICENSE file for details.

Copyright © 2020-2022 Cursed Delta contributors.
