from enum import IntEnum, unique


@unique
class ItemTypeGC(IntEnum):
	"""
	An Enum referencing the different item types in CS:GO
	They are returned as def_index by the CS:GO game coordinator

	Source: https://tf2b.com/itemlist.php?gid=730
	Last updated: Jul 18, 2021

	INFO: Contains multiple entries for similar items
	"""
	DESERT_EAGLE = 1
	DUAL_BERETTAS = 2
	AUG = 8
	FIVE_SEVEN = 3
	GLOCK_18 = 4
	AK_47 = 7
	AWP = 9
	FAMAS = 10
	G3SG1 = 11
	GALIL_AR = 13
	M249 = 14
	M4A4 = 16
	MAC_10 = 17
	P90 = 19
	REPULSOR_DEVICE = 20
	MP5_SD = 23
	UMP_45 = 24
	XM1014 = 25
	PP_BIZON = 26
	MAG_7 = 27
	NEGEV = 28
	SAWED_OFF = 29
	TEC_9 = 30
	ZEUS_X27 = 31
	P2000 = 32
	MP7 = 33
	MP9 = 34
	NOVA = 35
	P250 = 36
	BALLISTIC_SHIELD = 37
	SCAR_20 = 38
	SG_553 = 39
	SSG_08 = 40
	KNIFE_CT = 41
	KNIFE_CT_2 = 42
	FLASHBANG = 43
	HIGH_EXPLOSIVE_GRENADE = 44
	SMOKE_GRENADE = 45
	MOLOTOV = 46
	DECOY_GRENADE = 47
	INCENDIARY_GRENADE = 48
	C4_EXPLOSIVE = 49
	KEVLAR_VEST = 50
	KEVLAR_AND_HELMET = 51
	HEAVY_ASSAULT_SUIT = 52
	ITEM_NVG = 54
	DEFUSE_KIT = 55
	RESCUE_KIT = 56
	MEDI_SHOT = 57
	MUSIC_KIT = 58
	KNIFE_T = 59
	M4A1_S = 60
	USP_S = 61
	TRADE_UP_CONTRACT = 62
	CZ75_AUTO = 63
	R8_REVOLVER = 64
	TACTICAL_AWARENESS_GRENADE = 68
	BARE_HANDS = 69
	BREACH_CHARGE = 70
	TABLET = 72
	KNIFE = 74
	AXE = 75
	HAMMER = 76
	WRENCH = 78
	SPECTRAL_SHIV = 80
	FIRE_BOMB = 81
	DIVERSION_DEVICE = 82
	FRAG_GRENADE = 83
	SNOWBALL = 84
	BUMP_MINE = 85
	BAYONET = 500
	CLASSIC_KNIFE = 503
	FLIP_KNIFE = 505
	GUT_KNIFE = 506
	KARAMBIT = 507
	M9_BAYONET = 508
	HUNTSMAN_KNIFE = 509
	FALCHION_KNIFE = 512
	BOWIE_KNIFE = 514
	BUTTERFLY_KNIFE = 515
	SHADOW_DAGGERS = 516
	PARACORD_KNIFE = 517
	SURVIVAL_KNIFE = 518
	URSUS_KNIFE = 519
	NAVAJA_KNIFE = 520
	NOMAD_KNIFE = 521
	STILETTO_KNIFE = 522
	TALON_KNIFE = 523
	SKELETON_KNIFE = 525
	FIVE_YEAR_VETERAN_COIN = 874
	CHAMPION_AT_DREAMHACK_2013 = 875
	FINALIST_AT_DREAMHACK_2013 = 876
	SEMIFINALIST_AT_DREAMHACK_2013 = 877
	QUARTERFINALIST_AT_DREAMHACK_2013 = 878
	CHAMPION_AT_EMS_ONE_KATOWICE_2014 = 879
	FINALIST_AT_EMS_ONE_KATOWICE_2014 = 880
	SEMIFINALIST_AT_EMS_ONE_KATOWICE_2014 = 881
	QUARTERFINALIST_AT_EMS_ONE_KATOWICE_2014 = 882
	CHAMPION_AT_ESL_ONE_COLOGNE_2014 = 883
	FINALIST_AT_ESL_ONE_COLOGNE_2014 = 884
	SEMIFINALIST_AT_ESL_ONE_COLOGNE_2014 = 885
	QUARTERFINALIST_AT_ESL_ONE_COLOGNE_2014 = 886
	BRONZE_COLOGNE_2014_PICKEM_TROPHY = 887
	SILVER_COLOGNE_2014_PICKEM_TROPHY = 888
	GOLD_COLOGNE_2014_PICKEM_TROPHY = 889
	CHAMPION_AT_DREAMHACK_WINTER_2014 = 890
	FINALIST_AT_DREAMHACK_WINTER_2014 = 891
	SEMIFINALIST_AT_DREAMHACK_WINTER_2014 = 892
	QUARTERFINALIST_AT_DREAMHACK_WINTER_2014 = 893
	BRONZE_DREAMHACK_2014_PICKEM_TROPHY = 894
	SILVER_DREAMHACK_2014_PICKEM_TROPHY = 895
	GOLD_DREAMHACK_2014_PICKEM_TROPHY = 896
	CHAMPION_AT_ESL_ONE_KATOWICE_2015 = 897
	FINALIST_AT_ESL_ONE_KATOWICE_2015 = 898
	SEMIFINALIST_AT_ESL_ONE_KATOWICE_2015 = 899
	QUARTERFINALIST_AT_ESL_ONE_KATOWICE_2015 = 900
	BRONZE_KATOWICE_2015_PICKEM_TROPHY = 901
	SILVER_KATOWICE_2015_PICKEM_TROPHY = 902
	GOLD_KATOWICE_2015_PICKEM_TROPHY = 903
	CHAMPION_AT_ESL_ONE_COLOGNE_2015 = 904
	FINALIST_AT_ESL_ONE_COLOGNE_2015 = 905
	SEMIFINALIST_AT_ESL_ONE_COLOGNE_2015 = 906
	QUARTERFINALIST_AT_ESL_ONE_COLOGNE_2015 = 907
	BRONZE_COLOGNE_2015_PICKEM_TROPHY = 908
	SILVER_COLOGNE_2015_PICKEM_TROPHY = 909
	GOLD_COLOGNE_2015_PICKEM_TROPHY = 910
	BRONZE_CLUJ_NAPOCA_2015_PICKEM_TROPHY = 911
	SILVER_CLUJ_NAPOCA_2015_PICKEM_TROPHY = 912
	GOLD_CLUJ_NAPOCA_2015_PICKEM_TROPHY = 913
	BRONZE_CLUJ_NAPOCA_2015_FANTASY_TROPHY = 914
	SILVER_CLUJ_NAPOCA_2015_FANTASY_TROPHY = 915
	GOLD_CLUJ_NAPOCA_2015_FANTASY_TROPHY = 916
	CHAMPION_AT_DREAMHACK_CLUJ_NAPOCA_2015 = 917
	FINALIST_AT_DREAMHACK_CLUJ_NAPOCA_2015 = 918
	SEMIFINALIST_AT_DREAMHACK_CLUJ_NAPOCA_2015 = 919
	QUARTERFINALIST_AT_DREAMHACK_CLUJ_NAPOCA_2015 = 920
	BRONZE_COLUMBUS_2016_PICKEM_TROPHY = 921
	SILVER_COLUMBUS_2016_PICKEM_TROPHY = 922
	GOLD_COLUMBUS_2016_PICKEM_TROPHY = 923
	BRONZE_COLUMBUS_2016_FANTASY_TROPHY = 924
	SILVER_COLUMBUS_2016_FANTASY_TROPHY = 925
	GOLD_COLUMBUS_2016_FANTASY_TROPHY = 926
	CHAMPION_AT_MLG_COLUMBUS_2016 = 927
	FINALIST_AT_MLG_COLUMBUS_2016 = 928
	SEMIFINALIST_AT_MLG_COLUMBUS_2016 = 929
	QUARTERFINALIST_AT_MLG_COLUMBUS_2016 = 930
	CHAMPION_AT_ESL_ONE_COLOGNE_2016 = 931
	FINALIST_AT_ESL_ONE_COLOGNE_2016 = 932
	SEMIFINALIST_AT_ESL_ONE_COLOGNE_2016 = 933
	QUARTERFINALIST_AT_ESL_ONE_COLOGNE_2016 = 934
	BRONZE_COLOGNE_2016_PICKEM_TROPHY = 935
	SILVER_COLOGNE_2016_PICKEM_TROPHY = 936
	GOLD_COLOGNE_2016_PICKEM_TROPHY = 937
	BRONZE_COLOGNE_2016_FANTASY_TROPHY = 938
	SILVER_COLOGNE_2016_FANTASY_TROPHY = 939
	GOLD_COLOGNE_2016_FANTASY_TROPHY = 940
	CHAMPION_AT_ELEAGUE_ATLANTA_2017 = 941
	FINALIST_AT_ELEAGUE_ATLANTA_2017 = 942
	SEMIFINALIST_AT_ELEAGUE_ATLANTA_2017 = 943
	QUARTERFINALIST_AT_ELEAGUE_ATLANTA_2017 = 944
	BRONZE_ATLANTA_2017_PICKEM_TROPHY = 945
	SILVER_ATLANTA_2017_PICKEM_TROPHY = 946
	GOLD_ATLANTA_2017_PICKEM_TROPHY = 947
	CHAMPION_AT_PGL_KRAKOW_2017 = 948
	FINALIST_AT_PGL_KRAKOW_2017 = 949
	SEMIFINALIST_AT_PGL_KRAKOW_2017 = 950
	QUARTERFINALIST_AT_PGL_KRAKOW_2017 = 951
	BRONZE_KRAKOW_2017_PICKEM_TROPHY = 952
	SILVER_KRAKOW_2017_PICKEM_TROPHY = 953
	GOLD_KRAKOW_2017_PICKEM_TROPHY = 954
	CHAMPION_AT_ELEAGUE_BOSTON_2018 = 955
	FINALIST_AT_ELEAGUE_BOSTON_2018 = 956
	SEMIFINALIST_AT_ELEAGUE_BOSTON_2018 = 957
	QUARTERFINALIST_AT_ELEAGUE_BOSTON_2018 = 958
	BRONZE_BOSTON_2018_PICKEM_TROPHY = 959
	SILVER_BOSTON_2018_PICKEM_TROPHY = 960
	GOLD_BOSTON_2018_PICKEM_TROPHY = 961
	CHAMPION_AT_FACEIT_LONDON_2018 = 962
	FINALIST_AT_FACEIT_LONDON_2018 = 963
	SEMIFINALIST_AT_FACEIT_LONDON_2018 = 964
	QUARTERFINALIST_AT_FACEIT_LONDON_2018 = 965
	BRONZE_LONDON_2018_PICKEM_TROPHY = 966
	SILVER_LONDON_2018_PICKEM_TROPHY = 967
	GOLD_LONDON_2018_PICKEM_TROPHY = 968
	TEN_YEAR_VETERAN_COIN = 969
	LOYALTY_BADGE = 970
	CHAMPION_AT_IEM_KATOWICE_2019 = 971
	FINALIST_AT_IEM_KATOWICE_2019 = 972
	SEMIFINALIST_AT_IEM_KATOWICE_2019 = 973
	QUARTERFINALIST_AT_IEM_KATOWICE_2019 = 974
	CHAMPION_AT_STARLADDER_BERLIN_2019 = 975
	FINALIST_AT_STARLADDER_BERLIN_2019 = 976
	SEMIFINALIST_AT_STARLADDER_BERLIN_2019 = 977
	QUARTERFINALIST_AT_STARLADDER_BERLIN_2019 = 978
	OPERATION_PAYBACK_PASS = 1000
	OPERATION_PAYBACK_CHALLENGE_COIN = 1001
	SILVER_OPERATION_PAYBACK_COIN = 1002
	GOLD_OPERATION_PAYBACK_COIN = 1003
	MUSEUM_MAP_COIN = 1004
	DOWNTOWN_MAP_COIN = 1005
	THUNDER_MAP_COIN = 1006
	FAVELA_MAP_COIN = 1007
	MOTEL_MAP_COIN = 1008
	SEASIDE_MAP_COIN = 1009
	LIBRARY_MAP_COIN = 1010
	OPERATION_BRAVO_PASS = 1012
	OPERATION_BRAVO_CHALLENGE_COIN = 1013
	SILVER_OPERATION_BRAVO_COIN = 1014
	GOLD_OPERATION_BRAVO_COIN = 1015
	AGENCY_MAP_COIN = 1016
	ALI_MAP_COIN = 1017
	CACHE_MAP_COIN = 1018
	CHINATOWN_MAP_COIN = 1019
	GWALIOR_MAP_COIN = 1020
	RUINS_MAP_COIN = 1021
	SIEGE_MAP_COIN = 1022
	OPERATION_PHOENIX_PASS = 1023
	OPERATION_PHOENIX_CHALLENGE_COIN = 1024
	SILVER_OPERATION_PHOENIX_COIN = 1025
	GOLD_OPERATION_PHOENIX_COIN = 1026
	OPERATION_BREAKOUT_ALL_ACCESS_PASS = 1027
	OPERATION_BREAKOUT_CHALLENGE_COIN = 1028
	SILVER_OPERATION_BREAKOUT_COIN = 1029
	GOLD_OPERATION_BREAKOUT_COIN = 1030
	CASTLE_MAP_COIN = 1031
	BLACK_GOLD_MAP_COIN = 1032
	RUSH_MAP_COIN = 1033
	MIST_MAP_COIN = 1034
	INSERTION_MAP_COIN = 1035
	OVERGROWN_MAP_COIN = 1036
	MARQUIS_MAP_COIN = 1037
	WORKOUT_MAP_COIN = 1038
	BACKALLEY_MAP_COIN = 1039
	SEASON_MAP_COIN = 1040
	BAZAAR_MAP_COIN = 1041
	FACADE_MAP_COIN = 1042
	LOG_MAP_COIN = 1043
	RAILS_MAP_COIN = 1044
	RESORT_MAP_COIN = 1045
	ZOO_MAP_COIN = 1046
	SANTORINI_MAP_COIN = 1047
	COAST_MAP_COIN = 1048
	MIKLA_MAP_COIN = 1049
	ROYAL_MAP_COIN = 1050
	EMPIRE_MAP_COIN = 1051
	TULIP_MAP_COIN = 1052
	CRUISE_MAP_COIN = 1053
	SUBZERO_MAP_COIN = 1054
	BIOME_MAP_COIN = 1055
	ABBEY_MAP_COIN = 1056
	RUBY_MAP_COIN = 1057
	BREACH_MAP_COIN = 1058
	STUDIO_MAP_COIN = 1059
	JUNGLE_MAP_COIN = 1060
	ANUBIS_MAP_COIN = 1061
	CHLORINE_MAP_COIN = 1062
	MUTINY_MAP_COIN = 1063
	SWAMP_MAP_COIN = 1064
	FROSTBITE_MAP_COIN = 1065
	ENGAGE_MAP_COIN = 1066
	APOLLO_MAP_COIN = 1067
	GUARD_MAP_COIN = 1068
	ELYSION_MAP_COIN = 1069
	NAME_TAG = 1200
	STORAGE_UNIT = 1201
	CSGO_CASE_KEY = 1203
	ESPORTS_KEY = 1204
	STICKER = 1209
	GIFT_PACKAGE = 1210
	PALLET_OF_PRESENTS = 1211
	CSGO_CAPSULE_KEY = 1212
	WINTER_OFFENSIVE_CASE_KEY = 1214
	AUDIENCE_PARTICIPATION_PARCEL = 1215
	OPERATION_PHOENIX_CASE_KEY = 1303
	COMMUNITY_STICKER_CAPSULE_1_KEY = 1304
	HUNTSMAN_CASE_KEY = 1305
	MISSION = 1306
	HUNTSMAN_CASE_KEY_2 = 1307
	COMMUNITY_STICKER_CAPSULE_1_KEY_2 = 1308
	OPERATION_BREAKOUT_CASE_KEY = 1309
	OPERATION_BREAKOUT_CASE_KEY_2 = 1310
	OPERATION_BREAKOUT_CASE_KEY_3 = 1311
	OPERATION_BREAKOUT_CASE_KEY_4 = 1313
	MUSIC_KIT_2 = 1314
	OPERATION_VANGUARD_ACCESS_PASS = 1315
	OPERATION_VANGUARD_CHALLENGE_COIN = 1316
	SILVER_OPERATION_VANGUARD_COIN = 1317
	GOLD_OPERATION_VANGUARD_COIN = 1318
	CAMPAIGN_MAGHREB = 1320
	CAMPAIGN_EURASIA = 1321
	OPERATION_VANGUARD_CASE_KEY = 1322
	CHROMA_CASE_KEY = 1323
	STATTRAK_SWAP_TOOL = 1324
	CHROMA_2_CASE_KEY = 1325
	OPERATION_BLOODHOUND_ACCESS_PASS = 1326
	OPERATION_BLOODHOUND_CHALLENGE_COIN = 1327
	SILVER_OPERATION_BLOODHOUND_COIN = 1328
	GOLD_OPERATION_BLOODHOUND_COIN = 1329
	FALCHION_CASE_KEY = 1330
	SERVICE_MEDAL_2015_BLUE = 1331
	SERVICE_MEDAL_2015_PURPLE  = 1332
	SHADOW_CASE_KEY = 1333
	REVOLVER_CASE_KEY = 1334
	OPERATION_WILDFIRE_ACCESS_PASS = 1335
	OPERATION_WILDFIRE_CHALLENGE_COIN = 1336
	SILVER_OPERATION_WILDFIRE_COIN = 1337
	GOLD_OPERATION_WILDFIRE_COIN = 1338
	SERVICE_MEDAL_2016_GREY = 1339
	SERVICE_MEDAL_2016_LIGHT_BLUE = 1340
	SERVICE_MEDAL_2016_BLUE = 1341
	SERVICE_MEDAL_2016_PURPLE = 1342
	SERVICE_MEDAL_2016_PINK= 1343
	SERVICE_MEDAL_2016_RED = 1344
	CHROMA_3_CASE_KEY = 1347
	SEALED_GRAFFITI = 1348
	GRAFFITI = 1349
	GAMMA_CASE_KEY = 1350
	GAMMA_2_CASE_KEY = 1351
	OPERATION_HYDRA_ACCESS_PASS = 1352
	COUNTER_STRIKE_GLOBAL_OFFENSIVE_GAME_LICENSE = 1353
	GLOVE_CASE_KEY = 1356
	SERVICE_MEDAL_2017_GREY = 1357
	SERVICE_MEDAL_2017_LIGHT_BLUE = 1358
	SERVICE_MEDAL_2017_BLUE = 1359
	SERVICE_MEDAL_2017_PURPLE = 1360
	SERVICE_MEDAL_2017_PINK = 1361
	SERVICE_MEDAL_2017_RED = 1362
	SERVICE_MEDAL_2017_BLACK = 1363
	SPECTRUM_CASE_KEY = 1364
	OPERATION_HYDRA_CASE_KEY = 1365
	SPECTRUM_2_CASE_KEY = 1366
	SERVICE_MEDAL_2018_GREY = 1367
	SERVICE_MEDAL_2018_GREEN = 1368
	SERVICE_MEDAL_2018_BLUE = 1369
	SERVICE_MEDAL_2018_PURPLE = 1370
	SERVICE_MEDAL_2018_PINK = 1371
	SERVICE_MEDAL_2018_RED = 1372
	CLUTCH_CASE_KEY = 1373
	HORIZON_CASE_KEY = 1374
	DANGER_ZONE_CASE_KEY = 1375
	SERVICE_MEDAL_2019_GREY = 1376
	SERVICE_MEDAL_2019_GREEN = 1377
	SERVICE_MEDAL_2019_BLUE = 1378
	SERVICE_MEDAL_2019_PURPLE = 1379
	SERVICE_MEDAL_2019_PINK = 1380
	SERVICE_MEDAL_2019_RED = 1381
	PRISMA_CASE_KEY = 1383
	SHATTERED_WEB_CASE_KEY = 1384
	CS20_CASE_KEY = 1385
	PRISMA_2_CASE_KEY = 1386
	FRACTURE_CASE_KEY = 1387
	OPERATION_BROKEN_FANG_CASE_KEY = 1388
	CSGO_WEAPON_CASE = 4001
	ESPORTS_2013_CASE = 4002
	OPERATION_BRAVO_CASE = 4003
	CSGO_WEAPON_CASE_2 = 4004
	ESPORTS_2013_WINTER_CASE = 4005
	DREAMHACK_2013_SOUVENIR_PACKAGE = 4006
	STICKER_CAPSULE = 4007
	WINTER_OFFENSIVE_WEAPON_CASE = 4009
	CSGO_WEAPON_CASE_3 = 4010
	OPERATION_PHOENIX_WEAPON_CASE = 4011
	STICKER_CAPSULE_2 = 4012
	EMS_ONE_2014_SOUVENIR_PACKAGE = 4013
	EMS_KATOWICE_2014_CHALLENGERS = 4014
	EMS_KATOWICE_2014_LEGENDS = 4015
	COMMUNITY_STICKER_CAPSULE_1 = 4016
	HUNTSMAN_WEAPON_CASE = 4017
	OPERATION_BREAKOUT_WEAPON_CASE = 4018
	ESPORTS_2014_SUMMER_CASE = 4019
	ESL_ONE_COLOGNE_2014_LEGENDS = 4020
	ESL_ONE_COLOGNE_2014_CHALLENGERS = 4021
	ESL_ONE_COLOGNE_2014_DUST_II_SOUVENIR_PACKAGE = 4022
	ESL_ONE_COLOGNE_2014_INFERNO_SOUVENIR_PACKAGE = 4023
	ESL_ONE_COLOGNE_2014_MIRAGE_SOUVENIR_PACKAGE = 4024
	ESL_ONE_COLOGNE_2014_NUKE_SOUVENIR_PACKAGE = 4025
	ESL_ONE_COLOGNE_2014_CACHE_SOUVENIR_PACKAGE = 4026
	ESL_ONE_COLOGNE_2014_COBBLESTONE_SOUVENIR_PACKAGE = 4027
	ESL_ONE_COLOGNE_2014_OVERPASS_SOUVENIR_PACKAGE = 4028
	OPERATION_VANGUARD_WEAPON_CASE = 4029
	DREAMHACK_2014_LEGENDS_HOLO_FOIL = 4030
	DREAMHACK_2014_DUST_II_SOUVENIR_PACKAGE = 4031
	DREAMHACK_2014_INFERNO_SOUVENIR_PACKAGE = 4032
	DREAMHACK_2014_MIRAGE_SOUVENIR_PACKAGE = 4033
	DREAMHACK_2014_NUKE_SOUVENIR_PACKAGE = 4034
	DREAMHACK_2014_CACHE_SOUVENIR_PACKAGE = 4035
	DREAMHACK_2014_COBBLESTONE_SOUVENIR_PACKAGE = 4036
	DREAMHACK_2014_OVERPASS_SOUVENIR_PACKAGE = 4037
	FNATIC_DREAMHACK_2014 = 4038
	CLOUD9_DREAMHACK_2014 = 4039
	NINJAS_IN_PYJAMAS_DREAMHACK_2014 = 4041
	VIRTUSPRO_DREAMHACK_2014 = 4042
	NATUS_VINCERE_DREAMHACK_2014 = 4043
	TEAM_DIGNITAS_DREAMHACK_2014 = 4045
	BRAVADO_GAMING_DREAMHACK_2014 = 4046
	ESC_GAMING_DREAMHACK_2014 = 4047
	HELLRAISERS_DREAMHACK_2014 = 4048
	MYXMG_DREAMHACK_2014 = 4049
	IBUYPOWER_DREAMHACK_2014 = 4050
	TEAM_LDLC_DREAMHACK_2014 = 4051
	PENTA_SPORTS_DREAMHACK_2014 = 4052
	PLANETKEY_DYNAMICS_DREAMHACK_2014 = 4053
	DREAMHACK_WINTER_2014 = 4054
	STICKER_3DMAX_DREAMHACK_2014 = 4055
	COPENHAGEN_WOLVES_DREAMHACK_2014 = 4056
	DAT_TEAM_DREAMHACK_2014 = 4057
	LONDON_CONSPIRACY_DREAMHACK_2014 = 4058
	MOUSESPORTS_DREAMHACK_2014 = 4059
	FLIPSID3_TACTICS_DREAMHACK_2014 = 4060
	CHROMA_CASE = 4061
	STICKER_3DMAX_KATOWICE_2015 = 4062
	CLOUD9_G2A_KATOWICE_2015 = 4063
	COUNTER_LOGIC_GAMING_KATOWICE_2015 = 4064
	FLIPSID3_TACTICS_KATOWICE_2015 = 4065
	FNATIC_KATOWICE_2015 = 4066
	HELLRAISERS_KATOWICE_2015 = 4067
	KEYD_STARS_KATOWICE_2015 = 4068
	LGB_ESPORTS_KATOWICE_2015 = 4069
	NATUS_VINCERE_KATOWICE_2015 = 4070
	NINJAS_IN_PYJAMAS__KATOWICE_2015 = 4071
	PENTA_SPORTS__KATOWICE_2015 = 4072
	TEAM_ENVYUS_KATOWICE_2015 = 4073
	TSM_KINGUIN_KATOWICE_2015 = 4074
	TITAN_KATOWICE_2015 = 4075
	VIRTUSPRO_KATOWICE_2015 = 4076
	VOX_EMINOR__KATOWICE_2015 = 4077
	ESL_ONE_KATOWICE_2015 = 4078
	ESL_ONE_KATOWICE_2015_DUST_II_SOUVENIR_PACKAGE = 4079
	ESL_ONE_KATOWICE_2015_INFERNO_SOUVENIR_PACKAGE = 4080
	ESL_ONE_KATOWICE_2015_MIRAGE_SOUVENIR_PACKAGE = 4081
	ESL_ONE_KATOWICE_2015_NUKE_SOUVENIR_PACKAGE = 4082
	ESL_ONE_KATOWICE_2015_CACHE_SOUVENIR_PACKAGE = 4083
	ESL_ONE_KATOWICE_2015_COBBLESTONE_SOUVENIR_PACKAGE = 4084
	ESL_ONE_KATOWICE_2015_OVERPASS_SOUVENIR_PACKAGE = 4085
	ESL_ONE_KATOWICE_2015_LEGENDS_HOLO_FOIL = 4086
	ESL_ONE_KATOWICE_2015_CHALLENGERS_HOLO_FOIL = 4087
	STATTRAK_SWAP_TOOL_TWO_PACK = 4088
	CHROMA_2_CASE = 4089
	ENFU_STICKER_CAPSULE = 4090
	FALCHION_CASE = 4091
	FNATIC_COLOGNE_2015 = 4092
	VIRTUSPRO_COLOGNE_2015 = 4093
	MOUSESPORTS_COLOGNE_2015 = 4094
	NATUS_VINCERE_COLOGNE_2015 = 4095
	RENEGADES_COLOGNE_2015 = 4096
	TEAM_KINGUIN_COLOGNE_2015 = 4097
	TEAM_EBETTLE_COLOGNE_2015 = 4098
	CLOUD9_G2A_COLOGNE_2015 = 4099
	NINJAS_IN_PYJAMAS_COLOGNE_2015 = 4100
	TEAM_ENVYUS_COLOGNE_2015 = 4101
	LUMINOSITY_GAMING_COLOGNE_2015 = 4102
	TEAM_SOLOMID_COLOGNE_2015 = 4103
	TEAM_IMMUNITY_COLOGNE_2015 = 4104
	FLIPSID3_TACTICS_COLOGNE_2015 = 4105
	TITAN_COLOGNE_2015 = 4106
	COUNTER_LOGIC_GAMING_COLOGNE_2015 = 4107
	ESL_COLOGNE_2015 = 4108
	ESL_ONE_COLOGNE_2015_LEGENDS_FOIL = 4109
	ESL_ONE_COLOGNE_2015_CHALLENGERS_FOIL = 4110
	AUTOGRAPH_CAPSULE_GROUP_A_FOIL_COLOGNE_2015 = 4111
	AUTOGRAPH_CAPSULE_GROUP_B_FOIL_COLOGNE_2015 = 4112
	AUTOGRAPH_CAPSULE_GROUP_C_FOIL_COLOGNE_2015 = 4113
	AUTOGRAPH_CAPSULE_GROUP_D_FOIL_COLOGNE_2015 = 4114
	AUTOGRAPH_CAPSULE_FNATIC_COLOGNE_2015 = 4115
	AUTOGRAPH_CAPSULE_LUMINOSITY_GAMING_COLOGNE_2015 = 4116
	AUTOGRAPH_CAPSULE_NATUS_VINCERE_COLOGNE_2015 = 4117
	AUTOGRAPH_CAPSULE_NINJAS_IN_PYJAMAS_COLOGNE_2015 = 4118
	AUTOGRAPH_CAPSULE_TEAM_ENVYUS_COLOGNE_2015 = 4119
	AUTOGRAPH_CAPSULE_TITAN_COLOGNE_2015 = 4120
	AUTOGRAPH_CAPSULE_TEAM_SOLOMID_COLOGNE_2015 = 4121
	AUTOGRAPH_CAPSULE_VIRTUSPRO_COLOGNE_2015 = 4122
	AUTOGRAPH_CAPSULE_MOUSESPORTS_COLOGNE_2015 = 4123
	AUTOGRAPH_CAPSULE_RENEGADES_COLOGNE_2015 = 4124
	AUTOGRAPH_CAPSULE_TEAM_IMMUNITY_COLOGNE_2015 = 4125
	AUTOGRAPH_CAPSULE_TEAM_EBETTLE_COLOGNE_2015 = 4126
	AUTOGRAPH_CAPSULE_TEAM_KINGUIN_COLOGNE_2015 = 4127
	AUTOGRAPH_CAPSULE_FLIPSID3_TACTICS_COLOGNE_2015 = 4128
	AUTOGRAPH_CAPSULE_COUNTER_LOGIC_GAMING_COLOGNE_2015 = 4129
	AUTOGRAPH_CAPSULE_CLOUD9_G2A_COLOGNE_2015 = 4130
	ESL_ONE_COLOGNE_2015_DUST_II_SOUVENIR_PACKAGE = 4131
	ESL_ONE_COLOGNE_2015_MIRAGE_SOUVENIR_PACKAGE = 4132
	ESL_ONE_COLOGNE_2015_INFERNO_SOUVENIR_PACKAGE = 4133
	ESL_ONE_COLOGNE_2015_COBBLESTONE_SOUVENIR_PACKAGE = 4134
	ESL_ONE_COLOGNE_2015_OVERPASS_SOUVENIR_PACKAGE = 4135
	ESL_ONE_COLOGNE_2015_CACHE_SOUVENIR_PACKAGE = 4136
	ESL_ONE_COLOGNE_2015_TRAIN_SOUVENIR_PACKAGE = 4137
	SHADOW_CASE = 4138
	NINJAS_IN_PYJAMAS_CLUJ_NAPOCA_2015 = 4139
	TEAM_DIGNITAS_CLUJ_NAPOCA_2015 = 4140
	COUNTER_LOGIC_GAMING_CLUJ_NAPOCA_2015 = 4141
	VEXED_GAMING_CLUJ_NAPOCA_2015 = 4142
	FLIPSID3_TACTICS_CLUJ_NAPOCA_2015 = 4143
	TEAM_LIQUID_CLUJ_NAPOCA_2015 = 4144
	MOUSESPORTS_CLUJ_NAPOCA_2015 = 4145
	NATUS_VINCERE_CLUJ_NAPOCA_2015 = 4146
	VIRTUSPRO_CLUJ_NAPOCA_2015 = 4147
	CLOUD9_CLUJ_NAPOCA_2015 = 4148
	G2_ESPORTS_CLUJ_NAPOCA_2015 = 4149
	TITAN_CLUJ_NAPOCA_2015 = 4150
	TEAM_SOLOMID_CLUJ_NAPOCA_2015 = 4151
	TEAM_ENVYUS_CLUJ_NAPOCA_2015 = 4152
	FNATIC_CLUJ_NAPOCA_2015 = 4153
	LUMINOSITY_GAMING_CLUJ_NAPOCA_2015 = 4154
	DREAMHACK_CLUJ_NAPOCA_2015 = 4155
	DREAMHACK_CLUJ_NAPOCA_2015_LEGENDS_FOIL = 4156
	DREAMHACK_CLUJ_NAPOCA_2015_CHALLENGERS_FOIL = 4157
	AUTOGRAPH_CAPSULE_CHALLENGERS_FOIL_CLUJ_NAPOCA_2015 = 4158
	AUTOGRAPH_CAPSULE_LEGENDS_FOIL_CLUJ_NAPOCA_2015 = 4159
	AUTOGRAPH_CAPSULE_NINJAS_IN_PYJAMAS_CLUJ_NAPOCA_2015 = 4160
	AUTOGRAPH_CAPSULE_TEAM_DIGNITAS_CLUJ_NAPOCA_2015 = 4161
	AUTOGRAPH_CAPSULE_COUNTER_LOGIC_GAMING_CLUJ_NAPOCA_2015 = 4162
	AUTOGRAPH_CAPSULE_VEXED_GAMING_CLUJ_NAPOCA_2015 = 4163
	AUTOGRAPH_CAPSULE_FLIPSID3_TACTICS_CLUJ_NAPOCA_2015 = 4164
	AUTOGRAPH_CAPSULE_TEAM_LIQUID_CLUJ_NAPOCA_2015 = 4165
	AUTOGRAPH_CAPSULE_MOUSESPORTS_CLUJ_NAPOCA_2015 = 4166
	AUTOGRAPH_CAPSULE_NATUS_VINCERE_CLUJ_NAPOCA_2015 = 4167
	AUTOGRAPH_CAPSULE_VIRTUSPRO_CLUJ_NAPOCA_2015 = 4168
	AUTOGRAPH_CAPSULE_CLOUD9_CLUJ_NAPOCA_2015 = 4169
	AUTOGRAPH_CAPSULE_G2_ESPORTS_CLUJ_NAPOCA_2015 = 4170
	AUTOGRAPH_CAPSULE_TITAN_CLUJ_NAPOCA_2015 = 4171
	AUTOGRAPH_CAPSULE_TEAM_SOLOMID_CLUJ_NAPOCA_2015 = 4172
	AUTOGRAPH_CAPSULE_TEAM_ENVYUS_CLUJ_NAPOCA_2015 = 4173
	AUTOGRAPH_CAPSULE_FNATIC_CLUJ_NAPOCA_2015 = 4174
	AUTOGRAPH_CAPSULE_LUMINOSITY_GAMING_CLUJ_NAPOCA_2015 = 4175
	DREAMHACK_CLUJ_NAPOCA_2015_DUST_II_SOUVENIR_PACKAGE = 4176
	DREAMHACK_CLUJ_NAPOCA_2015_MIRAGE_SOUVENIR_PACKAGE = 4177
	DREAMHACK_CLUJ_NAPOCA_2015_INFERNO_SOUVENIR_PACKAGE = 4178
	DREAMHACK_CLUJ_NAPOCA_2015_COBBLESTONE_SOUVENIR_PACKAGE = 4179
	DREAMHACK_CLUJ_NAPOCA_2015_OVERPASS_SOUVENIR_PACKAGE = 4180
	DREAMHACK_CLUJ_NAPOCA_2015_CACHE_SOUVENIR_PACKAGE = 4181
	DREAMHACK_CLUJ_NAPOCA_2015_TRAIN_SOUVENIR_PACKAGE = 4182
	PINUPS_CAPSULE = 4183
	SLID3_CAPSULE = 4184
	TEAM_ROLES_CAPSULE = 4185
	REVOLVER_CASE = 4186
	OPERATION_WILDFIRE_CASE = 4187
	NINJAS_IN_PYJAMAS_MLG_COLUMBUS_2016 = 4188
	SPLYCE_MLG_COLUMBUS_2016 = 4189
	COUNTER_LOGIC_GAMING_MLG_COLUMBUS_2016 = 4190
	GAMBIT_GAMING_MLG_COLUMBUS_2016 = 4191
	FLIPSID3_TACTICS_MLG_COLUMBUS_2016 = 4192
	TEAM_LIQUID_MLG_COLUMBUS_2016 = 4193
	MOUSESPORTS_MLG_COLUMBUS_2016 = 4194
	NATUS_VINCERE_MLG_COLUMBUS_2016 = 4195
	VIRTUSPRO_MLG_COLUMBUS_2016 = 4196
	CLOUD9_MLG_COLUMBUS_2016 = 4197
	G2_ESPORTS_MLG_COLUMBUS_2016 = 4198
	FAZE_CLAN_MLG_COLUMBUS_2016 = 4199
	ASTRALIS_MLG_COLUMBUS_2016 = 4200
	TEAM_ENVYUS_MLG_COLUMBUS_2016 = 4201
	FNATIC_MLG_COLUMBUS_2016 = 4202
	LUMINOSITY_GAMING_MLG_COLUMBUS_2016 = 4203
	MLG_MLG_COLUMBUS_2016 = 4204
	MLG_COLUMBUS_2016_LEGENDS_HOLO_FOIL = 4205
	MLG_COLUMBUS_2016_CHALLENGERS_HOLO_FOIL = 4206
	AUTOGRAPH_CAPSULE_CHALLENGERS_FOIL_MLG_COLUMBUS_2016 = 4207
	AUTOGRAPH_CAPSULE_LEGENDS_FOIL_MLG_COLUMBUS_2016 = 4208
	AUTOGRAPH_CAPSULE_NINJAS_IN_PYJAMAS_MLG_COLUMBUS_2016 = 4209
	AUTOGRAPH_CAPSULE_SPLYCE_MLG_COLUMBUS_2016 = 4210
	AUTOGRAPH_CAPSULE_COUNTER_LOGIC_GAMING_MLG_COLUMBUS_2016 = 4211
	AUTOGRAPH_CAPSULE_GAMBIT_GAMING_MLG_COLUMBUS_2016 = 4212
	AUTOGRAPH_CAPSULE_FLIPSID3_TACTICS_MLG_COLUMBUS_2016 = 4213
	AUTOGRAPH_CAPSULE_TEAM_LIQUID_MLG_COLUMBUS_2016 = 4214
	AUTOGRAPH_CAPSULE_MOUSESPORTS_MLG_COLUMBUS_2016 = 4215
	AUTOGRAPH_CAPSULE_NATUS_VINCERE_MLG_COLUMBUS_2016 = 4216
	AUTOGRAPH_CAPSULE_VIRTUSPRO_MLG_COLUMBUS_2016 = 4217
	AUTOGRAPH_CAPSULE_CLOUD9_MLG_COLUMBUS_2016 = 4218
	AUTOGRAPH_CAPSULE_G2_ESPORTS_MLG_COLUMBUS_2016 = 4219
	AUTOGRAPH_CAPSULE_FAZE_CLAN_MLG_COLUMBUS_2016 = 4220
	AUTOGRAPH_CAPSULE_ASTRALIS_MLG_COLUMBUS_2016 = 4221
	AUTOGRAPH_CAPSULE_TEAM_ENVYUS_MLG_COLUMBUS_2016 = 4222
	AUTOGRAPH_CAPSULE_FNATIC_MLG_COLUMBUS_2016 = 4223
	AUTOGRAPH_CAPSULE_LUMINOSITY_GAMING_MLG_COLUMBUS_2016 = 4224
	MLG_COLUMBUS_2016_DUST_II_SOUVENIR_PACKAGE = 4225
	MLG_COLUMBUS_2016_MIRAGE_SOUVENIR_PACKAGE = 4226
	MLG_COLUMBUS_2016_INFERNO_SOUVENIR_PACKAGE = 4227
	MLG_COLUMBUS_2016_COBBLESTONE_SOUVENIR_PACKAGE = 4228
	MLG_COLUMBUS_2016_OVERPASS_SOUVENIR_PACKAGE = 4229
	MLG_COLUMBUS_2016_CACHE_SOUVENIR_PACKAGE = 4230
	MLG_COLUMBUS_2016_TRAIN_SOUVENIR_PACKAGE = 4231
	MLG_COLUMBUS_2016_NUKE_SOUVENIR_PACKAGE = 4232
	CHROMA_3_CASE = 4233
	COMMUNITY_GRAFFITI_BOX_1 = 4234
	COLLECTIBLE_PINS_CAPSULE_SERIES_1 = 4235
	GAMMA_CASE = 4236
	NINJAS_IN_PYJAMAS_COLOGNE_2016 = 4237
	OPTIC_GAMING_COLOGNE_2016 = 4238
	COUNTER_LOGIC_GAMING_COLOGNE_2016 = 4239
	GAMBIT_GAMING_COLOGNE_2016 = 4240
	FLIPSID3_TACTICS_COLOGNE_2016 = 4241
	TEAM_LIQUID_COLOGNE_2016 = 4242
	MOUSESPORTS_COLOGNE_2016 = 4243
	NATUS_VINCERE_COLOGNE_2016 = 4244
	VIRTUSPRO_COLOGNE_2016 = 4245
	SK_GAMING_COLOGNE_2016 = 4246
	G2_ESPORTS_COLOGNE_2016 = 4247
	FAZE_CLAN_COLOGNE_2016 = 4248
	ASTRALIS_COLOGNE_2016 = 4249
	TEAM_ENVYUS_COLOGNE_2016 = 4250
	FNATIC_COLOGNE_2016 = 4251
	TEAM_DIGNITAS_COLOGNE_2016 = 4252
	ESL_COLOGNE_2016 = 4253
	COLOGNE_2016_LEGENDS_HOLO_FOIL = 4254
	COLOGNE_2016_CHALLENGERS_HOLO_FOIL = 4255
	AUTOGRAPH_CAPSULE_CHALLENGERS_FOIL_COLOGNE_2016 = 4256
	AUTOGRAPH_CAPSULE_LEGENDS_FOIL_COLOGNE_2016 = 4257
	AUTOGRAPH_CAPSULE_NINJAS_IN_PYJAMAS_COLOGNE_2016 = 4258
	AUTOGRAPH_CAPSULE_OPTIC_GAMING_COLOGNE_2016 = 4259
	AUTOGRAPH_CAPSULE_COUNTER_LOGIC_GAMING_COLOGNE_2016 = 4260
	AUTOGRAPH_CAPSULE_GAMBIT_GAMING_COLOGNE_2016 = 4261
	AUTOGRAPH_CAPSULE_FLIPSID3_TACTICS_COLOGNE_2016 = 4262
	AUTOGRAPH_CAPSULE_TEAM_LIQUID_COLOGNE_2016 = 4263
	AUTOGRAPH_CAPSULE_MOUSESPORTS_COLOGNE_2016 = 4264
	AUTOGRAPH_CAPSULE_NATUS_VINCERE_COLOGNE_2016 = 4265
	AUTOGRAPH_CAPSULE_VIRTUSPRO_COLOGNE_2016 = 4266
	AUTOGRAPH_CAPSULE_SK_GAMING_COLOGNE_2016 = 4267
	AUTOGRAPH_CAPSULE_G2_ESPORTS_COLOGNE_2016 = 4268
	AUTOGRAPH_CAPSULE_FAZE_CLAN_COLOGNE_2016 = 4269
	AUTOGRAPH_CAPSULE_ASTRALIS_COLOGNE_2016 = 4270
	AUTOGRAPH_CAPSULE_TEAM_ENVYUS_COLOGNE_2016 = 4271
	AUTOGRAPH_CAPSULE_FNATIC_COLOGNE_2016 = 4272
	AUTOGRAPH_CAPSULE_TEAM_DIGNITAS_COLOGNE_2016 = 4273
	COLOGNE_2016_DUST_II_SOUVENIR_PACKAGE = 4274
	COLOGNE_2016_MIRAGE_SOUVENIR_PACKAGE = 4275
	COLOGNE_2016_COBBLESTONE_SOUVENIR_PACKAGE = 4276
	COLOGNE_2016_OVERPASS_SOUVENIR_PACKAGE = 4277
	COLOGNE_2016_CACHE_SOUVENIR_PACKAGE = 4278
	COLOGNE_2016_TRAIN_SOUVENIR_PACKAGE = 4279
	COLOGNE_2016_NUKE_SOUVENIR_PACKAGE = 4280
	GAMMA_2_CASE = 4281
	SUGARFACE_CAPSULE = 4282
	BESTIARY_CAPSULE = 4283
	COLLECTIBLE_PINS_CAPSULE_SERIES_2 = 4284
	CSGO_GRAFFITI_BOX = 4285
	PERFECT_WORLD_GRAFFITI_BOX = 4286
	STATTRAK_RADICALS_BOX = 4287
	GLOVE_CASE = 4288
	STICKER_ASTRALIS_ATLANTA_2017 = 4289
	STICKER_TEAM_ENVYUS_ATLANTA_2017 = 4290
	STICKER_FAZE_CLAN_ATLANTA_2017 = 4291
	STICKER_FLIPSID3_TACTICS_ATLANTA_2017 = 4292
	STICKER_FNATIC_ATLANTA_2017 = 4293
	STICKER_G2_ESPORTS_ATLANTA_2017 = 4294
	STICKER_GAMBIT_GAMING_ATLANTA_2017 = 4295
	STICKER_GODSENT_ATLANTA_2017 = 4296
	STICKER_HELLRAISERS_ATLANTA_2017 = 4297
	STICKER_MOUSESPORTS_ATLANTA_2017 = 4298
	STICKER_NATUS_VINCERE_ATLANTA_2017 = 4299
	STICKER_NORTH_ATLANTA_2017 = 4300
	STICKER_OPTIC_GAMING_ATLANTA_2017 = 4301
	STICKER_SK_GAMING_ATLANTA_2017 = 4302
	STICKER_TEAM_LIQUID_ATLANTA_2017 = 4303
	STICKER_VIRTUSPRO_ATLANTA_2017 = 4304
	STICKER_ELEAGUE_ATLANTA_2017 = 4305
	SEALED_GRAFFITI_ASTRALIS_ATLANTA_2017 = 4306
	SEALED_GRAFFITI_TEAM_ENVYUS_ATLANTA_2017 = 4307
	SEALED_GRAFFITI_FAZE_CLAN_ATLANTA_2017 = 4308
	SEALED_GRAFFITI_FLIPSID3_TACTICS_ATLANTA_2017 = 4309
	SEALED_GRAFFITI_FNATIC_ATLANTA_2017 = 4310
	SEALED_GRAFFITI_G2_ESPORTS_ATLANTA_2017 = 4311
	SEALED_GRAFFITI_GAMBIT_GAMING_ATLANTA_2017 = 4312
	SEALED_GRAFFITI_GODSENT_ATLANTA_2017 = 4313
	SEALED_GRAFFITI_HELLRAISERS_ATLANTA_2017 = 4314
	SEALED_GRAFFITI_MOUSESPORTS_ATLANTA_2017 = 4315
	SEALED_GRAFFITI_NATUS_VINCERE_ATLANTA_2017 = 4316
	SEALED_GRAFFITI_NORTH_ATLANTA_2017 = 4317
	SEALED_GRAFFITI_OPTIC_GAMING_ATLANTA_2017 = 4318
	SEALED_GRAFFITI_SK_GAMING_ATLANTA_2017 = 4319
	SEALED_GRAFFITI_TEAM_LIQUID_ATLANTA_2017 = 4320
	SEALED_GRAFFITI_VIRTUSPRO_ATLANTA_2017 = 4321
	SEALED_GRAFFITI_ELEAGUE_ATLANTA_2017 = 4322
	ATLANTA_2017_LEGENDS_HOLO_FOIL = 4323
	ATLANTA_2017_CHALLENGERS_HOLO_FOIL = 4324
	AUTOGRAPH_CAPSULE_CHALLENGERS_FOIL_ATLANTA_2017 = 4325
	AUTOGRAPH_CAPSULE_LEGENDS_FOIL_ATLANTA_2017 = 4326
	AUTOGRAPH_CAPSULE_ASTRALIS_ATLANTA_2017 = 4327
	AUTOGRAPH_CAPSULE_TEAM_ENVYUS_ATLANTA_2017 = 4328
	AUTOGRAPH_CAPSULE_FAZE_CLAN_ATLANTA_2017 = 4329
	AUTOGRAPH_CAPSULE_FLIPSID3_TACTICS_ATLANTA_2017 = 4330
	AUTOGRAPH_CAPSULE_FNATIC_ATLANTA_2017 = 4331
	AUTOGRAPH_CAPSULE_G2_ESPORTS_ATLANTA_2017 = 4332
	AUTOGRAPH_CAPSULE_GAMBIT_GAMING_ATLANTA_2017 = 4333
	AUTOGRAPH_CAPSULE_GODSENT_ATLANTA_2017 = 4334
	AUTOGRAPH_CAPSULE_HELLRAISERS_ATLANTA_2017 = 4335
	AUTOGRAPH_CAPSULE_MOUSESPORTS_ATLANTA_2017 = 4336
	AUTOGRAPH_CAPSULE_NATUS_VINCERE_ATLANTA_2017 = 4337
	AUTOGRAPH_CAPSULE_NORTH_ATLANTA_2017 = 4338
	AUTOGRAPH_CAPSULE_OPTIC_GAMING_ATLANTA_2017 = 4339
	AUTOGRAPH_CAPSULE_SK_GAMING_ATLANTA_2017 = 4340
	AUTOGRAPH_CAPSULE_TEAM_LIQUID_ATLANTA_2017 = 4341
	AUTOGRAPH_CAPSULE_VIRTUSPRO_ATLANTA_2017 = 4342
	ATLANTA_2017_MEGA_BUNDLE = 4343
	ATLANTA_2017_DUST_II_SOUVENIR_PACKAGE = 4344
	ATLANTA_2017_MIRAGE_SOUVENIR_PACKAGE = 4345
	ATLANTA_2017_COBBLESTONE_SOUVENIR_PACKAGE = 4346
	ATLANTA_2017_OVERPASS_SOUVENIR_PACKAGE = 4347
	ATLANTA_2017_CACHE_SOUVENIR_PACKAGE = 4348
	ATLANTA_2017_TRAIN_SOUVENIR_PACKAGE = 4349
	ATLANTA_2017_NUKE_SOUVENIR_PACKAGE = 4350
	SPECTRUM_CASE = 4351
	OPERATION_HYDRA_CASE = 4352
	OPERATION_HYDRA_CHALLENGE_COIN = 4353
	SILVER_OPERATION_HYDRA_COIN = 4354
	GOLD_OPERATION_HYDRA_COIN = 4355
	DIAMOND_OPERATION_HYDRA_COIN = 4356
	STICKER_ASTRALIS_KRAKOW_2017 = 4357
	STICKER_VIRTUSPRO_KRAKOW_2017 = 4358
	STICKER_FNATIC_KRAKOW_2017 = 4359
	STICKER_SK_GAMING_KRAKOW_2017 = 4360
	STICKER_NATUS_VINCERE_KRAKOW_2017 = 4361
	STICKER_GAMBIT_KRAKOW_2017 = 4362
	STICKER_NORTH_KRAKOW_2017 = 4363
	STICKER_FAZE_CLAN_KRAKOW_2017 = 4364
	STICKER_MOUSESPORTS_KRAKOW_2017 = 4365
	STICKER_G2_ESPORTS_KRAKOW_2017 = 4366
	STICKER_BIG_KRAKOW_2017 = 4367
	STICKER_CLOUD9_KRAKOW_2017 = 4368
	STICKER_PENTA_SPORTS_KRAKOW_2017 = 4369
	STICKER_FLIPSID3_TACTICS_KRAKOW_2017 = 4370
	STICKER_IMMORTALS_KRAKOW_2017 = 4371
	STICKER_VEGA_SQUADRON_KRAKOW_2017 = 4372
	STICKER_PGL_KRAKOW_2017 = 4373
	SEALED_GRAFFITI_ASTRALIS_KRAKOW_2017 = 4374
	SEALED_GRAFFITI_VIRTUSPRO_KRAKOW_2017 = 4375
	SEALED_GRAFFITI_FNATIC_KRAKOW_2017 = 4376
	SEALED_GRAFFITI_SK_GAMING_KRAKOW_2017 = 4377
	SEALED_GRAFFITI_NATUS_VINCERE_KRAKOW_2017 = 4378
	SEALED_GRAFFITI_GAMBIT_KRAKOW_2017 = 4379
	SEALED_GRAFFITI_NORTH_KRAKOW_2017 = 4380
	SEALED_GRAFFITI_FAZE_CLAN_KRAKOW_2017 = 4381
	SEALED_GRAFFITI_MOUSESPORTS_KRAKOW_2017 = 4382
	SEALED_GRAFFITI_G2_ESPORTS_KRAKOW_2017 = 4383
	SEALED_GRAFFITI_BIG_KRAKOW_2017 = 4384
	SEALED_GRAFFITI_CLOUD9_KRAKOW_2017 = 4385
	SEALED_GRAFFITI_PENTA_SPORTS_KRAKOW_2017 = 4386
	SEALED_GRAFFITI_FLIPSID3_TACTICS_KRAKOW_2017 = 4387
	SEALED_GRAFFITI_IMMORTALS_KRAKOW_2017 = 4388
	SEALED_GRAFFITI_VEGA_SQUADRON_KRAKOW_2017 = 4389
	SEALED_GRAFFITI_PGL_KRAKOW_2017 = 4390
	KRAKOW_2017_LEGENDS_HOLO_FOIL = 4391
	KRAKOW_2017_CHALLENGERS_HOLO_FOIL = 4392
	KRAKOW_2017_CHALLENGERS_AUTOGRAPH_CAPSULE = 4393
	KRAKOW_2017_LEGENDS_AUTOGRAPH_CAPSULE = 4394
	KRAKOW_2017_MEGA_BUNDLE = 4395
	KRAKOW_2017_INFERNO_SOUVENIR_PACKAGE = 4396
	KRAKOW_2017_MIRAGE_SOUVENIR_PACKAGE = 4397
	KRAKOW_2017_COBBLESTONE_SOUVENIR_PACKAGE = 4398
	KRAKOW_2017_OVERPASS_SOUVENIR_PACKAGE = 4399
	KRAKOW_2017_CACHE_SOUVENIR_PACKAGE = 4400
	KRAKOW_2017_TRAIN_SOUVENIR_PACKAGE = 4401
	KRAKOW_2017_NUKE_SOUVENIR_PACKAGE = 4402
	SPECTRUM_2_CASE = 4403
	PERFECT_WORLD_STICKER_CAPSULE_1 = 4404
	PERFECT_WORLD_STICKER_CAPSULE_2 = 4405
	STICKER_GAMBIT_ESPORTS_BOSTON_2018 = 4406
	STICKER_100_THIEVES_BOSTON_2018 = 4407
	STICKER_ASTRALIS_BOSTON_2018 = 4408
	STICKER_VIRTUSPRO_BOSTON_2018 = 4409
	STICKER_FNATIC_BOSTON_2018 = 4410
	STICKER_SK_GAMING_BOSTON_2018 = 4411
	STICKER_BIG_BOSTON_2018 = 4412
	STICKER_NORTH_BOSTON_2018 = 4413
	STICKER_G2_ESPORTS_BOSTON_2018 = 4414
	STICKER_CLOUD9_BOSTON_2018 = 4415
	STICKER_FLIPSID3_TACTICS_BOSTON_2018 = 4416
	STICKER_NATUS_VINCERE_BOSTON_2018 = 4417
	STICKER_MOUSESPORTS_BOSTON_2018 = 4418
	STICKER_SPROUT_ESPORTS_BOSTON_2018 = 4419
	STICKER_FAZE_CLAN_BOSTON_2018 = 4420
	STICKER_VEGA_SQUADRON_BOSTON_2018 = 4421
	STICKER_SPACE_SOLDIERS_BOSTON_2018 = 4422
	STICKER_TEAM_LIQUID_BOSTON_2018 = 4423
	STICKER_AVANGAR_BOSTON_2018 = 4424
	STICKER_RENEGADES_BOSTON_2018 = 4425
	STICKER_TEAM_ENVYUS_BOSTON_2018 = 4426
	STICKER_MISFITS_GAMING_BOSTON_2018 = 4427
	STICKER_QUANTUM_BELLATOR_FIRE_BOSTON_2018 = 4428
	STICKER_TYLOO_BOSTON_2018 = 4429
	STICKER_ELEAGUE_BOSTON_2018 = 4430
	SEALED_GRAFFITI_GAMBIT_ESPORTS_BOSTON_2018 = 4431
	SEALED_GRAFFITI_100_THIEVES_BOSTON_2018 = 4432
	SEALED_GRAFFITI_ASTRALIS_BOSTON_2018 = 4433
	SEALED_GRAFFITI_VIRTUSPRO_BOSTON_2018 = 4434
	SEALED_GRAFFITI_FNATIC_BOSTON_2018 = 4435
	SEALED_GRAFFITI_SK_GAMING_BOSTON_2018 = 4436
	SEALED_GRAFFITI_BIG_BOSTON_2018 = 4437
	SEALED_GRAFFITI_NORTH_BOSTON_2018 = 4438
	SEALED_GRAFFITI_G2_ESPORTS_BOSTON_2018 = 4439
	SEALED_GRAFFITI_CLOUD9_BOSTON_2018 = 4440
	SEALED_GRAFFITI_FLIPSID3_TACTICS_BOSTON_2018 = 4441
	SEALED_GRAFFITI_NATUS_VINCERE_BOSTON_2018 = 4442
	SEALED_GRAFFITI_MOUSESPORTS_BOSTON_2018 = 4443
	SEALED_GRAFFITI_SPROUT_ESPORTS_BOSTON_2018 = 4444
	SEALED_GRAFFITI_FAZE_CLAN_BOSTON_2018 = 4445
	SEALED_GRAFFITI_VEGA_SQUADRON_BOSTON_2018 = 4446
	SEALED_GRAFFITI_SPACE_SOLDIERS_BOSTON_2018 = 4447
	SEALED_GRAFFITI_TEAM_LIQUID_BOSTON_2018 = 4448
	SEALED_GRAFFITI_AVANGAR_BOSTON_2018 = 4449
	SEALED_GRAFFITI_RENEGADES_BOSTON_2018 = 4450
	SEALED_GRAFFITI_TEAM_ENVYUS_BOSTON_2018 = 4451
	SEALED_GRAFFITI_MISFITS_GAMING_BOSTON_2018 = 4452
	SEALED_GRAFFITI_QUANTUM_BELLATOR_FIRE_BOSTON_2018 = 4453
	SEALED_GRAFFITI_TYLOO_BOSTON_2018 = 4454
	SEALED_GRAFFITI_ELEAGUE_BOSTON_2018 = 4455
	BOSTON_2018_LEGENDS_HOLO_FOIL = 4456
	BOSTON_2018_RETURNING_CHALLENGERS_HOLO_FOIL = 4457
	BOSTON_2018_MINOR_CHALLENGERS_HOLO_FOIL = 4458
	BOSTON_2018_LEGENDS_AUTOGRAPH_CAPSULE = 4459
	BOSTON_2018_RETURNING_CHALLENGERS_AUTOGRAPH_CAPSULE = 4460
	BOSTON_2018_MINOR_CHALLENGERS_AUTOGRAPH_CAPSULE = 4461
	BOSTON_2018_MEGA_BUNDLE = 4462
	BOSTON_2018_INFERNO_SOUVENIR_PACKAGE = 4463
	BOSTON_2018_MIRAGE_SOUVENIR_PACKAGE = 4464
	BOSTON_2018_COBBLESTONE_SOUVENIR_PACKAGE = 4465
	BOSTON_2018_OVERPASS_SOUVENIR_PACKAGE = 4466
	BOSTON_2018_CACHE_SOUVENIR_PACKAGE = 4467
	BOSTON_2018_TRAIN_SOUVENIR_PACKAGE = 4468
	BOSTON_2018_NUKE_SOUVENIR_PACKAGE = 4469
	COMMUNITY_CAPSULE_2018 = 4470
	CLUTCH_CASE = 4471
	STICKER_FLASH_GAMING_BOSTON_2018 = 4472
	SEALED_GRAFFITI_FLASH_GAMING_BOSTON_2018 = 4473
	BOSTON_2018_MINOR_CHALLENGERS_WITH_FLASH_GAMING_HOLO_FOIL = 4474
	BOSTON_2018_MINOR_CHALLENGERS_WITH_FLASH_GAMING_AUTOGRAPH_CAPSULE = 4475
	BOSTON_2018_MEGA_BUNDLE_2 = 4476
	CHICKEN_CAPSULE = 4477
	BOSTON_2018_ATTENDING_LEGENDS_HOLO_FOIL = 4478
	BOSTON_2018_ATTENDING_LEGENDS_AUTOGRAPH_CAPSULE = 4479
	BOSTON_2018_MEGA_BUNDLE_3 = 4480
	COLLECTIBLE_PINS_CAPSULE_SERIES_3 = 4481
	HORIZON_CASE = 4482
	STICKER_CLOUD9_LONDON_2018 = 4483
	STICKER_FAZE_CLAN_LONDON_2018 = 4484
	STICKER_NATUS_VINCERE_LONDON_2018 = 4485
	STICKER_MIBR_LONDON_2018 = 4486
	STICKER_MOUSESPORTS_LONDON_2018 = 4487
	STICKER_WINSTRIKE_TEAM_LONDON_2018 = 4488
	STICKER_G2_ESPORTS_LONDON_2018 = 4489
	STICKER_FNATIC_LONDON_2018 = 4490
	STICKER_GAMBIT_ESPORTS_LONDON_2018 = 4491
	STICKER_VEGA_SQUADRON_LONDON_2018 = 4492
	STICKER_SPACE_SOLDIERS_LONDON_2018 = 4493
	STICKER_BIG_LONDON_2018 = 4494
	STICKER_ASTRALIS_LONDON_2018 = 4495
	STICKER_TEAM_LIQUID_LONDON_2018 = 4496
	STICKER_NORTH_LONDON_2018 = 4497
	STICKER_VIRTUSPRO_LONDON_2018 = 4498
	STICKER_NINJAS_IN_PYJAMAS_LONDON_2018 = 4499
	STICKER_COMPLEXITY_GAMING_LONDON_2018 = 4500
	STICKER_HELLRAISERS_LONDON_2018 = 4501
	STICKER_RENEGADES_LONDON_2018 = 4502
	STICKER_OPTIC_GAMING_LONDON_2018 = 4503
	STICKER_ROGUE_LONDON_2018 = 4504
	STICKER_TEAM_SPIRIT_LONDON_2018 = 4505
	STICKER_TYLOO_LONDON_2018 = 4506
	STICKER_FACEIT_LONDON_2018 = 4507
	SEALED_GRAFFITI_CLOUD9_LONDON_2018 = 4508
	SEALED_GRAFFITI_FAZE_CLAN_LONDON_2018 = 4509
	SEALED_GRAFFITI_NATUS_VINCERE_LONDON_2018 = 4510
	SEALED_GRAFFITI_MIBR_LONDON_2018 = 4511
	SEALED_GRAFFITI_MOUSESPORTS_LONDON_2018 = 4512
	SEALED_GRAFFITI_WINSTRIKE_TEAM_LONDON_2018 = 4513
	SEALED_GRAFFITI_G2_ESPORTS_LONDON_2018 = 4514
	SEALED_GRAFFITI_FNATIC_LONDON_2018 = 4515
	SEALED_GRAFFITI_GAMBIT_ESPORTS_LONDON_2018 = 4516
	SEALED_GRAFFITI_VEGA_SQUADRON_LONDON_2018 = 4517
	SEALED_GRAFFITI_SPACE_SOLDIERS_LONDON_2018 = 4518
	SEALED_GRAFFITI_BIG_LONDON_2018 = 4519
	SEALED_GRAFFITI_ASTRALIS_LONDON_2018 = 4520
	SEALED_GRAFFITI_TEAM_LIQUID_LONDON_2018 = 4521
	SEALED_GRAFFITI_NORTH_LONDON_2018 = 4522
	SEALED_GRAFFITI_VIRTUSPRO_LONDON_2018 = 4523
	SEALED_GRAFFITI_NINJAS_IN_PYJAMAS_LONDON_2018 = 4524
	SEALED_GRAFFITI_COMPLEXITY_GAMING_LONDON_2018 = 4525
	SEALED_GRAFFITI_HELLRAISERS_LONDON_2018 = 4526
	SEALED_GRAFFITI_RENEGADES_LONDON_2018 = 4527
	SEALED_GRAFFITI_OPTIC_GAMING_LONDON_2018 = 4528
	SEALED_GRAFFITI_ROGUE_LONDON_2018 = 4529
	SEALED_GRAFFITI_TEAM_SPIRIT_LONDON_2018 = 4530
	SEALED_GRAFFITI_TYLOO_LONDON_2018 = 4531
	SEALED_GRAFFITI_FACEIT_LONDON_2018 = 4532
	LONDON_2018_LEGENDS_HOLO_FOIL = 4533
	LONDON_2018_RETURNING_CHALLENGERS_HOLO_FOIL = 4534
	LONDON_2018_MINOR_CHALLENGERS_HOLO_FOIL = 4535
	LONDON_2018_LEGENDS_AUTOGRAPH_CAPSULE = 4536
	LONDON_2018_RETURNING_CHALLENGERS_AUTOGRAPH_CAPSULE = 4537
	LONDON_2018_MINOR_CHALLENGERS_AUTOGRAPH_CAPSULE = 4538
	LONDON_2018_MEGA_BUNDLE = 4539
	LONDON_2018_INFERNO_SOUVENIR_PACKAGE = 4540
	LONDON_2018_MIRAGE_SOUVENIR_PACKAGE = 4541
	LONDON_2018_DUST_II_SOUVENIR_PACKAGE = 4542
	LONDON_2018_OVERPASS_SOUVENIR_PACKAGE = 4543
	LONDON_2018_CACHE_SOUVENIR_PACKAGE = 4544
	LONDON_2018_TRAIN_SOUVENIR_PACKAGE = 4545
	LONDON_2018_NUKE_SOUVENIR_PACKAGE = 4546
	SKILL_GROUPS_CAPSULE = 4547
	DANGER_ZONE_CASE = 4548
	OPERATION_SHATTERED_WEB_PREMIUM_PASS = 4549
	OPERATION_SHATTERED_WEB_CHALLENGE_COIN = 4550
	SILVER_OPERATION_SHATTERED_WEB_COIN = 4551
	GOLD_OPERATION_SHATTERED_WEB_COIN = 4552
	DIAMOND_OPERATION_SHATTERED_WEB_COIN = 4553
	KATOWICE_2019_VIEWER_PASS = 4554
	KATOWICE_2019_COIN = 4555
	KATOWICE_2019_SILVER_COIN = 4556
	KATOWICE_2019_GOLD_COIN = 4557
	KATOWICE_2019_DIAMOND_COIN = 4558
	STICKER_ASTRALIS_KATOWICE_2019 = 4559
	STICKER_AVANGAR_KATOWICE_2019 = 4560
	STICKER_BIG_KATOWICE_2019 = 4561
	STICKER_CLOUD9_KATOWICE_2019 = 4562
	STICKER_COMPLEXITY_GAMING_KATOWICE_2019 = 4563
	STICKER_ENCE_KATOWICE_2019 = 4564
	STICKER_FAZE_CLAN_KATOWICE_2019 = 4565
	STICKER_FNATIC_KATOWICE_2019 = 4566
	STICKER_FURIA_KATOWICE_2019 = 4567
	STICKER_G2_ESPORTS_KATOWICE_2019 = 4568
	STICKER_GRAYHOUND_GAMING_KATOWICE_2019 = 4569
	STICKER_HELLRAISERS_KATOWICE_2019 = 4570
	STICKER_MIBR_KATOWICE_2019 = 4571
	STICKER_NATUS_VINCERE_KATOWICE_2019 = 4572
	STICKER_NINJAS_IN_PYJAMAS_KATOWICE_2019 = 4573
	STICKER_NRG_KATOWICE_2019 = 4574
	STICKER_RENEGADES_KATOWICE_2019 = 4575
	STICKER_TEAM_LIQUID_KATOWICE_2019 = 4576
	STICKER_TEAM_SPIRIT_KATOWICE_2019 = 4577
	STICKER_TYLOO_KATOWICE_2019 = 4578
	STICKER_VEGA_SQUADRON_KATOWICE_2019 = 4579
	STICKER_VICI_GAMING_KATOWICE_2019 = 4580
	STICKER_VITALITY_KATOWICE_2019 = 4581
	STICKER_WINSTRIKE_TEAM_KATOWICE_2019 = 4582
	STICKER_IEM_KATOWICE_2019 = 4583
	KATOWICE_2019_LEGENDS_HOLO_FOIL = 4584
	KATOWICE_2019_RETURNING_CHALLENGERS_HOLO_FOIL = 4585
	KATOWICE_2019_MINOR_CHALLENGERS_HOLO_FOIL = 4586
	KATOWICE_2019_LEGENDS_AUTOGRAPH_CAPSULE = 4587
	KATOWICE_2019_RETURNING_CHALLENGERS_AUTOGRAPH_CAPSULE = 4588
	KATOWICE_2019_MINOR_CHALLENGERS_AUTOGRAPH_CAPSULE = 4589
	KATOWICE_2019_INFERNO_SOUVENIR_PACKAGE = 4590
	KATOWICE_2019_MIRAGE_SOUVENIR_PACKAGE = 4591
	KATOWICE_2019_DUST_II_SOUVENIR_PACKAGE = 4592
	KATOWICE_2019_OVERPASS_SOUVENIR_PACKAGE = 4593
	KATOWICE_2019_CACHE_SOUVENIR_PACKAGE = 4594
	KATOWICE_2019_TRAIN_SOUVENIR_PACKAGE = 4595
	KATOWICE_2019_NUKE_SOUVENIR_PACKAGE = 4596
	HALO_CAPSULE = 4597
	PRISMA_CASE = 4598
	FERAL_PREDATORS_CAPSULE = 4599
	SHATTERED_WEB_STICKER_COLLECTION = 4600
	THE_OVERPASS_COLLECTION = 4601
	THE_COBBLESTONE_COLLECTION = 4602
	THE_CACHE_COLLECTION = 4603
	THE_GODS_AND_MONSTERS_COLLECTION = 4604
	THE_CHOP_SHOP_COLLECTION = 4605
	THE_RISING_SUN_COLLECTION = 4606
	BONUS_RANK_XP = 4607
	THE_CANALS_COLLECTION = 4608
	PATCH = 4609
	CSGO_PATCH_PACK = 4610
	THE_NORSE_COLLECTION = 4611
	THE_ST_MARC_COLLECTION = 4612
	METAL_SKILL_GROUP_PATCH_COLLECTION = 4614
	HALF_LIFE_ALYX_PATCH_PACK = 4615
	WARHAMMER_40000_STICKER_CAPSULE = 4616
	CSGO_GRAFFITI_3_COLLECTION = 4617
	TROLLING_GRAFFITI_COLLECTION = 4618
	BLUEBERRIES_BUCKSHOT_NSWC_SEAL = 4619
	SHATTERED_WEB_CASE = 4620
	CSGO_GRAFFITI_2_COLLECTION = 4621
	BERLIN_2019_VIEWER_PASS = 4622
	BERLIN_2019_COIN = 4623
	BERLIN_2019_SILVER_COIN = 4624
	BERLIN_2019_GOLD_COIN = 4625
	BERLIN_2019_DIAMOND_COIN = 4626
	BERLIN_2019_VIEWER_PASS_AND_3_SOUVENIR_TOKENS = 4627
	BERLIN_2019_SOUVENIR_TOKEN = 4628
	STICKER_ASTRALIS_BERLIN_2019 = 4629
	STICKER_ENCE_BERLIN_2019 = 4630
	STICKER_MIBR_BERLIN_2019 = 4631
	STICKER_NATUS_VINCERE_BERLIN_2019 = 4632
	STICKER_NINJAS_IN_PYJAMAS_BERLIN_2019 = 4633
	STICKER_FAZE_CLAN_BERLIN_2019 = 4634
	STICKER_TEAM_LIQUID_BERLIN_2019 = 4635
	STICKER_RENEGADES_BERLIN_2019 = 4636
	STICKER_COMPLEXITY_GAMING_BERLIN_2019 = 4637
	STICKER_HELLRAISERS_BERLIN_2019 = 4638
	STICKER_AVANGAR_BERLIN_2019 = 4639
	STICKER_G2_ESPORTS_BERLIN_2019 = 4640
	STICKER_VITALITY_BERLIN_2019 = 4641
	STICKER_GRAYHOUND_GAMING_BERLIN_2019 = 4642
	STICKER_MOUSESPORTS_BERLIN_2019 = 4643
	STICKER_FORZE_ESPORTS_BERLIN_2019 = 4644
	STICKER_NRG_BERLIN_2019 = 4645
	STICKER_TYLOO_BERLIN_2019 = 4646
	STICKER_FURIA_BERLIN_2019 = 4647
	STICKER_CR4ZY_BERLIN_2019 = 4648
	STICKER_SYMAN_GAMING_BERLIN_2019 = 4649
	STICKER_NORTH_BERLIN_2019 = 4650
	STICKER_DREAMEATERS_BERLIN_2019 = 4651
	STICKER_INTZ_E_SPORTS_CLUB_BERLIN_2019 = 4652
	STICKER_STARLADDER_BERLIN_2019 = 4653
	BERLIN_2019_LEGENDS_HOLO_FOIL = 4654
	BERLIN_2019_RETURNING_CHALLENGERS_HOLO_FOIL = 4655
	BERLIN_2019_MINOR_CHALLENGERS_HOLO_FOIL = 4656
	BERLIN_2019_LEGENDS_AUTOGRAPH_CAPSULE = 4657
	BERLIN_2019_RETURNING_CHALLENGERS_AUTOGRAPH_CAPSULE = 4658
	BERLIN_2019_MINOR_CHALLENGERS_AUTOGRAPH_CAPSULE = 4659
	BERLIN_2019_INFERNO_SOUVENIR_PACKAGE = 4660
	BERLIN_2019_MIRAGE_SOUVENIR_PACKAGE = 4661
	BERLIN_2019_DUST_II_SOUVENIR_PACKAGE = 4662
	BERLIN_2019_OVERPASS_SOUVENIR_PACKAGE = 4663
	BERLIN_2019_TRAIN_SOUVENIR_PACKAGE = 4664
	BERLIN_2019_NUKE_SOUVENIR_PACKAGE = 4665
	BERLIN_2019_VERTIGO_SOUVENIR_PACKAGE = 4666
	SHATTERED_WEB_STICKER_COLLECTION_2 = 4667
	X_RAY_P250_PACKAGE = 4668
	CS20_CASE = 4669
	CS20_STICKER_CAPSULE = 4670
	ONE_STAR_FOR_OPERATION_SHATTERED_WEB = 4671
	TEN_STARS_FOR_OPERATION_SHATTERED_WEB = 4672
	ONE_HUNDRED_STARS_FOR_OPERATION_SHATTERED_WEB = 4673
	SERVICE_MEDAL_2020_GREY = 4674
	SERVICE_MEDAL_2020_GREEN = 4675
	SERVICE_MEDAL_2020_BLUE = 4676
	SERVICE_MEDAL_2020_PURPLE = 4677
	SERVICE_MEDAL_2020_PINK = 4678
	SERVICE_MEDAL_2020_RED = 4679
	TWO_TIMES_MCCOY_TACP_CAVALRY = 4680
	CIVIL_PROTECTION_PIN = 4682
	SUSTENANCE_PIN = 4683
	VORTIGAUNT_PIN = 4684
	HEADCRAB_GLYPH_PIN = 4685
	HEALTH_PIN = 4686
	LAMBDA_PIN = 4687
	COPPER_LAMBDA_PIN = 4688
	CMB_PIN = 4689
	BLACK_MESA_PIN = 4690
	COMBINE_HELMET_PIN = 4691
	CITY_17_PIN = 4692
	HALF_LIFE_ALYX_COLLECTIBLE_PINS_CAPSULE = 4693
	HALF_LIFE_ALYX_STICKER_CAPSULE = 4694
	PRISMA_2_CASE = 4695
	MASTERMINDS_MUSIC_KIT_BOX = 4696
	STATTRAK_MASTERMINDS_MUSIC_KIT_BOX = 4697
	FRACTURE_CASE = 4698
	OPERATION_BROKEN_FANG_PREMIUM_PASS = 4699
	OPERATION_BROKEN_FANG_CHALLENGE_COIN = 4700
	SILVER_OPERATION_BROKEN_FANG_COIN = 4701
	GOLD_OPERATION_BROKEN_FANG_COIN = 4702
	DIAMOND_OPERATION_BROKEN_FANG_COIN = 4703
	ONE_STAR_FOR_OPERATION_BROKEN_FANG = 4704
	TEN_STARS_FOR_OPERATION_BROKEN_FANG = 4705
	ONE_HUNDRED_STARS_FOR_OPERATION_BROKEN_FANG = 4706
	DISTINGUISHED_AGENTS = 4707
	EXCEPTIONAL_AGENTS = 4708
	SUPERIOR_AGENTS = 4709
	MASTER_AGENT__COMMANDER_MAE = 4710
	CMDR_MAE_DEAD_COLD_JAMISON_SWAT = 4711
	FIRST_LIEUTENANT_FARLOW_SWAT = 4712
	JOHN_VAN_HEALEN_KASK_SWAT = 4713
	BIO_HAZ_SPECIALIST_SWAT = 4714
	SERGEANT_BOMBSON_SWAT = 4715
	CHEM_HAZ_SPECIALIST_SWAT = 4716
	OPERATION_BROKEN_FANG_CASE = 4717
	REZAN_THE_REDSHIRT_SABRE = 4718
	RECOIL_STICKER_COLLECTION = 4719
	THE_CONTROL_COLLECTION = 4720
	THE_HAVOC_COLLECTION = 4721
	THE_ANCIENT_COLLECTION = 4722
	RECOIL_STICKER_COLLECTION_2 = 4723
	MASTER_AGENTS__SIR_BLOODY_DARRYL = 4724
	BROKEN_FANG_GLOVES = 4725
	SIR_BLOODY_MIAMI_DARRYL_THE_PROFESSIONALS = 4726
	SAFECRACKER_VOLTZMANN_THE_PROFESSIONALS = 4727
	LITTLE_KEV_THE_PROFESSIONALS = 4728
	BROKEN_FANG_STICKER_COLLECTION = 4729
	GETAWAY_SALLY_THE_PROFESSIONALS = 4730
	BROKEN_FANG_STICKER_COLLECTION_2 = 4731
	NUMBER_K_THE_PROFESSIONALS = 4732
	SIR_BLOODY_SILENT_DARRYL_THE_PROFESSIONALS = 4733
	SIR_BLOODY_SKULLHEAD_DARRYL_THE_PROFESSIONALS = 4734
	SIR_BLOODY_DARRYL_ROYALE_THE_PROFESSIONALS = 4735
	SIR_BLOODY_LOUDMOUTH_DARRYL_THE_PROFESSIONALS = 4736
	SERVICE_MEDAL_2021_GREY = 4737
	SERVICE_MEDAL_2021_GREEN = 4738
	SERVICE_MEDAL_2021_BLUE = 4739
	SERVICE_MEDAL_2021_PURPLE = 4740
	SERVICE_MEDAL_2021_PINK = 4741
	SERVICE_MEDAL_2021_RED = 4742
	RMR_LEGENDS_2020 = 4743
	RMR_CHALLENGERS_2020 = 4744
	RMR_CONTENDERS_2020 = 4745
	BLOODHOUND_GLOVES = 5027
	DEFAULT_T_GLOVES = 5028
	DEFAULT_CT_GLOVES = 5029
	SPORT_GLOVES = 5030
	DRIVER_GLOVES = 5031
	HAND_WRAPS = 5032
	MOTO_GLOVES = 5033
	SPECIALIST_GLOVES = 5034
	HYDRA_GLOVES = 5035
	LOCAL_T_AGENT = 5036
	LOCAL_CT_AGENT = 5037
	CSGO_CUSTOMPLAYER_TM_ANARCHIST = 5038
	CSGO_CUSTOMPLAYER_TM_ANARCHIST_VARIANTA = 5039
	CSGO_CUSTOMPLAYER_TM_ANARCHIST_VARIANTB = 5040
	CSGO_CUSTOMPLAYER_TM_ANARCHIST_VARIANTC = 5041
	CSGO_CUSTOMPLAYER_TM_ANARCHIST_VARIANTD = 5042
	CSGO_CUSTOMPLAYER_TM_PIRATE = 5043
	CSGO_CUSTOMPLAYER_TM_PIRATE_VARIANTA = 5044
	CSGO_CUSTOMPLAYER_TM_PIRATE_VARIANTB = 5045
	CSGO_CUSTOMPLAYER_TM_PIRATE_VARIANTC = 5046
	CSGO_CUSTOMPLAYER_TM_PIRATE_VARIANTD = 5047
	CSGO_CUSTOMPLAYER_TM_PROFESSIONAL = 5048
	CSGO_CUSTOMPLAYER_TM_PROFESSIONAL_VAR1 = 5049
	CSGO_CUSTOMPLAYER_TM_PROFESSIONAL_VAR2 = 5050
	CSGO_CUSTOMPLAYER_TM_PROFESSIONAL_VAR3 = 5051
	CSGO_CUSTOMPLAYER_TM_PROFESSIONAL_VAR4 = 5052
	CSGO_CUSTOMPLAYER_TM_SEPARATIST = 5053
	CSGO_CUSTOMPLAYER_TM_SEPARATIST_VARIANTA = 5054
	CSGO_CUSTOMPLAYER_TM_SEPARATIST_VARIANTB = 5055
	CSGO_CUSTOMPLAYER_TM_SEPARATIST_VARIANTC = 5056
	CSGO_CUSTOMPLAYER_TM_SEPARATIST_VARIANTD = 5057
	CSGO_CUSTOMPLAYER_CTM_GIGN = 5058
	CSGO_CUSTOMPLAYER_CTM_GIGN_VARIANTA = 5059
	CSGO_CUSTOMPLAYER_CTM_GIGN_VARIANTB = 5060
	CSGO_CUSTOMPLAYER_CTM_GIGN_VARIANTC = 5061
	CSGO_CUSTOMPLAYER_CTM_GIGN_VARIANTD = 5062
	CSGO_CUSTOMPLAYER_CTM_GSG9 = 5063
	CSGO_CUSTOMPLAYER_CTM_GSG9_VARIANTA = 5064
	CSGO_CUSTOMPLAYER_CTM_GSG9_VARIANTB = 5065
	CSGO_CUSTOMPLAYER_CTM_GSG9_VARIANTC = 5066
	CSGO_CUSTOMPLAYER_CTM_GSG9_VARIANTD = 5067
	CSGO_CUSTOMPLAYER_CTM_IDF = 5068
	CSGO_CUSTOMPLAYER_CTM_IDF_VARIANTB = 5069
	CSGO_CUSTOMPLAYER_CTM_IDF_VARIANTC = 5070
	CSGO_CUSTOMPLAYER_CTM_IDF_VARIANTD = 5071
	CSGO_CUSTOMPLAYER_CTM_IDF_VARIANTE = 5072
	CSGO_CUSTOMPLAYER_CTM_IDF_VARIANTF = 5073
	CSGO_CUSTOMPLAYER_CTM_SWAT = 5074
	CSGO_CUSTOMPLAYER_CTM_SWAT_VARIANTA = 5075
	CSGO_CUSTOMPLAYER_CTM_SWAT_VARIANTB = 5076
	CSGO_CUSTOMPLAYER_CTM_SWAT_VARIANTC = 5077
	CSGO_CUSTOMPLAYER_CTM_SWAT_VARIANTD = 5078
	CSGO_CUSTOMPLAYER_CTM_SAS_VARIANTA = 5079
	CSGO_CUSTOMPLAYER_CTM_SAS_VARIANTB = 5080
	CSGO_CUSTOMPLAYER_CTM_SAS_VARIANTC = 5081
	CSGO_CUSTOMPLAYER_CTM_SAS_VARIANTD = 5082
	CSGO_CUSTOMPLAYER_CTM_ST6 = 5083
	CSGO_CUSTOMPLAYER_CTM_ST6_VARIANTA = 5084
	CSGO_CUSTOMPLAYER_CTM_ST6_VARIANTB = 5085
	CSGO_CUSTOMPLAYER_CTM_ST6_VARIANTC = 5086
	CSGO_CUSTOMPLAYER_CTM_ST6_VARIANTD = 5087
	CSGO_CUSTOMPLAYER_TM_BALKAN_VARIANTE = 5088
	CSGO_CUSTOMPLAYER_TM_BALKAN_VARIANTA = 5089
	CSGO_CUSTOMPLAYER_TM_BALKAN_VARIANTB = 5090
	CSGO_CUSTOMPLAYER_TM_BALKAN_VARIANTC = 5091
	CSGO_CUSTOMPLAYER_TM_BALKAN_VARIANTD = 5092
	CSGO_CUSTOMPLAYER_TM_JUMPSUIT_VARIANTA = 5093
	CSGO_CUSTOMPLAYER_TM_JUMPSUIT_VARIANTB = 5094
	CSGO_CUSTOMPLAYER_TM_JUMPSUIT_VARIANTC = 5095
	CSGO_CUSTOMPLAYER_TM_PHOENIX_HEAVY = 5096
	CSGO_CUSTOMPLAYER_CTM_HEAVY = 5097
	CSGO_CUSTOMPLAYER_TM_LEET_VARIANTA = 5100
	CSGO_CUSTOMPLAYER_TM_LEET_VARIANTB = 5101
	CSGO_CUSTOMPLAYER_TM_LEET_VARIANTC = 5102
	CSGO_CUSTOMPLAYER_TM_LEET_VARIANTD = 5103
	CSGO_CUSTOMPLAYER_TM_LEET_VARIANTE = 5104
	GROUND_REBEL__ELITE_CREW = 5105
	OSIRIS_ELITE_CREW = 5106
	PROF_SHAHMAT_ELITE_CREW = 5107
	THE_ELITE_MR_MUHLIK_ELITE_CREW = 5108
	CSGO_CUSTOMPLAYER_TM_PHOENIX = 5200
	CSGO_CUSTOMPLAYER_TM_PHOENIX_VARIANTA = 5201
	CSGO_CUSTOMPLAYER_TM_PHOENIX_VARIANTB = 5202
	CSGO_CUSTOMPLAYER_TM_PHOENIX_VARIANTC = 5203
	CSGO_CUSTOMPLAYER_TM_PHOENIX_VARIANTD = 5204
	SOLDIER_PHOENIX = 5205
	ENFORCER_PHOENIX = 5206
	SLINGSHOT_PHOENIX = 5207
	STREET_SOLDIER_PHOENIX = 5208
	CSGO_CUSTOMPLAYER_CTM_FBI = 5300
	CSGO_CUSTOMPLAYER_CTM_FBI_VARIANTA = 5301
	CSGO_CUSTOMPLAYER_CTM_FBI_VARIANTC = 5302
	CSGO_CUSTOMPLAYER_CTM_FBI_VARIANTD = 5303
	CSGO_CUSTOMPLAYER_CTM_FBI_VARIANTE = 5304
	OPERATOR_FBI_SWAT = 5305
	MARKUS_DELROW_FBI_HRT = 5306
	MICHAEL_SYFERS__FBI_SNIPER = 5307
	SPECIAL_AGENT_AVA_FBI = 5308
	THIRD_COMMANDO_COMPANY_KSK = 5400
	SEAL_TEAM_6_SOLDIER_NSWC_SEAL = 5401
	BUCKSHOT_NSWC_SEAL = 5402
	TWO_TIMES_MCCOY_USAF_TACP = 5403
	LT_COMMANDER_RICKSAW_NSWC_SEAL = 5404
	DRAGOMIR_SABRE = 5500
	MAXIMUS_SABRE = 5501
	REZAN_THE_READY_SABRE = 5502
	BLACKWOLF_SABRE = 5503
	THE_DOCTOR_ROMANOV_SABRE = 5504
	DRAGOMIR_SABRE_FOOTSOLDIER = 5505
	CSGO_CUSTOMPLAYER_CTM_SAS = 5600
	B_SQUADRON_OFFICER_SAS = 5601
	DUST_II_PIN = 6001
	GUARDIAN_ELITE_PIN = 6002
	MIRAGE_PIN = 6003
	INFERNO_PIN = 6004
	ITALY_PIN = 6005
	VICTORY_PIN = 6006
	MILITIA_PIN = 6007
	NUKE_PIN = 6008
	TRAIN_PIN = 6009
	GUARDIAN_PIN = 6010
	TACTICS_PIN = 6011
	GUARDIAN_2_PIN = 6012
	BRAVO_PIN = 6013
	BAGGAGE_PIN = 6014
	PHOENIX_PIN = 6015
	OFFICE_PIN = 6016
	COBBLESTONE_PIN = 6017
	OVERPASS_PIN = 6018
	BLOODHOUND_PIN = 6019
	CACHE_PIN = 6020
	VALERIA_PHOENIX_PIN = 6021
	CHROMA_PIN = 6022
	GUARDIAN_3_PIN = 6023
	CANALS_PIN = 6024
	WELCOME_TO_THE_CLUTCH_PIN = 6025
	DEATH_SENTENCE_PIN = 6026
	INFERNO_2_PIN = 6027
	WILDFIRE_PIN = 6028
	EASY_PEASY_PIN = 6029
	ACES_HIGH_PIN = 6030
	HYDRA_PIN = 6031
	HOWL_PIN = 6032
	BRIGADIER_GENERAL_PIN = 6033
	ALYX_PIN = 6034
	ITEM_6035 = 6035
	ITEM_6036 = 6036
	ITEM_6037 = 6037
	ITEM_6038 = 6038
	ITEM_6039 = 6039
	ITEM_6040 = 6040
	ITEM_6041 = 6041
	ITEM_6042 = 6042
	ITEM_6043 = 6043
	ITEM_6044 = 6044
	ITEM_6045 = 6045
	ITEM_6046 = 6046
	ITEM_6047 = 6047
	ITEM_6048 = 6048
	ITEM_6049 = 6049
	ITEM_6050 = 6050
	ITEM_6051 = 6051
	ITEM_6052 = 6052
	ITEM_6053 = 6053
	ITEM_6054 = 6054
	ITEM_6055 = 6055
	ITEM_6056 = 6056
	ITEM_6057 = 6057
	ITEM_6058 = 6058
	ITEM_6059 = 6059
	ITEM_6060 = 6060
	ITEM_6061 = 6061
	ITEM_6062 = 6062
	ITEM_6063 = 6063
	ITEM_6064 = 6064
	ITEM_6065 = 6065
	ITEM_6066 = 6066
	ITEM_6067 = 6067
	ITEM_6068 = 6068
	ITEM_6069 = 6069
	ITEM_6070 = 6070
	ITEM_6071 = 6071
	ITEM_6072 = 6072
	ITEM_6073 = 6073
	ITEM_6074 = 6074
	ITEM_6075 = 6075
	ITEM_6076 = 6076
	ITEM_6077 = 6077
	ITEM_6078 = 6078
	ITEM_6079 = 6079
	ITEM_6080 = 6080
	ITEM_6081 = 6081
	ITEM_6082 = 6082
	ITEM_6083 = 6083
	ITEM_6084 = 6084
	ITEM_6085 = 6085
	ITEM_6086 = 6086
	ITEM_6087 = 6087
	ITEM_6088 = 6088
	DUST_II_PIN_2 = 6101
	GUARDIAN_ELITE_PIN_2 = 6102
	MIRAGE_PIN_2 = 6103
	INFERNO_PIN_2 = 6104
	ITALY_PIN_2 = 6105
	VICTORY_PIN_2 = 6106
	MILITIA_PIN_2 = 6107
	NUKE_PIN_2 = 6108
	TRAIN_PIN_2 = 6109
	GUARDIAN_PIN_2 = 6110
	TACTICS_PIN_2 = 6111
	GUARDIAN_2_PIN_2 = 6112
	BRAVO_PIN_2 = 6113
	BAGGAGE_PIN_2 = 6114
	PHOENIX_PIN_2 = 6115
	OFFICE_PIN_2 = 6116
	COBBLESTONE_PIN_2 = 6117
	OVERPASS_PIN_2 = 6118
	BLOODHOUND_PIN_2 = 6119
	CACHE_PIN_2 = 6120
	VALERIA_PHOENIX_PIN_2 = 6121
	CHROMA_PIN_2 = 6122
	GUARDIAN_3_PIN_2 = 6123
	CANALS_PIN_2 = 6124
	WELCOME_TO_THE_CLUTCH_PIN_2 = 6125
	DEATH_SENTENCE_PIN_2 = 6126
	INFERNO_2_PIN_2 = 6127
	WILDFIRE_PIN_2 = 6128
	EASY_PEASY_PIN_2 = 6129
	ACES_HIGH_PIN_2 = 6130
	HYDRA_PIN_2 = 6131
	HOWL_PIN_2 = 6132
	BRIGADIER_GENERAL_PIN_2 = 6133
	ALYX_PIN_2 = 6134
	DISTINGUISHED_AGENTS_2 = 6404
	EXCEPTIONAL_AGENTS_2 = 6405
	SUPERIOR_AGENTS_2 = 6406
	MASTER_AGENTS_2 = 6407
	OPERATION_WILDFIRE_CASE_KEY = 7000
	STICKER_BOSSY_BURGER = 20000
	STICKER_CAT_CALL = 20001
	STICKER_CHICKEN_STRIKE = 20002
	STICKER_CT_IN_BANANA = 20003
	STICKER_DONT_WORRY_IM_PRO = 20004
	STICKER_FIGHT_LIKE_A_GIRL = 20005
	STICKER_FLASHBANG = 20006
	STICKER_KAWAII_KILLER_CT = 20007
	STICKER_NELU_THE_BEAR = 20008
	STICKER_ONE_SHOT_ONE_KILL = 20009
	STICKER_SHOOTING_STAR_RETURN = 20010
	STICKER_WAR_PENGUIN = 20012
	STICKER_WINDY_WALKING_CLUB = 20013
	STICKER_BLITZKRIEG = 20014
	STICKER_PIGEON_MASTER = 20015
	STICKER_TERRORIZED = 20016
	STICKER_TILL_DEATH_DO_US_PART = 20017
	STICKER_STAY_FROSTY = 20018
	STICKER_T_ON_CAT = 20019
	MUSIC_KIT_DANIEL_SADOWSKI_CRIMSON_ASSAULT = 20020
	MUSIC_KIT_NOISIA_SHARPENED = 20021
	MUSIC_KIT_ROBERT_ALLAIRE_INSURGENCY = 20022
	MUSIC_KIT_SEAN_MURRAY_AD8 = 20023
	MUSIC_KIT_FEED_ME_HIGH_NOON = 20024
	MUSIC_KIT_DREN_DEATHS_HEAD_DEMOLITION = 20025
	MUSIC_KIT_AUSTIN_WINTORY_DESERT_FIRE = 20026
	MUSIC_KIT_SASHA_LNOE = 20027
	MUSIC_KIT_SKOG_METAL = 20028
	STICKER_DOOMED = 20029
	STICKER_QUEEN_OF_PAIN = 20030
	STICKER_TRICK_OR_THREAT = 20031
	STICKER_TRICK_OR_TREAT = 20032
	STICKER_WITCH = 20033
	STICKER_ZOMBIE_LOVER = 20034
	STICKER_BLOOD_BOILER = 20035
	STICKER_DINKED = 20036
	STICKER_DRUG_WAR_VETERAN = 20037
	STICKER_HO_HO_HO = 20038
	STICKER_MASSIVE_PEAR = 20039
	STICKER_MY_LITTLE_FRIEND = 20040
	STICKER_PANDAMONIUM = 20041
	STICKER_PIECE_OF_CAKE = 20042
	STICKER_SAS_CHICKEN = 20043
	STICKER_THUG_LIFE = 20044
	STICKER_T_REKT = 20045
	STICKER_WAROWL = 20046
	STICKER_WORK_FOR_AMMO = 20047
	STICKER_PHOENIX_FOIL = 20048
	STICKER_BOMB_SQUAD_FOIL = 20049
	MUSIC_KIT_MIDNIGHT_RIDERS_ALL_I_WANT_FOR_CHRISTMAS = 20050
	MUSIC_KIT_DANIEL_SADOWSKI_TOTAL_DOMINATION = 20051
	MUSIC_KIT_VARIOUS_ARTISTS_HOTLINE_MIAMI = 20052
	MUSIC_KIT_MATT_LANGE_ISORHYTHM = 20053
	MUSIC_KIT_MATEO_MESSINA_FOR_NO_MANKIND = 20054
	MUSIC_KIT_DAMJAN_MRAVUNAC_THE_TALOS_PRINCIPLE = 20055
	STICKER_FLICKSHOT = 20056
	STICKER_HEADSHOT_GUARANTEE = 20057
	STICKER_ECO_RUSH = 20058
	STICKER_JUST_TROLLING = 20059
	STICKER_FIRESTARTER_HOLO = 20061
	STICKER_LUCKY_CAT_FOIL = 20062
	STICKER_ROBO = 20063
	STICKER_WITCHCRAFT = 20064
	STICKER_WANNA_FIGHT = 20065
	STICKER_HOSTAGE_RESCUE = 20066
	STICKER_HAMSTER_HAWK = 20067
	STICKER_HEADLESS_CHICKEN = 20068
	MUSIC_KIT_PROXY_BATTLEPACK = 20069
	MUSIC_KIT_KITHEORY_MOLOTOV = 20070
	MUSIC_KIT_TROELS_FOLMANN_UBER_BLASTO_PHONE = 20071
	MUSIC_KIT_KELLY_BAILEY_HAZARDOUS_ENVIRONMENTS = 20072
	MUSIC_KIT_SKOG_II_HEADSHOT = 20073
	ENFU_STICKER_CAPSULE_2 = 20074
	STICKER_AWP_COUNTRY = 20075
	STICKER_CHI_BOMB = 20076
	STICKER_DORU_THE_FOX = 20077
	STICKER_KNIFE_CLUB = 20078
	STICKER_CS_ON_THE_MIND = 20079
	STICKER_NINJA_DEFUSE = 20080
	STICKER_PROS_DONT_FAKE = 20081
	STICKER_KAWAII_KILLER_TERRORIST = 20082
	STICKER_BAAA_CKSTABBER = 20083
	STICKER_DELICIOUS_TEARS = 20084
	MUSIC_KIT_DANIEL_SADOWSKI_THE_8_BIT_KIT = 20085
	MUSIC_KIT_AWOLNATION_I_AM = 20086
	MUSIC_KIT_MORD_FUSTANG_DIAMONDS = 20087
	MUSIC_KIT_MICHAEL_BROSS_INVASION = 20088
	MUSIC_KIT_IAN_HULTQUIST_LIONS_MOUTH = 20089
	MUSIC_KIT_NEW_BEAT_FUND_SPONGE_FINGERZ = 20090
	MUSIC_KIT_BEARTOOTH_DISGUSTING = 20091
	MUSIC_KIT_LENNIE_MOORE_JAVA_HAVANA_FUNKALOO = 20092
	MUSIC_KIT_DARUDE_MOMENTS_CSGO = 20093
	STATTRAK_MUSIC_KIT_PROXY_BATTLEPACK = 20094
	STATTRAK_MUSIC_KIT_KITHEORY_MOLOTOV = 20095
	STATTRAK_MUSIC_KIT_TROELS_FOLMANN_UBER_BLASTO_PHONE = 20096
	STATTRAK_MUSIC_KIT_KELLY_BAILEY_HAZARDOUS_ENVIRONMENTS = 20097
	STATTRAK_MUSIC_KIT_SKOG_II_HEADSHOT = 20098
	STATTRAK_MUSIC_KIT_DANIEL_SADOWSKI_THE_8_BIT_KIT = 20099
	STATTRAK_MUSIC_KIT_AWOLNATION_I_AM = 20100
	STATTRAK_MUSIC_KIT_MORD_FUSTANG_DIAMONDS = 20101
	STATTRAK_MUSIC_KIT_MICHAEL_BROSS_INVASION = 20102
	STATTRAK_MUSIC_KIT_IAN_HULTQUIST_LIONS_MOUTH = 20103
	STATTRAK_MUSIC_KIT_NEW_BEAT_FUND_SPONGE_FINGERZ = 20104
	STATTRAK_MUSIC_KIT_BEARTOOTH_DISGUSTING = 20105
	STATTRAK_MUSIC_KIT_LENNIE_MOORE_JAVA_HAVANA_FUNKALOO = 20106
	STATTRAK_MUSIC_KIT_DARUDE_MOMENTS_CSGO = 20107
	STATTRAK_MUSIC_KIT_DANIEL_SADOWSKI_CRIMSON_ASSAULT = 20108
	STATTRAK_MUSIC_KIT_NOISIA_SHARPENED = 20109
	STATTRAK_MUSIC_KIT_ROBERT_ALLAIRE_INSURGENCY = 20110
	STATTRAK_MUSIC_KIT_SEAN_MURRAY_AD8 = 20111
	STATTRAK_MUSIC_KIT_FEED_ME_HIGH_NOON = 20112
	STATTRAK_MUSIC_KIT_DREN_DEATHS_HEAD_DEMOLITION = 20113
	STATTRAK_MUSIC_KIT_AUSTIN_WINTORY_DESERT_FIRE = 20114
	STATTRAK_MUSIC_KIT_SASHA_LNOE = 20115
	STATTRAK_MUSIC_KIT_SKOG_METAL = 20116
	STATTRAK_MUSIC_KIT_MIDNIGHT_RIDERS_ALL_I_WANT_FOR_CHRISTMAS = 20117
	STATTRAK_MUSIC_KIT_DANIEL_SADOWSKI_TOTAL_DOMINATION = 20118
	STATTRAK_MUSIC_KIT_VARIOUS_ARTISTS_HOTLINE_MIAMI = 20119
	STATTRAK_MUSIC_KIT_MATT_LANGE_ISORHYTHM = 20120
	STATTRAK_MUSIC_KIT_MATEO_MESSINA_FOR_NO_MANKIND = 20121
	STATTRAK_MUSIC_KIT_DAMJAN_MRAVUNAC_THE_TALOS_PRINCIPLE = 20122
	PINUPS_STICKER_CAPSULE = 20123
	SLID3_STICKER_CAPSULE = 20124
	TEAM_ROLES_STICKER_CAPSULE = 20125
	COLLECTIBLE_PINS_CAPSULE_SERIES_1_2 = 20126
	SUGARFACE_STICKER_CAPSULE = 20127
	BESTIARY_STICKER_CAPSULE = 20128
	CSGO_GRAFFITI_BOX_2 = 20129
	COMMUNITY_GRAFFITI_BOX_1_2 = 20130
	COLLECTIBLE_PINS_CAPSULE_SERIES_2_2 = 20131
	STATTRAK_RADICALS_MUSIC_KIT_BOX = 20133
	PERFECT_WORLD_STICKER_CAPSULE_1_2 = 20134
	PERFECT_WORLD_STICKER_CAPSULE_2_2 = 20135
	PERFECT_WORLD_GRAFFITI_BOX_2 = 20136
	COMMUNITY_CAPSULE_2018_2 = 20137
	COLLECTIBLE_PINS_CAPSULE_SERIES_3_2 = 20138
	SKILL_GROUPS_CAPSULE_2 = 20139
	MUSIC_KIT_THE_VERKKARS_EZ4ENCE = 20140
	STATTRAK_MUSIC_KIT_THE_VERKKARS_EZ4ENCE = 20141
	FERAL_PREDATORS_STICKER_CAPSULE = 20142
	CHICKEN_CAPSULE_2 = 20143
	X_RAY_P250_PACKAGE_2 = 20144
	CS20_STICKER_CAPSULE_2 = 20145
	HALO_STICKER_CAPSULE = 20146
	MUSIC_KIT_SCARLXRD_KING_SCAR = 20147
	STATTRAK_MUSIC_KIT_SCARLXRD_KING_SCAR = 20148
	CSGO_PATCH_PACK_2 = 20149
	HALF_LIFE_ALYX_COLLECTIBLE_PINS_CAPSULE_2 = 20152
	HALF_LIFE_ALYX_STICKER_CAPSULE_2 = 20153
	HALF_LIFE_ALYX_PATCH_PACK_2 = 20154
	MASTERMINDS_MUSIC_KIT_BOX_2 = 20169
	STATTRAK_MASTERMINDS_MUSIC_KIT_BOX_2 = 20170
	WARHAMMER_40000_STICKER_CAPSULE_2 = 20171
	MUSIC_KIT_AMON_TOBIN_ALL_FOR_DUST = 20172
	STATTRAK_MUSIC_KIT_AMON_TOBIN_ALL_FOR_DUST = 20173
	DAILY_PAYMENT_FOR_MAP_DE_CACHE_STARTING_2018_10_10 = 30001
	DAILY_PAYMENT_FOR_MAP_CS_AGENCY_STARTING_2018_10_10 = 30002
	DAILY_PAYMENT_FOR_MAP_DE_AUSTRIA_STARTING_2018_10_10 = 30003
	DAILY_PAYMENT_FOR_MAP_DE_SUBZERO_STARTING_2018_10_10 = 30004
	DAILY_PAYMENT_FOR_MAP_DE_BIOME_STARTING_2018_10_10 = 30005
	DAILY_PAYMENT_FOR_MAP_DE_ZOO_STARTING_2019_01_24 = 30006
	DAILY_PAYMENT_FOR_MAP_DE_ABBEY_STARTING_2019_01_24 = 30007
	DAILY_PAYMENT_FOR_MAP_DE_RUBY_STARTING_2019_04_26 = 30008
	DAILY_PAYMENT_FOR_MAP_CS_WORKOUT_STARTING_2019_04_26 = 30009
	DAILY_PAYMENT_FOR_MAP_DE_BREACH_STARTING_2019_08_01 = 30010
	DAILY_PAYMENT_FOR_MAP_DE_SEASIDE_STARTING_2019_08_01 = 30011
	DAILY_PAYMENT_FOR_MAP_DE_CACHE_STARTING_2019_10_19 = 30012
	DAILY_PAYMENT_FOR_MAP_DE_STUDIO_STARTING_2019_11_19 = 30013
	DAILY_PAYMENT_FOR_MAP_DZ_JUNGLETY_STARTING_2019_11_19 = 30014
	DAILY_PAYMENT_FOR_MAP_DE_ANUBIS_STARTING_2020_04_01 = 30015
	DAILY_PAYMENT_FOR_MAP_DE_CHLORINE_STARTING_2020_04_01 = 30016
	DAILY_PAYMENT_FOR_MAP_DE_MUTINY_STARTING_2020_07_24 = 30017
	DAILY_PAYMENT_FOR_MAP_DE_SWAMP_STARTING_2020_07_24 = 30018
	DAILY_PAYMENT_FOR_MAP_DZ_FROSTBITE_STARTING_2020_12_04 = 30019
	DAILY_PAYMENT_FOR_MAP_DE_ENGAGE_STARTING_2020_12_04 = 30020
	DAILY_PAYMENT_FOR_MAP_CS_APOLLO_STARTING_2020_12_04 = 30021
	DAILY_PAYMENT_FOR_MAP_DE_GUARD_STARTING_2020_12_04 = 30022
	DAILY_PAYMENT_FOR_MAP_DE_ELYSION_STARTING_2020_12_04 = 30023

	




