from concurrent.futures import ThreadPoolExecutor

from liteutils import read_arxiv

from .searchlite import google
from .parselite import parse
from .visionlite import wlanswer,wlsplit
from litegen import genai


def web(
    query: str,
    retreive_query: str = None,
    max_urls: int = 1,
    k: int | None = None
):
    docs = parse(google(query, max_urls=max_urls))
    context = "\n".join([d.content for d in docs if d.content])
    if retreive_query:
        return wlanswer(context, retreive_query or query, k=k or 1)
    if k:
        return wlanswer(context,retreive_query or query, k=k)

    return context

def compress_sequential(text):
    chunks = wlsplit(text)
    res = ""
    for c in chunks:
        res += genai(prompt=f"compress and have simple explanation with core details to takeaway, like 100 to 10 words ration compression: [CONTENT]\n {c}")+"\n"
    return res


def compress(text):
    chunks = wlsplit(text)[:5]
    res = ""
    def generate(c):
        return genai(prompt=f"compress and have simple explanation with core details to takeaway, like 100 to 10 words ration compression: [CONTENT]\n {c}")+"\n"
    with ThreadPoolExecutor(max_workers=4) as executor:
        res = list(executor.map(generate,chunks))
    return "\n".join(res)

def get_summaries(df):
    df['basic'] = ''
    df['summary'] = ''
    df['keypoints'] = ''
    df['tweet'] = ''
    for i,d in df.iterrows():
        basic = compress(read_arxiv(d['pdf_url']))
        summary = compress(basic)
        keypoints = compress(summary)
        tweet = compress(keypoints)
        # Update the DataFrame with the new values
        df.at[i, 'simplified'] = basic
        df.at[i, 'summary'] = summary
        df.at[i, 'keypoints'] = keypoints
        df.at[i, 'tweet'] = tweet
    return df
