# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-03-11 09:43
from __future__ import absolute_import, unicode_literals

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import opaque_keys.edx.django.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ContentDate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('course_id', opaque_keys.edx.django.models.CourseKeyField(db_index=True, max_length=255)),
                ('location', opaque_keys.edx.django.models.BlockTypeKeyField(db_index=True, default=None, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DatePolicy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('abs_date', models.DateTimeField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UserDate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('abs_date', models.DateTimeField(null=True)),
                ('rel_date', models.IntegerField(null=True)),
                ('reason', models.TextField(default='')),
                ('actor', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='actor', to=settings.AUTH_USER_MODEL)),
                ('policy', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='edx_when.DatePolicy')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='contentdate',
            name='policy',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='edx_when.DatePolicy'),
        ),
        migrations.AlterUniqueTogether(
            name='contentdate',
            unique_together=set([('policy', 'location')]),
        ),
    ]
